## TFSA-2021-132: Reference binding to nullptr in `MatrixSetDiagV*` ops

### CVE Number
CVE-2021-37658

### Impact
An attacker can cause undefined behavior via binding a reference to null pointer
in all operations of type `tf.raw_ops.MatrixSetDiagV*`:

```python
import tensorflow as tf

tf.raw_ops.MatrixSetDiagV3(
  input=[1,2,3],
  diagonal=[1,1],
  k=[],
  align='RIGHT_LEFT')
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/84d053187cb80d975ef2b9684d4b61981bca0c41/tensorflow/core/kernels/linalg/matrix_diag_op.cc)
has incomplete validation that the value of `k` is a valid tensor. We have check
that this value is either a scalar or a vector, but there is no check for the
number of elements. If this is an empty tensor, then code that accesses the
first element of the tensor is wrong:

```cc
  auto& diag_index = context->input(1);
  ...
  lower_diag_index = diag_index.flat<int32>()(0);
```

### Patches
We have patched the issue in GitHub commit
[ff8894044dfae5568ecbf2ed514c1a37dc394f1b](https://github.com/tensorflow/tensorflow/commit/ff8894044dfae5568ecbf2ed514c1a37dc394f1b).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
