/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.AngularDistanceComputer;
import cds.healpix.CompassPoint;
import cds.healpix.ConeOrdinalHashComputer;
import cds.healpix.FlatHashList;
import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.HealpixNestedFixedRadiusConeComputer;
import cds.healpix.NeighbourSelector;
import cds.healpix.SettableHashParts;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.math.FastMath;
import cds.healpix.common.math.HackersDelight;
import cds.healpix.common.math.Math;
import java.util.EnumMap;

final class NestedSmallCell
implements HealpixNestedFixedRadiusConeComputer {
    private final int nIterMax;
    private final double relativePrecision;
    private final int startingDepth;
    private final int deeperDepth;
    private final int deltaDepthMax;
    private final HealpixNested[] hns;
    private final VerticesAndPathComputer[] vpComputers;
    private final int startingNside;
    private final int startingNsideTime3;
    private final int startingNsideTime4;
    private final double rRad;
    private final double twoSineOfHalfConeRadius;
    private final double squareOfsinOfHalfR;
    private final HashComputer hComputerStartingDepth;
    private final HashComputer hComputerDepthMax;
    private final NeighbourSelector neigSelector;
    private final ConeOrdinalHashComputer cohc;
    private final AngularDistanceComputer angDistComputer;
    private final double[] center = new double[2];
    private final EnumMap<CompassPoint.Cardinal, double[]> vertices = new EnumMap(CompassPoint.Cardinal.class);
    private final FlatHashList neigList;
    private final long[] specialHashs = new long[5];
    private int iSpecialHash;
    private int baseCellHash;
    private int iInBaseCell;
    private int jInBaseCell;
    private int smallestCornerRingIndex;
    private final SettableHashParts hashPartsProxy = new SettableHashParts(){

        @Override
        public int baseCellHash() {
            return NestedSmallCell.this.baseCellHash;
        }

        @Override
        public int iInBaseCell() {
            return NestedSmallCell.this.iInBaseCell;
        }

        @Override
        public int jInBaseCell() {
            return NestedSmallCell.this.jInBaseCell;
        }

        @Override
        public void setBaseCellHash(int baseCelHash) {
            NestedSmallCell.this.baseCellHash = baseCelHash;
        }

        @Override
        public void setIInBaseCell(int iInBaseCel) {
            NestedSmallCell.this.iInBaseCell = iInBaseCel;
        }

        @Override
        public void setJInBaseCell(int jInBaseCel) {
            NestedSmallCell.this.jInBaseCell = jInBaseCel;
        }
    };
    private static final AdditionalCheck ALWAYS_TRUE = new AdditionalCheck(){

        @Override
        public boolean isOk(int deltaDepth, long hash, double[] deltasLon, double coneCenterLonRad) {
            return true;
        }
    };
    private static final AdditionalCheck ALWAYS_FALSE = new AdditionalCheck(){

        @Override
        public boolean isOk(int deltaDepth, long hash, double[] deltasLon, double coneCenterLonRad) {
            return false;
        }
    };
    private final AdditionalCheck centerInCone = new AdditionalCheck(){

        @Override
        public boolean isOk(int deltaDepth, long hash, double[] deltasLon, double coneCenterLonRad) {
            return NestedSmallCell.this.containsCenter(deltaDepth, hash, deltasLon, coneCenterLonRad);
        }
    };

    public NestedSmallCell(int startingDepth, int deeperDepth, double radiusRad, ConeOrdinalHashComputer cohc) {
        this(startingDepth, deeperDepth, radiusRad, cohc, radiusRad * 1.0E-4, 10);
    }

    protected NestedSmallCell(int startingDepth, int deeperDepth, double radiusRad, ConeOrdinalHashComputer cohc, double eps, int nIterMax) {
        assert (radiusRad > 0.0);
        this.startingDepth = startingDepth;
        this.deeperDepth = deeperDepth;
        this.deltaDepthMax = this.deeperDepth - this.startingDepth;
        this.hns = new HealpixNested[this.deltaDepthMax + 1];
        this.vpComputers = new VerticesAndPathComputer[this.deltaDepthMax + 1];
        for (int i = 0; i <= this.deltaDepthMax; ++i) {
            HealpixNested hn;
            this.hns[i] = hn = Healpix.getNested(this.startingDepth + i);
            this.vpComputers[i] = hn.newVerticesAndPathComputer();
        }
        this.rRad = radiusRad;
        this.relativePrecision = this.rRad * eps;
        this.nIterMax = nIterMax;
        this.angDistComputer = AngularDistanceComputer.getComputer(this.rRad);
        double sinHalfR = this.angDistComputer.sin(0.5 * this.rRad);
        this.twoSineOfHalfConeRadius = 2.0 * sinHalfR;
        this.squareOfsinOfHalfR = sinHalfR * sinHalfR;
        this.hComputerDepthMax = this.hns[this.deltaDepthMax].newHashComputer();
        HealpixNested hn0 = this.hns[0];
        this.hComputerStartingDepth = hn0.newHashComputer();
        this.neigSelector = hn0.newNeighbourSelector();
        this.startingNside = Healpix.nside(this.startingDepth);
        this.startingNsideTime3 = hn0.nsideTime(3);
        this.startingNsideTime4 = hn0.nsideTime(4);
        this.cohc = cohc;
        this.neigList = new FlatHashList(-1, 9);
        this.initVerticesMap();
    }

    private final void initVerticesMap() {
        for (CompassPoint.Cardinal c : CompassPoint.Cardinal.values()) {
            this.vertices.put(c, new double[2]);
        }
    }

    protected static final int nElemMax(int nRings, int nRingOtherSideOfThePole) {
        return 8 * (nRings + nRingOtherSideOfThePole);
    }

    @Override
    public final double getRadius() {
        return this.rRad;
    }

    @Override
    public HealpixNestedFixedRadiusConeComputer newComputer() {
        return new NestedSmallCell(this.startingDepth, this.deeperDepth, this.rRad, this.cohc);
    }

    @Override
    public final HealpixNestedBMOC overlappingCells(double coneCenterLonRad, double coneCenterLatRad) {
        return this.overlapping(coneCenterLonRad, coneCenterLatRad, ALWAYS_TRUE);
    }

    @Override
    public HealpixNestedBMOC overlappingCenters(double coneCenterLonRad, double coneCenterLatRad) {
        return this.overlapping(coneCenterLonRad, coneCenterLatRad, this.centerInCone);
    }

    @Override
    public HealpixNestedBMOC overlappingCells(double coneCenterLonRad, double coneCenterLatRad, HealpixNestedFixedRadiusConeComputer.ReturnedCells returnedCells) {
        switch (returnedCells) {
            case FULLY_IN: {
                return this.overlapping(coneCenterLonRad, coneCenterLatRad, ALWAYS_FALSE);
            }
            case OVERLAPPING: {
                return this.overlappingCells(coneCenterLonRad, coneCenterLatRad);
            }
            case CENTER_IN: {
                return this.overlappingCenters(coneCenterLonRad, coneCenterLatRad);
            }
        }
        throw new Error("Type " + (Object)((Object)returnedCells) + " not implemented!");
    }

    public final HealpixNestedBMOC overlapping(double coneCenterLonRad, double coneCenterLatRad, AdditionalCheck check) {
        int nIsolatRings;
        double cosConeCenterLat = Math.cos(coneCenterLatRad);
        double sinConeCenterLat = Math.sin(coneCenterLatRad);
        coneCenterLonRad = NestedSmallCell.normalizeLon(coneCenterLonRad);
        assert (0.0 <= coneCenterLonRad && coneCenterLonRad <= java.lang.Math.PI * 2);
        long centerHash = this.hComputerStartingDepth.hash(coneCenterLonRad, coneCenterLatRad);
        assert (-1.5707963267948966 <= coneCenterLatRad && coneCenterLatRad <= 1.5707963267948966);
        int nRingsOtherSideOfPole = 0;
        this.smallestCornerRingIndex = -1;
        double latMax = coneCenterLatRad + this.rRad;
        if (latMax > 1.5707963267948966) {
            nRingsOtherSideOfPole = this.ringIndex(this.deltaDepthMax, this.hComputerDepthMax.hash(coneCenterLonRad + java.lang.Math.PI, java.lang.Math.PI - latMax)) + 1;
            latMax = 1.5707963267948966;
        } else {
            this.smallestCornerRingIndex = java.lang.Math.max(this.smallestCornerRingIndex, this.ringIndex(this.deltaDepthMax, this.hComputerDepthMax.hash(coneCenterLonRad, latMax)) - 1);
        }
        int largestCornerRingIndex = nIsolatRings = Healpix.nIsolatitudeRings(this.deeperDepth);
        double latMin = coneCenterLatRad - this.rRad;
        if (latMin < -1.5707963267948966) {
            nRingsOtherSideOfPole = largestCornerRingIndex - this.ringIndex(this.deltaDepthMax, this.hComputerDepthMax.hash(coneCenterLonRad + java.lang.Math.PI, -java.lang.Math.PI - latMin));
            latMin = -1.5707963267948966;
        } else {
            largestCornerRingIndex = java.lang.Math.min(largestCornerRingIndex, this.ringIndex(this.deltaDepthMax, this.hComputerDepthMax.hash(coneCenterLonRad, latMin)) + 1);
        }
        int nRings = largestCornerRingIndex - this.smallestCornerRingIndex + 1;
        double[] deltasLon = new double[nRings];
        for (int i = 0; i < nRings; ++i) {
            double ringLat = this.latOf(this.deltaDepthMax, this.smallestCornerRingIndex + i);
            deltasLon[i] = this.deltaLon(ringLat - coneCenterLatRad, Math.cos(ringLat), cosConeCenterLat);
        }
        if (this.smallestCornerRingIndex == -1) {
            deltasLon[0] = java.lang.Math.PI;
        }
        if (largestCornerRingIndex == nIsolatRings) {
            deltasLon[nRings - 1] = java.lang.Math.PI;
        }
        this.iSpecialHash = this.cohc.computeOrdinalHash(coneCenterLonRad, coneCenterLatRad, this.rRad, this.hComputerDepthMax, this.angDistComputer, this.relativePrecision, this.nIterMax, centerHash, this.vpComputers[0], this.vertices, cosConeCenterLat, sinConeCenterLat, this.twoSineOfHalfConeRadius, this.squareOfsinOfHalfR, this.specialHashs);
        this.specialHashs[4] = centerHash;
        this.neigSelector.neighbours(centerHash, this.neigList);
        this.neigList.put(centerHash);
        this.neigList.sortByHashAsc();
        long[] mocElems = new long[NestedSmallCell.nElemMax(nRings, nRingsOtherSideOfPole)];
        int mocSize = 0;
        for (int i = 0; i < this.neigList.size(); ++i) {
            mocSize = this.buildMocRecursively(mocElems, mocSize, 0, this.neigList.get(i), deltasLon, coneCenterLonRad, check);
        }
        return HealpixNestedBMOC.createUnsafe(this.deeperDepth, mocElems, mocSize);
    }

    private final int buildMocRecursively(long[] moc, int mocLength, int deltaDepth, long hash, double[] deltasLon, double coneCenterLonRad, AdditionalCheck check) {
        int nV = this.nVerticesInLonRanges(deltaDepth, hash, deltasLon, coneCenterLonRad);
        if (nV == 4) {
            moc[mocLength++] = HealpixNestedBMOC.buildValue(this.startingDepth + deltaDepth, hash, true, this.deeperDepth);
        } else if (nV > 0 || this.isInSpecialHash(this.deltaDepthMax - deltaDepth, hash)) {
            if (deltaDepth == this.deltaDepthMax) {
                assert (this.startingDepth + deltaDepth == this.deeperDepth);
                if (check.isOk(deltaDepth, hash, deltasLon, coneCenterLonRad)) {
                    moc[mocLength++] = HealpixNestedBMOC.buildValue(this.deeperDepth, hash, false, this.deeperDepth);
                }
            } else {
                mocLength = this.buildMocRecursively(moc, mocLength, ++deltaDepth, hash <<= 2, deltasLon, coneCenterLonRad, check);
                mocLength = this.buildMocRecursively(moc, mocLength, deltaDepth, ++hash, deltasLon, coneCenterLonRad, check);
                mocLength = this.buildMocRecursively(moc, mocLength, deltaDepth, ++hash, deltasLon, coneCenterLonRad, check);
                mocLength = this.buildMocRecursively(moc, mocLength, deltaDepth, ++hash, deltasLon, coneCenterLonRad, check);
            }
        }
        return mocLength;
    }

    private final int nVerticesInLonRanges(int deltaDepth, long hash, double[] deltasLon, double coneCenterLonRad) {
        int dd = this.deltaDepthMax - deltaDepth;
        int nside = 1 << dd;
        long hashAtDepthMax = hash << (dd << 1);
        int ringIndexMax = this.ringIndex(this.deltaDepthMax, hashAtDepthMax) + 1 - this.smallestCornerRingIndex;
        int ringIndexCenter = ringIndexMax - nside;
        int ringIndexMin = ringIndexCenter - nside;
        this.vpComputers[deltaDepth].vertices(hash, this.vertices);
        int n = 0;
        if (0 <= ringIndexMin && ringIndexMin < deltasLon.length) {
            n += NestedSmallCell.oneIfIsInCone(coneCenterLonRad, this.vertices.get((Object)CompassPoint.Cardinal.N), deltasLon[ringIndexMin]);
        }
        if (0 <= ringIndexCenter && ringIndexCenter < deltasLon.length) {
            n += NestedSmallCell.oneIfIsInCone(coneCenterLonRad, this.vertices.get((Object)CompassPoint.Cardinal.E), deltasLon[ringIndexCenter]);
            n += NestedSmallCell.oneIfIsInCone(coneCenterLonRad, this.vertices.get((Object)CompassPoint.Cardinal.W), deltasLon[ringIndexCenter]);
        }
        if (0 <= ringIndexMax && ringIndexMax < deltasLon.length) {
            n += NestedSmallCell.oneIfIsInCone(coneCenterLonRad, this.vertices.get((Object)CompassPoint.Cardinal.S), deltasLon[ringIndexMax]);
        }
        return n;
    }

    private final boolean containsCenter(int deltaDepth, long hash, double[] deltasLon, double coneCenterLonRad) {
        int dd = this.deltaDepthMax - deltaDepth;
        int nside = 1 << dd;
        int ringIndexMax = this.ringIndex(this.deltaDepthMax, hash << (dd << 1)) + 1 - this.smallestCornerRingIndex;
        int ringIndexCenter = ringIndexMax - nside;
        this.vpComputers[deltaDepth].center(hash, this.center);
        return NestedSmallCell.isInCone(coneCenterLonRad, this.center, deltasLon[ringIndexCenter]);
    }

    private static final int oneIfIsInCone(double coneCenterLonRad, double[] lonLat, double deltaLonMax) {
        return NestedSmallCell.isInCone(coneCenterLonRad, lonLat, deltaLonMax) ? 1 : 0;
    }

    private static final boolean isInCone(double coneCenterLonRad, double[] lonLat, double deltaLonMax) {
        return NestedSmallCell.computeDeltaLon(coneCenterLonRad, lonLat[0]) <= deltaLonMax;
    }

    private final boolean isInSpecialHash(int deltaDepth, long hash) {
        assert (this.iSpecialHash == 4);
        int twiceDeltaDepth = deltaDepth << 1;
        return this.specialHashs[0] >>> twiceDeltaDepth == hash || this.specialHashs[1] >>> twiceDeltaDepth == hash || this.specialHashs[2] >>> twiceDeltaDepth == hash || this.specialHashs[3] >>> twiceDeltaDepth == hash || deltaDepth == this.deltaDepthMax && this.specialHashs[4] == hash;
    }

    private final double squareOfSinOfHalfOf(double angleRad) {
        double sin = this.angDistComputer.sin(0.5 * angleRad);
        return sin * sin;
    }

    private final double squareOfSinOfHalfDeltaLon(double deltaLatRad, double cosLat, double cosLatCenter) {
        assert (cosLat >= 0.0 && cosLatCenter >= 0.0 || Double.isNaN(cosLat)) : cosLat + " " + cosLatCenter;
        double n = this.squareOfsinOfHalfR - this.squareOfSinOfHalfOf(deltaLatRad);
        double d = cosLat * cosLatCenter;
        if (n < 0.0) {
            return Double.NaN;
        }
        if (n >= d) {
            return 1.0;
        }
        return n / d;
    }

    private final double deltaLon(double deltaLatRad, double cosLat, double cosLatCenter) {
        return 2.0 * java.lang.Math.asin(java.lang.Math.sqrt(this.squareOfSinOfHalfDeltaLon(deltaLatRad, cosLat, cosLatCenter)));
    }

    protected static final double normalizeLon(double lonRad) {
        if (lonRad < 0.0 || java.lang.Math.PI * 2 < lonRad) {
            int k = HackersDelight.floorInt(lonRad * 0.15915494309189535);
            return lonRad - (double)k * (java.lang.Math.PI * 2);
        }
        return lonRad;
    }

    private static final double computeDeltaLon(double lonARad, double lonBRad) {
        double res = Math.abs(lonARad - lonBRad);
        return res <= java.lang.Math.PI ? res : java.lang.Math.PI * 2 - res;
    }

    private final int ringIndex(int deltaDepth, long hash) {
        HealpixNested hn = this.hns[deltaDepth];
        hn.decodeRegularHash(hash, this.hashPartsProxy);
        return NestedSmallCell.ringIndex(hn, this.baseCellHash, this.iInBaseCell, this.jInBaseCell);
    }

    private static final int ringIndex(HealpixNested hn, long baseCellHash, int iInBasePixel, int jInBasePixel) {
        int h = iInBasePixel + jInBasePixel;
        long jBasePixel = hn.dividedBy4Quotient(baseCellHash);
        return (int)(hn.nsideTime(jBasePixel + 2L) - (long)(h + 2));
    }

    final double latOf(int deltaDepth, int iRing) {
        if (iRing < 0 || iRing > this.startingNsideTime4 << deltaDepth) {
            return Double.NaN;
        }
        int nside = this.startingNside << deltaDepth;
        double lat = (double)(iRing + 1) / (double)nside;
        if (NestedSmallCell.isInNorthPolarCap(iRing, nside - 1)) {
            lat *= 0.408248290463863;
            lat = 2.0 * FastMath.acos(lat) - 1.5707963267948966;
        } else if (NestedSmallCell.isInSouthPolarCap(iRing, this.startingNsideTime3 << deltaDepth)) {
            lat = 4.0 - lat;
            lat *= 0.408248290463863;
            lat = -2.0 * FastMath.acos(lat) + 1.5707963267948966;
        } else {
            lat = FastMath.asin((2.0 - lat) * 0.6666666666666666);
        }
        return lat;
    }

    private static final boolean isInNorthPolarCap(int iRing, int nsideMinus1) {
        return iRing < nsideMinus1;
    }

    private static final boolean isInSouthPolarCap(int iRing, int nsideTime3) {
        return iRing >= nsideTime3;
    }

    private static interface AdditionalCheck {
        public boolean isOk(int var1, long var2, double[] var4, double var5);
    }
}

