#version 330
varying vec3 nor, lightDirection, normal, uv, pos,eye;
varying vec4 gcolor;
uniform vec4 fogColor;
uniform int LOD;
uniform int fogrange;
uniform bool lighting, wall, ring, ball, open, whitering, eli, fog;
void main(void) {
    vec4 specular, ambient, diffuse;
    specular = gl_LightSource[0].specular;
    ambient = gl_LightSource[0].ambient;
    diffuse = gl_LightSource[0].diffuse;
    vec4 color;
    gl_FragColor.a=1.0;
    float cut=0.07;
    if (lighting){
        vec3 N = normalize(normal);
        gl_MaterialParameters M = gl_FrontMaterial;
        float NdotL = dot(N, lightDirection);
        float RdotL = dot(reflect(normalize(pos), N), lightDirection);
        color = ((ambient + diffuse * max(NdotL, 0.0)) * gcolor +
        (M.specular * specular * pow(max(RdotL, 0.0), M.shininess)));
    }else{
        color=gcolor;
    }
    if (wall){
        float R=0.92;
        if (LOD==3) R=0.98;
        else if (LOD==2)R=0.97;
        gl_FragColor.a=(length(uv)<R)?1.0:0.0;
        gl_FragColor.xyz = color.xyz;
    }else{
        if (eli) {
            vec3 XYZ=abs(nor);
            if ((ring)&&(min(XYZ.x,min(XYZ.y,XYZ.z))<=cut)){
                if (whitering) gl_FragColor.xyz = mix(color.xyz,vec3(1.0,1.0,1.0),0.6);
                else gl_FragColor.xyz = mix(color.xyz,vec3(0.0,0.0,0.0),0.6);
            }
            else if (open){
                int ep=0,np=0;
                ep+=(eye.x>=0.0)?1:0;
                ep+=(eye.y>=0.0)?2:0;
                ep+=(eye.z>=0.0)?4:0;
                np+=(nor.x>=0.0)?1:0;
                np+=(nor.y>=0.0)?2:0;
                np+=(nor.z>=0.0)?4:0;
                if (ep==np) gl_FragColor.a=0.0;
                else {
                    if (ball) gl_FragColor = color;
                    else gl_FragColor.a=0.0;
                }
            }
            else if (ball) gl_FragColor = color;
            else gl_FragColor.a=0.0;
        } else gl_FragColor = color;
    }
    if (fog){
        int ffar=205+fogrange, fnear=205-fogrange;
        float fogDistance = (gl_FragCoord.z / gl_FragCoord.w);
        float fogAmount = 1.0 - clamp((ffar - fogDistance) / (ffar - fnear), 0.0, 1.0);
        gl_FragColor.xyz = mix(gl_FragColor.xyz, fogColor.xyz, fogAmount);
    }
}
