# 2022-08-02 Triage Log

A good week! We had one regression from [#99123](https://github.com/rust-lang/rust/pull/99123)
that could use further study, but we had a huge swath of improvements. The downward trend of the
[performance graph summary](https://perf.rust-lang.org/?start=2022-07-04&end=2022-08-03&kind=percentfromfirst&stat=instructions%3Au)
is striking. Perhaps best of all: Only *one* rollup PR impacted performance this week which makes
things so much easier to evaluate! Great work everyone!

Triage done by **@pnkfelix**.
Revision range: [50166d5e..792bc5a0](https://perf.rust-lang.org/?start=50166d5e5e82ca795306824decbe4ffabcc23d3d&end=792bc5a0102d0973d42183a2b267850bb905236f&absolute=false&stat=instructions%3Au)

**Summary**:

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.4% | 0.7% | 5     |
| Regressions 😿 <br /> (secondary) | 0.6% | 1.1% | 11    |
| Improvements 🎉 <br /> (primary) | -0.8% | -3.3% | 140   |
| Improvements 🎉 <br /> (secondary) | -0.9% | -11.0% | 95    |
| All 😿🎉 (primary) | -0.8% | -3.3% | 145   |


1 Regressions, 4 Improvements, 4 Mixed; 1 of them in rollups
44 artifact comparisons made in total

#### Regressions

`proc_macro`: use crossbeam channels for the `proc_macro` cross-thread bridge [#99123](https://github.com/rust-lang/rust/pull/99123) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8f68c43ca6a6381a4d73f887f112e9fb95769905&end=bd84c73ffe0a54ce2d77c92948a26ffa8fec04a3&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.9% | 1.4% | 11    |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.9% | 1.4% | 11    |

* all 11 regressions are to various profiles+scenarios for html5ever
* @nnethercote and @eddyb are discussing the regression to html5ever on the PR (#99123)
* not marking as triaged, not yet at least; lets try and see if eddyb's suggested mitigation actually helps here

#### Improvements

Rollup of 7 pull requests [#99816](https://github.com/rust-lang/rust/pull/99816) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=da5b546d2e563747b16a16dae83bacf49aa0bf3b&end=2643b16468fda787470340890212591d8bc832b7&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 1.0% | 1.0% | 1     |
| Improvements 🎉 <br /> (primary) | -0.2% | -0.2% | 1     |
| Improvements 🎉 <br /> (secondary) | -0.5% | -1.6% | 10    |
| All 😿🎉 (primary) | -0.2% | -0.2% | 1     |

* primary improvement was `hyper check incr-unchanged`; secondaries were `coercions debug full`, and 9 variations on `extern`. Secondary regression was `deep-vector opt incr-patched: println`.

anonymize all bound vars, not just regions [#99730](https://github.com/rust-lang/rust/pull/99730) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3924dac7bb29bc8eb348059c901e8f912399c857&end=211637d0802a1c17d41b414e091e9a8691b26068&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.4% | -0.6% | 56    |
| Improvements 🎉 <br /> (secondary) | -0.4% | -0.9% | 36    |
| All 😿🎉 (primary) | -0.4% | -0.6% | 56    |

* As is, this PR registered compilation time improvements
* However, @simulacrum noted that it was associated with a nearly 2% regression to *bootstrap times*.


Limit symbols exported from proc macros [#99944](https://github.com/rust-lang/rust/pull/99944) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6423ab3a755fed97f75b2361849155d4e996d02f&end=25bb1c13bd472b75ceebee3b8dcf4dcbc431a8be&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.6% | -2.9% | 41    |
| Improvements 🎉 <br /> (secondary) | -2.4% | -10.7% | 11    |
| All 😿🎉 (primary) | -0.6% | -2.9% | 41    |

* wow, this was a big win! serde_derive incr-unchanged builds up to 3% faster; ripgrep check is up to 1.75% faster, hyper and webrender check 1% faster.



Lexer improvements [#99884](https://github.com/rust-lang/rust/pull/99884) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1f5d8d49eb6111931091f700d07518cd2b80bc18&end=dcb444af0a417766dde9b7b8f537fa1ba1568daf&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.6% | 42    |
| Improvements 🎉 <br /> (secondary) | -0.5% | -1.2% | 48    |
| All 😿🎉 (primary) | -0.3% | -0.6% | 42    |

* This was a very *broad* win, where a huge number of benchmarks all improved by a relatively small amount. 
* I'm impressed by the [inventiveness shown during PR review](https://github.com/rust-lang/rust/pull/99884#pullrequestreview-1055325175).

#### Mixed

Remove remaining uses of box syntax from librustdoc [#99577](https://github.com/rust-lang/rust/pull/99577) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5dda74a48cd50de10539478c1e0b6699bfdab665&end=3924dac7bb29bc8eb348059c901e8f912399c857&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 0.3% | 0.3% | 4     |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.3% | 2     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | -0.3% | -0.3% | 2     |

* as you might expect, the limited number of performance changes here were to doc benchmarks (specifically serde and libc doc).

Remove `TreeAndSpacing`. [#99887](https://github.com/rust-lang/rust/pull/99887) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c907b6f7e0f89c3c4146b585961d2ddcf173584b&end=1202bbaf48a0a919a2e0cfd8b7dce97e8fc3030d&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.3% | 0.3% | 1     |
| Regressions 😿 <br /> (secondary) | 0.2% | 0.2% | 1     |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.4% | 5     |
| Improvements 🎉 <br /> (secondary) | -0.4% | -0.9% | 16    |
| All 😿🎉 (primary) | -0.2% | -0.4% | 6     |

* already triaged by nnethercote: "There's a single regressing result and 25 improved results. The changes are all very small. This is fine"

Thin `AssocItem` [#95884](https://github.com/rust-lang/rust/pull/95884) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fe3342816a282949f014caa05ea2e669ff9d3d3c&end=21de280cccb4eb02ead6bf0af40e2355a9136d6f&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.3% | 0.4% | 16    |
| Regressions 😿 <br /> (secondary) | 0.5% | 0.6% | 9     |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.4% | 7     |
| Improvements 🎉 <br /> (secondary) | -0.4% | -0.5% | 8     |
| All 😿🎉 (primary) | 0.1% | 0.4% | 23    |

* already triaged by nnethercote: "This looks perf-neutral, with the improvements roughly the same size as the regressions."

Remove `fn backtrace` and replace with usages of provider API [#99431](https://github.com/rust-lang/rust/pull/99431) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9d5cd21a5d4d5325b1f1c9903d000d19e3703e2a&end=9538d2d0f1c708affa36ef8917729efec2e5e0ed&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 1.5% | 1.5% | 2     |
| Improvements 🎉 <br /> (primary) | -0.9% | -1.4% | 2     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | -0.9% | -1.4% | 2     |

* the improvements are to building primary benchmark cargo opt in incr-patch: println and incr-full, by -1.38% and -0.42% respectively . The regression was to the externs incr-full in debug and opt profiles, both by 1.52%.
* this is entirely acceptable (and wasn't marked as a performance regression by the bot in the first place)

#### Untriaged Pull Requests

- [#99792 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/99792)
- [#99520 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/99520)
- [#99251 Upgrade indexmap and thorin-dwp to use hashbrown 0.12](https://github.com/rust-lang/rust/pull/99251)
- [#99231 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/99231)
- [#99210 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/99210)
- [#99126 remove allow(rustc::potential_query_instability) in rustc_span](https://github.com/rust-lang/rust/pull/99126)
- [#99123 proc_macro: use crossbeam channels for the proc_macro cross-thread bridge](https://github.com/rust-lang/rust/pull/99123)
- [#99047 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/99047)
- [#99014 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/99014)
- [#98987 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/98987)
- [#98957  don't allow ZST in ScalarInt ](https://github.com/rust-lang/rust/pull/98957)
- [#98904 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/98904)
- [#98874 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/98874)
- [#98612 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/98612)
- [#98591 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/98591)
- [#98178 btree: avoid forcing the allocator to be a reference](https://github.com/rust-lang/rust/pull/98178)
- [#98145 Pull Derefer before ElaborateDrops](https://github.com/rust-lang/rust/pull/98145)
- [#97786 Account for `-Z simulate-remapped-rust-src-base` when resolving remapped paths](https://github.com/rust-lang/rust/pull/97786)
- [#97019 Transition to valtrees pt1](https://github.com/rust-lang/rust/pull/97019)
- [#97004 Proc macro tweaks](https://github.com/rust-lang/rust/pull/97004)
- [#96883 Add EarlyBinder](https://github.com/rust-lang/rust/pull/96883)
- [#96825  Retire `ItemLikeVisitor` trait](https://github.com/rust-lang/rust/pull/96825)
- [#96010 Implement `core::ptr::Unique` on top of `NonNull`](https://github.com/rust-lang/rust/pull/96010)
- [#95990 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/95990)
- [#95956 Support unstable moves via stable in unstable items](https://github.com/rust-lang/rust/pull/95956)
- [#95899 rustc_metadata: Do not encode unnecessary module children](https://github.com/rust-lang/rust/pull/95899)
- [#95893 Respect -Z verify-llvm-ir and other flags that add extra passes when combined with -C no-prepopulate-passes in the new LLVM Pass Manager.](https://github.com/rust-lang/rust/pull/95893)
- [#95835 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/95835)
- [#95794 `parse_tt`: a few more tweaks](https://github.com/rust-lang/rust/pull/95794)
- [#95742 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/95742)
