% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\name{vec_count}
\alias{vec_count}
\title{Count unique values in a vector}
\usage{
vec_count(x, sort = c("count", "key", "location", "none"))
}
\arguments{
\item{x}{A vector (including a data frame).}

\item{sort}{One of "count", "key", "location", or "none".
\itemize{
\item "count", the default, puts most frequent values at top
\item "key", orders by the output key column (i.e. unique values of \code{x})
\item "location", orders by location where key first seen. This is useful
if you want to match the counts up to other unique/duplicated functions.
\item "none", leaves unordered. This is not guaranteed to produce the same
ordering across R sessions, but is the fastest method.
}}
}
\value{
A data frame with columns \code{key} (same type as \code{x}) and
\code{count} (an integer vector).
}
\description{
Count the number of unique values in a vector. \code{vec_count()} has two
important differences to \code{table()}: it returns a data frame, and when
given multiple inputs (as a data frame), it only counts combinations that
appear in the input.
}
\section{Dependencies}{

\itemize{
\item \code{\link[=vec_proxy_equal]{vec_proxy_equal()}}
\item \code{\link[=vec_slice]{vec_slice()}}
\item \code{\link[=vec_order]{vec_order()}}
}
}

\examples{
vec_count(mtcars$vs)
vec_count(iris$Species)

# If you count a data frame you'll get a data frame
# column in the output
str(vec_count(mtcars[c("vs", "am")]))

# Sorting ---------------------------------------

x <- letters[rpois(100, 6)]
# default is to sort by frequency
vec_count(x)

# by can sort by key
vec_count(x, sort = "key")

# or location of first value
vec_count(x, sort = "location")
head(x)

# or not at all
vec_count(x, sort = "none")
}
