% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-nest.R
\name{nest.dtplyr_step}
\alias{nest.dtplyr_step}
\title{Nest}
\usage{
\method{nest}{dtplyr_step}(.data, ..., .names_sep = NULL, .key = deprecated())
}
\arguments{
\item{.data}{A data frame.}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to nest, specified
using name-variable pairs of the form \code{new_col = c(col1, col2, col3)}.
The right hand side can be any valid tidy select expression.}

\item{.names_sep}{If \code{NULL}, the default, the names will be left
as is. In \code{nest()}, inner names will come from the former outer names;
in \code{unnest()}, the new outer names will come from the inner names.

If a string, the inner and outer names will be used together. In
\code{unnest()}, the names of the new outer columns will be formed by pasting
together the outer and the inner column names, separated by \code{names_sep}. In
\code{nest()}, the new inner names will have the outer names + \code{names_sep}
automatically stripped. This makes \code{names_sep} roughly symmetric between
nesting and unnesting.}

\item{.key}{Not supported.}

\item{data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}
}
\description{
This is a method for the tidyr \code{\link[tidyr:nest]{tidyr::nest()}} generic. It is translated
using the non-nested variables in the \code{by} argument and \code{.SD} in the \code{j}
argument.
}
\examples{
if (require("tidyr", quietly = TRUE)) {
  dt <- lazy_dt(tibble(x = c(1, 2, 1), y = c("a", "a", "b")))
  dt \%>\% nest(data = y)

  dt \%>\% dplyr::group_by(x) \%>\% nest()
}
}
