# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class Actor(msrest.serialization.Model):
    """The agent that initiated the event. For most situations, this could be from the authorization context of the request.

    :param name: The subject or username associated with the request context that generated the
     event.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Actor, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class AgentProperties(msrest.serialization.Model):
    """The properties that determine the run agent configuration.

    :param cpu: The CPU configuration in terms of number of cores required for the run.
    :type cpu: int
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgentProperties, self).__init__(**kwargs)
        self.cpu = kwargs.get('cpu', None)


class Argument(msrest.serialization.Model):
    """The properties of a run argument.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the argument.
    :type name: str
    :param value: Required. The value of the argument.
    :type value: str
    :param is_secret: Flag to indicate whether the argument represents a secret and want to be
     removed from build logs.
    :type is_secret: bool
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'is_secret': {'key': 'isSecret', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Argument, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.value = kwargs['value']
        self.is_secret = kwargs.get('is_secret', False)


class AuthInfo(msrest.serialization.Model):
    """The authorization properties for accessing the source code repository.

    All required parameters must be populated in order to send to Azure.

    :param token_type: Required. The type of Auth token. Possible values include: "PAT", "OAuth".
    :type token_type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TokenType
    :param token: Required. The access token used to access the source control provider.
    :type token: str
    :param refresh_token: The refresh token used to refresh the access token.
    :type refresh_token: str
    :param scope: The scope of the access token.
    :type scope: str
    :param expires_in: Time in seconds that the token remains valid.
    :type expires_in: int
    """

    _validation = {
        'token_type': {'required': True},
        'token': {'required': True},
    }

    _attribute_map = {
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthInfo, self).__init__(**kwargs)
        self.token_type = kwargs['token_type']
        self.token = kwargs['token']
        self.refresh_token = kwargs.get('refresh_token', None)
        self.scope = kwargs.get('scope', None)
        self.expires_in = kwargs.get('expires_in', None)


class AuthInfoUpdateParameters(msrest.serialization.Model):
    """The authorization properties for accessing the source code repository.

    :param token_type: The type of Auth token. Possible values include: "PAT", "OAuth".
    :type token_type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TokenType
    :param token: The access token used to access the source control provider.
    :type token: str
    :param refresh_token: The refresh token used to refresh the access token.
    :type refresh_token: str
    :param scope: The scope of the access token.
    :type scope: str
    :param expires_in: Time in seconds that the token remains valid.
    :type expires_in: int
    """

    _attribute_map = {
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthInfoUpdateParameters, self).__init__(**kwargs)
        self.token_type = kwargs.get('token_type', None)
        self.token = kwargs.get('token', None)
        self.refresh_token = kwargs.get('refresh_token', None)
        self.scope = kwargs.get('scope', None)
        self.expires_in = kwargs.get('expires_in', None)


class BaseImageDependency(msrest.serialization.Model):
    """Properties that describe a base image dependency.

    :param type: The type of the base image dependency. Possible values include: "BuildTime",
     "RunTime".
    :type type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageDependencyType
    :param registry: The registry login server.
    :type registry: str
    :param repository: The repository name.
    :type repository: str
    :param tag: The tag name.
    :type tag: str
    :param digest: The sha256-based digest of the image manifest.
    :type digest: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'registry': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseImageDependency, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.registry = kwargs.get('registry', None)
        self.repository = kwargs.get('repository', None)
        self.tag = kwargs.get('tag', None)
        self.digest = kwargs.get('digest', None)


class BaseImageTrigger(msrest.serialization.Model):
    """The trigger based on base image dependency.

    All required parameters must be populated in order to send to Azure.

    :param base_image_trigger_type: Required. The type of the auto trigger for base image
     dependency updates. Possible values include: "All", "Runtime".
    :type base_image_trigger_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageTriggerType
    :param status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'base_image_trigger_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'base_image_trigger_type': {'key': 'baseImageTriggerType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseImageTrigger, self).__init__(**kwargs)
        self.base_image_trigger_type = kwargs['base_image_trigger_type']
        self.status = kwargs.get('status', None)
        self.name = kwargs['name']


class BaseImageTriggerUpdateParameters(msrest.serialization.Model):
    """The properties for updating base image dependency trigger.

    All required parameters must be populated in order to send to Azure.

    :param base_image_trigger_type: The type of the auto trigger for base image dependency updates.
     Possible values include: "All", "Runtime".
    :type base_image_trigger_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageTriggerType
    :param status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'base_image_trigger_type': {'key': 'baseImageTriggerType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseImageTriggerUpdateParameters, self).__init__(**kwargs)
        self.base_image_trigger_type = kwargs.get('base_image_trigger_type', None)
        self.status = kwargs.get('status', None)
        self.name = kwargs['name']


class CallbackConfig(msrest.serialization.Model):
    """The configuration of service URI and custom headers for the webhook.

    All required parameters must be populated in order to send to Azure.

    :param service_uri: Required. The service URI for the webhook to post notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook notifications.
    :type custom_headers: dict[str, str]
    """

    _validation = {
        'service_uri': {'required': True},
    }

    _attribute_map = {
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'customHeaders', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CallbackConfig, self).__init__(**kwargs)
        self.service_uri = kwargs['service_uri']
        self.custom_headers = kwargs.get('custom_headers', None)


class Credentials(msrest.serialization.Model):
    """The parameters that describes a set of credentials that will be used when a run is invoked.

    :param source_registry: Describes the credential parameters for accessing the source registry.
    :type source_registry:
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceRegistryCredentials
    :param custom_registries: Describes the credential parameters for accessing other custom
     registries. The key
     for the dictionary item will be the registry login server (myregistry.azurecr.io) and
     the value of the item will be the registry credentials for accessing the registry.
    :type custom_registries: dict[str,
     ~azure.mgmt.containerregistry.v2019_05_01.models.CustomRegistryCredentials]
    """

    _attribute_map = {
        'source_registry': {'key': 'sourceRegistry', 'type': 'SourceRegistryCredentials'},
        'custom_registries': {'key': 'customRegistries', 'type': '{CustomRegistryCredentials}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Credentials, self).__init__(**kwargs)
        self.source_registry = kwargs.get('source_registry', None)
        self.custom_registries = kwargs.get('custom_registries', None)


class CustomRegistryCredentials(msrest.serialization.Model):
    """Describes the credentials that will be used to access a custom registry during a run.

    :param user_name: The username for logging into the custom registry.
    :type user_name: ~azure.mgmt.containerregistry.v2019_05_01.models.SecretObject
    :param password: The password for logging into the custom registry. The password is a secret
     object that allows multiple ways of providing the value for it.
    :type password: ~azure.mgmt.containerregistry.v2019_05_01.models.SecretObject
    :param identity: Indicates the managed identity assigned to the custom credential. If a user-
     assigned identity
     this value is the Client ID. If a system-assigned identity, the value will be ``system``. In
     the case of a system-assigned identity, the Client ID will be determined by the runner. This
     identity may be used to authenticate to key vault to retrieve credentials or it may be the
     only
     source of authentication used for accessing the registry.
    :type identity: str
    """

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'SecretObject'},
        'password': {'key': 'password', 'type': 'SecretObject'},
        'identity': {'key': 'identity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomRegistryCredentials, self).__init__(**kwargs)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.identity = kwargs.get('identity', None)


class RunRequest(msrest.serialization.Model):
    """The request parameters for scheduling a run.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildRequest, EncodedTaskRunRequest, FileTaskRunRequest, TaskRunRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the run request.Constant filled by server.
    :vartype type: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :type is_archive_enabled: bool
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
    }

    _subtype_map = {
        'type': {'DockerBuildRequest': 'DockerBuildRequest', 'EncodedTaskRunRequest': 'EncodedTaskRunRequest', 'FileTaskRunRequest': 'FileTaskRunRequest', 'TaskRunRequest': 'TaskRunRequest'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunRequest, self).__init__(**kwargs)
        self.type = None
        self.is_archive_enabled = kwargs.get('is_archive_enabled', False)


class DockerBuildRequest(RunRequest):
    """The parameters for a docker quick build.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the run request.Constant filled by server.
    :vartype type: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :type is_archive_enabled: bool
    :param image_names: The fully qualified image names including the repository and tag.
    :type image_names: list[str]
    :param is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image cache is enabled or
     not.
    :type no_cache: bool
    :param docker_file_path: Required. The Docker file path relative to the source location.
    :type docker_file_path: str
    :param target: The name of the target build stage for the docker build.
    :type target: str
    :param arguments: The collection of override arguments to be used when executing the run.
    :type arguments: list[~azure.mgmt.containerregistry.v2019_05_01.models.Argument]
    :param timeout: Run timeout in seconds.
    :type timeout: int
    :param platform: Required. The platform properties against which the run has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param source_location: The URL(absolute or relative) of the source context. It can be an URL
     to a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :type source_location: str
    :param credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :type credentials: ~azure.mgmt.containerregistry.v2019_05_01.models.Credentials
    """

    _validation = {
        'type': {'readonly': True},
        'docker_file_path': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DockerBuildRequest, self).__init__(**kwargs)
        self.type = None
        self.image_names = kwargs.get('image_names', None)
        self.is_push_enabled = kwargs.get('is_push_enabled', True)
        self.no_cache = kwargs.get('no_cache', False)
        self.docker_file_path = kwargs['docker_file_path']
        self.target = kwargs.get('target', None)
        self.arguments = kwargs.get('arguments', None)
        self.timeout = kwargs.get('timeout', 3600)
        self.platform = kwargs['platform']
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.source_location = kwargs.get('source_location', None)
        self.credentials = kwargs.get('credentials', None)


class TaskStepProperties(msrest.serialization.Model):
    """Base properties for any task step.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildStep, EncodedTaskStep, FileTaskStep.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the step.Constant filled by server.  Possible values include: "Docker",
     "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    """

    _validation = {
        'type': {'readonly': True},
        'base_image_dependencies': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Docker': 'DockerBuildStep', 'EncodedTask': 'EncodedTaskStep', 'FileTask': 'FileTaskStep'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskStepProperties, self).__init__(**kwargs)
        self.type = None
        self.base_image_dependencies = None
        self.context_path = kwargs.get('context_path', None)
        self.context_access_token = kwargs.get('context_access_token', None)


class DockerBuildStep(TaskStepProperties):
    """The Docker build step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the step.Constant filled by server.  Possible values include: "Docker",
     "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param image_names: The fully qualified image names including the repository and tag.
    :type image_names: list[str]
    :param is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image cache is enabled or
     not.
    :type no_cache: bool
    :param docker_file_path: Required. The Docker file path relative to the source context.
    :type docker_file_path: str
    :param target: The name of the target build stage for the docker build.
    :type target: str
    :param arguments: The collection of override arguments to be used when executing this build
     step.
    :type arguments: list[~azure.mgmt.containerregistry.v2019_05_01.models.Argument]
    """

    _validation = {
        'type': {'readonly': True},
        'base_image_dependencies': {'readonly': True},
        'docker_file_path': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DockerBuildStep, self).__init__(**kwargs)
        self.type = None
        self.image_names = kwargs.get('image_names', None)
        self.is_push_enabled = kwargs.get('is_push_enabled', True)
        self.no_cache = kwargs.get('no_cache', False)
        self.docker_file_path = kwargs['docker_file_path']
        self.target = kwargs.get('target', None)
        self.arguments = kwargs.get('arguments', None)


class TaskStepUpdateParameters(msrest.serialization.Model):
    """Base properties for updating any task step.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildStepUpdateParameters, EncodedTaskStepUpdateParameters, FileTaskStepUpdateParameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the step.Constant filled by server.  Possible values include: "Docker",
     "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.StepType
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Docker': 'DockerBuildStepUpdateParameters', 'EncodedTask': 'EncodedTaskStepUpdateParameters', 'FileTask': 'FileTaskStepUpdateParameters'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskStepUpdateParameters, self).__init__(**kwargs)
        self.type = None
        self.context_path = kwargs.get('context_path', None)
        self.context_access_token = kwargs.get('context_access_token', None)


class DockerBuildStepUpdateParameters(TaskStepUpdateParameters):
    """The properties for updating a docker build step.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the step.Constant filled by server.  Possible values include: "Docker",
     "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.StepType
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param image_names: The fully qualified image names including the repository and tag.
    :type image_names: list[str]
    :param is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image cache is enabled or
     not.
    :type no_cache: bool
    :param docker_file_path: The Docker file path relative to the source context.
    :type docker_file_path: str
    :param arguments: The collection of override arguments to be used when executing this build
     step.
    :type arguments: list[~azure.mgmt.containerregistry.v2019_05_01.models.Argument]
    :param target: The name of the target build stage for the docker build.
    :type target: str
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DockerBuildStepUpdateParameters, self).__init__(**kwargs)
        self.type = None
        self.image_names = kwargs.get('image_names', None)
        self.is_push_enabled = kwargs.get('is_push_enabled', None)
        self.no_cache = kwargs.get('no_cache', None)
        self.docker_file_path = kwargs.get('docker_file_path', None)
        self.arguments = kwargs.get('arguments', None)
        self.target = kwargs.get('target', None)


class EncodedTaskRunRequest(RunRequest):
    """The parameters for a quick task run request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the run request.Constant filled by server.
    :vartype type: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :type is_archive_enabled: bool
    :param encoded_task_content: Required. Base64 encoded value of the template/definition file
     content.
    :type encoded_task_content: str
    :param encoded_values_content: Base64 encoded value of the parameters/values file content.
    :type encoded_values_content: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    :param timeout: Run timeout in seconds.
    :type timeout: int
    :param platform: Required. The platform properties against which the run has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param source_location: The URL(absolute or relative) of the source context. It can be an URL
     to a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :type source_location: str
    :param credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :type credentials: ~azure.mgmt.containerregistry.v2019_05_01.models.Credentials
    """

    _validation = {
        'type': {'readonly': True},
        'encoded_task_content': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncodedTaskRunRequest, self).__init__(**kwargs)
        self.type = None
        self.encoded_task_content = kwargs['encoded_task_content']
        self.encoded_values_content = kwargs.get('encoded_values_content', None)
        self.values = kwargs.get('values', None)
        self.timeout = kwargs.get('timeout', 3600)
        self.platform = kwargs['platform']
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.source_location = kwargs.get('source_location', None)
        self.credentials = kwargs.get('credentials', None)


class EncodedTaskStep(TaskStepProperties):
    """The properties of a encoded task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the step.Constant filled by server.  Possible values include: "Docker",
     "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param encoded_task_content: Required. Base64 encoded value of the template/definition file
     content.
    :type encoded_task_content: str
    :param encoded_values_content: Base64 encoded value of the parameters/values file content.
    :type encoded_values_content: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    """

    _validation = {
        'type': {'readonly': True},
        'base_image_dependencies': {'readonly': True},
        'encoded_task_content': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncodedTaskStep, self).__init__(**kwargs)
        self.type = None
        self.encoded_task_content = kwargs['encoded_task_content']
        self.encoded_values_content = kwargs.get('encoded_values_content', None)
        self.values = kwargs.get('values', None)


class EncodedTaskStepUpdateParameters(TaskStepUpdateParameters):
    """The properties for updating encoded task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the step.Constant filled by server.  Possible values include: "Docker",
     "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.StepType
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param encoded_task_content: Base64 encoded value of the template/definition file content.
    :type encoded_task_content: str
    :param encoded_values_content: Base64 encoded value of the parameters/values file content.
    :type encoded_values_content: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncodedTaskStepUpdateParameters, self).__init__(**kwargs)
        self.type = None
        self.encoded_task_content = kwargs.get('encoded_task_content', None)
        self.encoded_values_content = kwargs.get('encoded_values_content', None)
        self.values = kwargs.get('values', None)


class EventInfo(msrest.serialization.Model):
    """The basic information of an event.

    :param id: The event ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class Event(EventInfo):
    """The event for a webhook.

    :param id: The event ID.
    :type id: str
    :param event_request_message: The event request message sent to the service URI.
    :type event_request_message:
     ~azure.mgmt.containerregistry.v2019_05_01.models.EventRequestMessage
    :param event_response_message: The event response message received from the service URI.
    :type event_response_message:
     ~azure.mgmt.containerregistry.v2019_05_01.models.EventResponseMessage
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'event_request_message': {'key': 'eventRequestMessage', 'type': 'EventRequestMessage'},
        'event_response_message': {'key': 'eventResponseMessage', 'type': 'EventResponseMessage'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Event, self).__init__(**kwargs)
        self.event_request_message = kwargs.get('event_request_message', None)
        self.event_response_message = kwargs.get('event_response_message', None)


class EventContent(msrest.serialization.Model):
    """The content of the event request message.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target: ~azure.mgmt.containerregistry.v2019_05_01.models.Target
    :param request: The request that generated the event.
    :type request: ~azure.mgmt.containerregistry.v2019_05_01.models.Request
    :param actor: The agent that initiated the event. For most situations, this could be from the
     authorization context of the request.
    :type actor: ~azure.mgmt.containerregistry.v2019_05_01.models.Actor
    :param source: The registry node that generated the event. Put differently, while the actor
     initiates the event, the source generates it.
    :type source: ~azure.mgmt.containerregistry.v2019_05_01.models.Source
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'Target'},
        'request': {'key': 'request', 'type': 'Request'},
        'actor': {'key': 'actor', 'type': 'Actor'},
        'source': {'key': 'source', 'type': 'Source'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventContent, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.action = kwargs.get('action', None)
        self.target = kwargs.get('target', None)
        self.request = kwargs.get('request', None)
        self.actor = kwargs.get('actor', None)
        self.source = kwargs.get('source', None)


class EventListResult(msrest.serialization.Model):
    """The result of a request to list events for a webhook.

    :param value: The list of events. Since this list may be incomplete, the nextLink field should
     be used to request the next list of events.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Event]
    :param next_link: The URI that can be used to request the next list of events.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Event]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class EventRequestMessage(msrest.serialization.Model):
    """The event request message sent to the service URI.

    :param content: The content of the event request message.
    :type content: ~azure.mgmt.containerregistry.v2019_05_01.models.EventContent
    :param headers: The headers of the event request message.
    :type headers: dict[str, str]
    :param method: The HTTP method used to send the event request message.
    :type method: str
    :param request_uri: The URI used to send the event request message.
    :type request_uri: str
    :param version: The HTTP message version.
    :type version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'EventContent'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'method': {'key': 'method', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventRequestMessage, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)
        self.headers = kwargs.get('headers', None)
        self.method = kwargs.get('method', None)
        self.request_uri = kwargs.get('request_uri', None)
        self.version = kwargs.get('version', None)


class EventResponseMessage(msrest.serialization.Model):
    """The event response message received from the service URI.

    :param content: The content of the event response message.
    :type content: str
    :param headers: The headers of the event response message.
    :type headers: dict[str, str]
    :param reason_phrase: The reason phrase of the event response message.
    :type reason_phrase: str
    :param status_code: The status code of the event response message.
    :type status_code: str
    :param version: The HTTP message version.
    :type version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'reason_phrase': {'key': 'reasonPhrase', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventResponseMessage, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)
        self.headers = kwargs.get('headers', None)
        self.reason_phrase = kwargs.get('reason_phrase', None)
        self.status_code = kwargs.get('status_code', None)
        self.version = kwargs.get('version', None)


class FileTaskRunRequest(RunRequest):
    """The request parameters for a scheduling run against a task file.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the run request.Constant filled by server.
    :vartype type: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :type is_archive_enabled: bool
    :param task_file_path: Required. The template/definition file path relative to the source.
    :type task_file_path: str
    :param values_file_path: The values/parameters file path relative to the source.
    :type values_file_path: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    :param timeout: Run timeout in seconds.
    :type timeout: int
    :param platform: Required. The platform properties against which the run has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param source_location: The URL(absolute or relative) of the source context. It can be an URL
     to a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :type source_location: str
    :param credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :type credentials: ~azure.mgmt.containerregistry.v2019_05_01.models.Credentials
    """

    _validation = {
        'type': {'readonly': True},
        'task_file_path': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileTaskRunRequest, self).__init__(**kwargs)
        self.type = None
        self.task_file_path = kwargs['task_file_path']
        self.values_file_path = kwargs.get('values_file_path', None)
        self.values = kwargs.get('values', None)
        self.timeout = kwargs.get('timeout', 3600)
        self.platform = kwargs['platform']
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.source_location = kwargs.get('source_location', None)
        self.credentials = kwargs.get('credentials', None)


class FileTaskStep(TaskStepProperties):
    """The properties of a task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the step.Constant filled by server.  Possible values include: "Docker",
     "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param task_file_path: Required. The task template/definition file path relative to the source
     context.
    :type task_file_path: str
    :param values_file_path: The task values/parameters file path relative to the source context.
    :type values_file_path: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    """

    _validation = {
        'type': {'readonly': True},
        'base_image_dependencies': {'readonly': True},
        'task_file_path': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileTaskStep, self).__init__(**kwargs)
        self.type = None
        self.task_file_path = kwargs['task_file_path']
        self.values_file_path = kwargs.get('values_file_path', None)
        self.values = kwargs.get('values', None)


class FileTaskStepUpdateParameters(TaskStepUpdateParameters):
    """The properties of updating a task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the step.Constant filled by server.  Possible values include: "Docker",
     "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.StepType
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param task_file_path: The task template/definition file path relative to the source context.
    :type task_file_path: str
    :param values_file_path: The values/parameters file path relative to the source context.
    :type values_file_path: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileTaskStepUpdateParameters, self).__init__(**kwargs)
        self.type = None
        self.task_file_path = kwargs.get('task_file_path', None)
        self.values_file_path = kwargs.get('values_file_path', None)
        self.values = kwargs.get('values', None)


class IdentityProperties(msrest.serialization.Model):
    """Managed identity for the resource.

    :param principal_id: The principal ID of resource identity.
    :type principal_id: str
    :param tenant_id: The tenant ID of resource.
    :type tenant_id: str
    :param type: The identity type. Possible values include: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", "None".
    :type type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated with the resource. The
     user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
         providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.containerregistry.v2019_05_01.models.UserIdentityProperties]
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentityProperties}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentityProperties, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class ImageDescriptor(msrest.serialization.Model):
    """Properties for a registry image.

    :param registry: The registry login server.
    :type registry: str
    :param repository: The repository name.
    :type repository: str
    :param tag: The tag name.
    :type tag: str
    :param digest: The sha256-based digest of the image manifest.
    :type digest: str
    """

    _attribute_map = {
        'registry': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageDescriptor, self).__init__(**kwargs)
        self.registry = kwargs.get('registry', None)
        self.repository = kwargs.get('repository', None)
        self.tag = kwargs.get('tag', None)
        self.digest = kwargs.get('digest', None)


class ImageUpdateTrigger(msrest.serialization.Model):
    """The image update trigger that caused a build.

    :param id: The unique ID of the trigger.
    :type id: str
    :param timestamp: The timestamp when the image update happened.
    :type timestamp: ~datetime.datetime
    :param images: The list of image updates that caused the build.
    :type images: list[~azure.mgmt.containerregistry.v2019_05_01.models.ImageDescriptor]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'images': {'key': 'images', 'type': '[ImageDescriptor]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageUpdateTrigger, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.images = kwargs.get('images', None)


class ImportImageParameters(msrest.serialization.Model):
    """ImportImageParameters.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. The source of the image.
    :type source: ~azure.mgmt.containerregistry.v2019_05_01.models.ImportSource
    :param target_tags: List of strings of the form repo[:tag]. When tag is omitted the source will
     be used (or 'latest' if source tag is also omitted).
    :type target_tags: list[str]
    :param untagged_target_repositories: List of strings of repository names to do a manifest only
     copy. No tag will be created.
    :type untagged_target_repositories: list[str]
    :param mode: When Force, any existing target tags will be overwritten. When NoForce, any
     existing target tags will fail the operation before any copying begins. Possible values
     include: "NoForce", "Force". Default value: "NoForce".
    :type mode: str or ~azure.mgmt.containerregistry.v2019_05_01.models.ImportMode
    """

    _validation = {
        'source': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ImportSource'},
        'target_tags': {'key': 'targetTags', 'type': '[str]'},
        'untagged_target_repositories': {'key': 'untaggedTargetRepositories', 'type': '[str]'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportImageParameters, self).__init__(**kwargs)
        self.source = kwargs['source']
        self.target_tags = kwargs.get('target_tags', None)
        self.untagged_target_repositories = kwargs.get('untagged_target_repositories', None)
        self.mode = kwargs.get('mode', "NoForce")


class ImportSource(msrest.serialization.Model):
    """ImportSource.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: The resource identifier of the source Azure Container Registry.
    :type resource_id: str
    :param registry_uri: The address of the source registry (e.g. 'mcr.microsoft.com').
    :type registry_uri: str
    :param credentials: Credentials used when importing from a registry uri.
    :type credentials: ~azure.mgmt.containerregistry.v2019_05_01.models.ImportSourceCredentials
    :param source_image: Required. Repository name of the source image.
     Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     Specify an image by tag ('hello-world:latest').
     Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
    :type source_image: str
    """

    _validation = {
        'source_image': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'registry_uri': {'key': 'registryUri', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'ImportSourceCredentials'},
        'source_image': {'key': 'sourceImage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportSource, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.registry_uri = kwargs.get('registry_uri', None)
        self.credentials = kwargs.get('credentials', None)
        self.source_image = kwargs['source_image']


class ImportSourceCredentials(msrest.serialization.Model):
    """ImportSourceCredentials.

    All required parameters must be populated in order to send to Azure.

    :param username: The username to authenticate with the source registry.
    :type username: str
    :param password: Required. The password used to authenticate with the source registry.
    :type password: str
    """

    _validation = {
        'password': {'required': True},
    }

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportSourceCredentials, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.password = kwargs['password']


class IPRule(msrest.serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :param action: The action of IP ACL rule. Possible values include: "Allow".
    :type action: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Action
    :param ip_address_or_range: Required. Specifies the IP or IP range in CIDR format. Only IPV4
     address is allowed.
    :type ip_address_or_range: str
    """

    _validation = {
        'ip_address_or_range': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'ip_address_or_range': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IPRule, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)
        self.ip_address_or_range = kwargs['ip_address_or_range']


class NetworkRuleSet(msrest.serialization.Model):
    """The network rule set for a container registry.

    All required parameters must be populated in order to send to Azure.

    :param default_action: Required. The default action of allow or deny when no other rules match.
     Possible values include: "Allow", "Deny". Default value: "Allow".
    :type default_action: str or ~azure.mgmt.containerregistry.v2019_05_01.models.DefaultAction
    :param virtual_network_rules: The virtual network rules.
    :type virtual_network_rules:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.VirtualNetworkRule]
    :param ip_rules: The IP ACL rules.
    :type ip_rules: list[~azure.mgmt.containerregistry.v2019_05_01.models.IPRule]
    """

    _validation = {
        'default_action': {'required': True},
    }

    _attribute_map = {
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.default_action = kwargs.get('default_action', "Allow")
        self.virtual_network_rules = kwargs.get('virtual_network_rules', None)
        self.ip_rules = kwargs.get('ip_rules', None)


class OperationDefinition(msrest.serialization.Model):
    """The definition of a container registry operation.

    :param origin: The origin information of the container registry operation.
    :type origin: str
    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The display information for the container registry operation.
    :type display: ~azure.mgmt.containerregistry.v2019_05_01.models.OperationDisplayDefinition
    :param service_specification: The definition of Azure Monitoring service.
    :type service_specification:
     ~azure.mgmt.containerregistry.v2019_05_01.models.OperationServiceSpecificationDefinition
    """

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplayDefinition'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationServiceSpecificationDefinition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDefinition, self).__init__(**kwargs)
        self.origin = kwargs.get('origin', None)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.service_specification = kwargs.get('service_specification', None)


class OperationDisplayDefinition(msrest.serialization.Model):
    """The display information for a container registry operation.

    :param provider: The resource provider name: Microsoft.ContainerRegistry.
    :type provider: str
    :param resource: The resource on which the operation is performed.
    :type resource: str
    :param operation: The operation that users can perform.
    :type operation: str
    :param description: The description for the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplayDefinition, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """The result of a request to list container registry operations.

    :param value: The list of container registry operations. Since this list may be incomplete, the
     nextLink field should be used to request the next list of operations.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.OperationDefinition]
    :param next_link: The URI that can be used to request the next list of container registry
     operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class OperationMetricSpecificationDefinition(msrest.serialization.Model):
    """The definition of Azure Monitoring metric.

    :param name: Metric name.
    :type name: str
    :param display_name: Metric display name.
    :type display_name: str
    :param display_description: Metric description.
    :type display_description: str
    :param unit: Metric unit.
    :type unit: str
    :param aggregation_type: Metric aggregation type.
    :type aggregation_type: str
    :param internal_metric_name: Internal metric name.
    :type internal_metric_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'internal_metric_name': {'key': 'internalMetricName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationMetricSpecificationDefinition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.internal_metric_name = kwargs.get('internal_metric_name', None)


class OperationServiceSpecificationDefinition(msrest.serialization.Model):
    """The definition of Azure Monitoring list.

    :param metric_specifications: A list of Azure Monitoring metrics definition.
    :type metric_specifications:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.OperationMetricSpecificationDefinition]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationMetricSpecificationDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationServiceSpecificationDefinition, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)


class PlatformProperties(msrest.serialization.Model):
    """The platform properties against which the run has to happen.

    All required parameters must be populated in order to send to Azure.

    :param os: Required. The operating system type required for the run. Possible values include:
     "Windows", "Linux".
    :type os: str or ~azure.mgmt.containerregistry.v2019_05_01.models.OS
    :param architecture: The OS architecture. Possible values include: "amd64", "x86", "arm".
    :type architecture: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Architecture
    :param variant: Variant of the CPU. Possible values include: "v6", "v7", "v8".
    :type variant: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Variant
    """

    _validation = {
        'os': {'required': True},
    }

    _attribute_map = {
        'os': {'key': 'os', 'type': 'str'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'variant': {'key': 'variant', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PlatformProperties, self).__init__(**kwargs)
        self.os = kwargs['os']
        self.architecture = kwargs.get('architecture', None)
        self.variant = kwargs.get('variant', None)


class PlatformUpdateParameters(msrest.serialization.Model):
    """The properties for updating the platform configuration.

    :param os: The operating system type required for the run. Possible values include: "Windows",
     "Linux".
    :type os: str or ~azure.mgmt.containerregistry.v2019_05_01.models.OS
    :param architecture: The OS architecture. Possible values include: "amd64", "x86", "arm".
    :type architecture: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Architecture
    :param variant: Variant of the CPU. Possible values include: "v6", "v7", "v8".
    :type variant: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Variant
    """

    _attribute_map = {
        'os': {'key': 'os', 'type': 'str'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'variant': {'key': 'variant', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PlatformUpdateParameters, self).__init__(**kwargs)
        self.os = kwargs.get('os', None)
        self.architecture = kwargs.get('architecture', None)
        self.variant = kwargs.get('variant', None)


class Policies(msrest.serialization.Model):
    """The policies for a container registry.

    :param quarantine_policy: The quarantine policy for a container registry.
    :type quarantine_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.QuarantinePolicy
    :param trust_policy: The content trust policy for a container registry.
    :type trust_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.TrustPolicy
    :param retention_policy: The retention policy for a container registry.
    :type retention_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.RetentionPolicy
    """

    _attribute_map = {
        'quarantine_policy': {'key': 'quarantinePolicy', 'type': 'QuarantinePolicy'},
        'trust_policy': {'key': 'trustPolicy', 'type': 'TrustPolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Policies, self).__init__(**kwargs)
        self.quarantine_policy = kwargs.get('quarantine_policy', None)
        self.trust_policy = kwargs.get('trust_policy', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class ProxyResource(msrest.serialization.Model):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class QuarantinePolicy(msrest.serialization.Model):
    """The quarantine policy for a container registry.

    :param status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuarantinePolicy, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)


class RegenerateCredentialParameters(msrest.serialization.Model):
    """The parameters used to regenerate the login credential.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Specifies name of the password which should be regenerated -- password
     or password2. Possible values include: "password", "password2".
    :type name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PasswordName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegenerateCredentialParameters, self).__init__(**kwargs)
        self.name = kwargs['name']


class Resource(msrest.serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class Registry(Resource):
    """An object that represents a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param sku: Required. The SKU of the container registry.
    :type sku: ~azure.mgmt.containerregistry.v2019_05_01.models.Sku
    :ivar login_server: The URL that can be used to log into the container registry.
    :vartype login_server: str
    :ivar creation_date: The creation date of the container registry in ISO8601 format.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the container registry at the time the
     operation was called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded",
     "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :ivar status: The status of the container registry at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2019_05_01.models.Status
    :param admin_user_enabled: The value that indicates whether the admin user is enabled.
    :type admin_user_enabled: bool
    :param storage_account: The properties of the storage account for the container registry. Only
     applicable to Classic SKU.
    :type storage_account:
     ~azure.mgmt.containerregistry.v2019_05_01.models.StorageAccountProperties
    :param network_rule_set: The network rule set for a container registry.
    :type network_rule_set: ~azure.mgmt.containerregistry.v2019_05_01.models.NetworkRuleSet
    :param policies: The policies for a container registry.
    :type policies: ~azure.mgmt.containerregistry.v2019_05_01.models.Policies
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'login_server': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'login_server': {'key': 'properties.loginServer', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'StorageAccountProperties'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
        'policies': {'key': 'properties.policies', 'type': 'Policies'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Registry, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.login_server = None
        self.creation_date = None
        self.provisioning_state = None
        self.status = None
        self.admin_user_enabled = kwargs.get('admin_user_enabled', False)
        self.storage_account = kwargs.get('storage_account', None)
        self.network_rule_set = kwargs.get('network_rule_set', None)
        self.policies = kwargs.get('policies', None)


class RegistryListCredentialsResult(msrest.serialization.Model):
    """The response from the ListCredentials operation.

    :param username: The username for a container registry.
    :type username: str
    :param passwords: The list of passwords for a container registry.
    :type passwords: list[~azure.mgmt.containerregistry.v2019_05_01.models.RegistryPassword]
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[RegistryPassword]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryListCredentialsResult, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.passwords = kwargs.get('passwords', None)


class RegistryListResult(msrest.serialization.Model):
    """The result of a request to list container registries.

    :param value: The list of container registries. Since this list may be incomplete, the nextLink
     field should be used to request the next list of container registries.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Registry]
    :param next_link: The URI that can be used to request the next list of container registries.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Registry]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RegistryNameCheckRequest(msrest.serialization.Model):
    """A request to check whether a container registry name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the container registry.
    :type name: str
    :ivar type: Required. The resource type of the container registry. This field must be set to
     'Microsoft.ContainerRegistry/registries'. Default value:
     "Microsoft.ContainerRegistry/registries".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 5, 'pattern': r'^[a-zA-Z0-9]*$'},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.ContainerRegistry/registries"

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryNameCheckRequest, self).__init__(**kwargs)
        self.name = kwargs['name']


class RegistryNameStatus(msrest.serialization.Model):
    """The result of a request to check the availability of a container registry name.

    :param name_available: The value that indicates whether the name is available.
    :type name_available: bool
    :param reason: If any, the reason that the name is not available.
    :type reason: str
    :param message: If any, the error message that provides more detail for the reason that the
     name is not available.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryNameStatus, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class RegistryPassword(msrest.serialization.Model):
    """The login password for the container registry.

    :param name: The password name. Possible values include: "password", "password2".
    :type name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PasswordName
    :param value: The password value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryPassword, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class RegistryUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a container registry.

    :param tags: A set of tags. The tags for the container registry.
    :type tags: dict[str, str]
    :param sku: The SKU of the container registry.
    :type sku: ~azure.mgmt.containerregistry.v2019_05_01.models.Sku
    :param admin_user_enabled: The value that indicates whether the admin user is enabled.
    :type admin_user_enabled: bool
    :param network_rule_set: The network rule set for a container registry.
    :type network_rule_set: ~azure.mgmt.containerregistry.v2019_05_01.models.NetworkRuleSet
    :param policies: The policies for a container registry.
    :type policies: ~azure.mgmt.containerregistry.v2019_05_01.models.Policies
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
        'policies': {'key': 'properties.policies', 'type': 'Policies'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.sku = kwargs.get('sku', None)
        self.admin_user_enabled = kwargs.get('admin_user_enabled', None)
        self.network_rule_set = kwargs.get('network_rule_set', None)
        self.policies = kwargs.get('policies', None)


class RegistryUsage(msrest.serialization.Model):
    """The quota usage for a container registry.

    :param name: The name of the usage.
    :type name: str
    :param limit: The limit of the usage.
    :type limit: long
    :param current_value: The current value of the usage.
    :type current_value: long
    :param unit: The unit of measurement. Possible values include: "Count", "Bytes".
    :type unit: str or ~azure.mgmt.containerregistry.v2019_05_01.models.RegistryUsageUnit
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryUsage, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.limit = kwargs.get('limit', None)
        self.current_value = kwargs.get('current_value', None)
        self.unit = kwargs.get('unit', None)


class RegistryUsageListResult(msrest.serialization.Model):
    """The result of a request to get container registry quota usages.

    :param value: The list of container registry quota usages.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.RegistryUsage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RegistryUsage]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryUsageListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class Replication(Resource):
    """An object that represents a replication for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the replication at the time the operation
     was called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :ivar status: The status of the replication at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2019_05_01.models.Status
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Replication, self).__init__(**kwargs)
        self.provisioning_state = None
        self.status = None


class ReplicationListResult(msrest.serialization.Model):
    """The result of a request to list replications for a container registry.

    :param value: The list of replications. Since this list may be incomplete, the nextLink field
     should be used to request the next list of replications.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Replication]
    :param next_link: The URI that can be used to request the next list of replications.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Replication]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ReplicationUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a replication.

    :param tags: A set of tags. The tags for the replication.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class Request(msrest.serialization.Model):
    """The request that generated the event.

    :param id: The ID of the request that initiated the event.
    :type id: str
    :param addr: The IP or hostname and possibly port of the client connection that initiated the
     event. This is the RemoteAddr from the standard http request.
    :type addr: str
    :param host: The externally accessible hostname of the registry instance, as specified by the
     http host header on incoming requests.
    :type host: str
    :param method: The request method that generated the event.
    :type method: str
    :param useragent: The user agent header of the request.
    :type useragent: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'addr': {'key': 'addr', 'type': 'str'},
        'host': {'key': 'host', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'useragent': {'key': 'useragent', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Request, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.addr = kwargs.get('addr', None)
        self.host = kwargs.get('host', None)
        self.method = kwargs.get('method', None)
        self.useragent = kwargs.get('useragent', None)


class RetentionPolicy(msrest.serialization.Model):
    """The retention policy for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param days: The number of days to retain an untagged manifest after which it gets purged.
    :type days: int
    :ivar last_updated_time: The timestamp when the policy was last updated.
    :vartype last_updated_time: ~datetime.datetime
    :param status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _validation = {
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'days': {'key': 'days', 'type': 'int'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RetentionPolicy, self).__init__(**kwargs)
        self.days = kwargs.get('days', 7)
        self.last_updated_time = None
        self.status = kwargs.get('status', None)


class Run(ProxyResource):
    """Run resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param run_id: The unique identifier for the run.
    :type run_id: str
    :param status: The current status of the run. Possible values include: "Queued", "Started",
     "Running", "Succeeded", "Failed", "Canceled", "Error", "Timeout".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.RunStatus
    :param last_updated_time: The last updated time for the run.
    :type last_updated_time: ~datetime.datetime
    :param run_type: The type of run. Possible values include: "QuickBuild", "QuickRun",
     "AutoBuild", "AutoRun".
    :type run_type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.RunType
    :param create_time: The time the run was scheduled.
    :type create_time: ~datetime.datetime
    :param start_time: The time the run started.
    :type start_time: ~datetime.datetime
    :param finish_time: The time the run finished.
    :type finish_time: ~datetime.datetime
    :param output_images: The list of all images that were generated from the run. This is
     applicable if the run generates base image dependencies.
    :type output_images: list[~azure.mgmt.containerregistry.v2019_05_01.models.ImageDescriptor]
    :param task: The task against which run was scheduled.
    :type task: str
    :param image_update_trigger: The image update trigger that caused the run. This is applicable
     if the task has base image trigger configured.
    :type image_update_trigger: ~azure.mgmt.containerregistry.v2019_05_01.models.ImageUpdateTrigger
    :param source_trigger: The source trigger that caused the run.
    :type source_trigger: ~azure.mgmt.containerregistry.v2019_05_01.models.SourceTriggerDescriptor
    :param platform: The platform properties against which the run will happen.
    :type platform: ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param source_registry_auth: The scope of the credentials that were used to login to the source
     registry during this run.
    :type source_registry_auth: str
    :param custom_registries: The list of custom registries that were logged in during this run.
    :type custom_registries: list[str]
    :ivar run_error_message: The error message received from backend systems after the run is
     scheduled.
    :vartype run_error_message: str
    :param provisioning_state: The provisioning state of a run. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :type provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :param is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :type is_archive_enabled: bool
    :param timer_trigger: The timer trigger that caused the run.
    :type timer_trigger: ~azure.mgmt.containerregistry.v2019_05_01.models.TimerTriggerDescriptor
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'run_error_message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'run_id': {'key': 'properties.runId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
        'run_type': {'key': 'properties.runType', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'finish_time': {'key': 'properties.finishTime', 'type': 'iso-8601'},
        'output_images': {'key': 'properties.outputImages', 'type': '[ImageDescriptor]'},
        'task': {'key': 'properties.task', 'type': 'str'},
        'image_update_trigger': {'key': 'properties.imageUpdateTrigger', 'type': 'ImageUpdateTrigger'},
        'source_trigger': {'key': 'properties.sourceTrigger', 'type': 'SourceTriggerDescriptor'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'source_registry_auth': {'key': 'properties.sourceRegistryAuth', 'type': 'str'},
        'custom_registries': {'key': 'properties.customRegistries', 'type': '[str]'},
        'run_error_message': {'key': 'properties.runErrorMessage', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_archive_enabled': {'key': 'properties.isArchiveEnabled', 'type': 'bool'},
        'timer_trigger': {'key': 'properties.timerTrigger', 'type': 'TimerTriggerDescriptor'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Run, self).__init__(**kwargs)
        self.run_id = kwargs.get('run_id', None)
        self.status = kwargs.get('status', None)
        self.last_updated_time = kwargs.get('last_updated_time', None)
        self.run_type = kwargs.get('run_type', None)
        self.create_time = kwargs.get('create_time', None)
        self.start_time = kwargs.get('start_time', None)
        self.finish_time = kwargs.get('finish_time', None)
        self.output_images = kwargs.get('output_images', None)
        self.task = kwargs.get('task', None)
        self.image_update_trigger = kwargs.get('image_update_trigger', None)
        self.source_trigger = kwargs.get('source_trigger', None)
        self.platform = kwargs.get('platform', None)
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.source_registry_auth = kwargs.get('source_registry_auth', None)
        self.custom_registries = kwargs.get('custom_registries', None)
        self.run_error_message = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.is_archive_enabled = kwargs.get('is_archive_enabled', False)
        self.timer_trigger = kwargs.get('timer_trigger', None)


class RunFilter(msrest.serialization.Model):
    """Properties that are enabled for Odata querying on runs.

    :param run_id: The unique identifier for the run.
    :type run_id: str
    :param run_type: The type of run. Possible values include: "QuickBuild", "QuickRun",
     "AutoBuild", "AutoRun".
    :type run_type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.RunType
    :param status: The current status of the run. Possible values include: "Queued", "Started",
     "Running", "Succeeded", "Failed", "Canceled", "Error", "Timeout".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.RunStatus
    :param create_time: The create time for a run.
    :type create_time: ~datetime.datetime
    :param finish_time: The time the run finished.
    :type finish_time: ~datetime.datetime
    :param output_image_manifests: The list of comma-separated image manifests that were generated
     from the run. This is applicable if the run is of
     build type.
    :type output_image_manifests: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :type is_archive_enabled: bool
    :param task_name: The name of the task that the run corresponds to.
    :type task_name: str
    """

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
        'run_type': {'key': 'runType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'finish_time': {'key': 'finishTime', 'type': 'iso-8601'},
        'output_image_manifests': {'key': 'outputImageManifests', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunFilter, self).__init__(**kwargs)
        self.run_id = kwargs.get('run_id', None)
        self.run_type = kwargs.get('run_type', None)
        self.status = kwargs.get('status', None)
        self.create_time = kwargs.get('create_time', None)
        self.finish_time = kwargs.get('finish_time', None)
        self.output_image_manifests = kwargs.get('output_image_manifests', None)
        self.is_archive_enabled = kwargs.get('is_archive_enabled', None)
        self.task_name = kwargs.get('task_name', None)


class RunGetLogResult(msrest.serialization.Model):
    """The result of get log link operation.

    :param log_link: The link to logs for a run on a azure container registry.
    :type log_link: str
    """

    _attribute_map = {
        'log_link': {'key': 'logLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunGetLogResult, self).__init__(**kwargs)
        self.log_link = kwargs.get('log_link', None)


class RunListResult(msrest.serialization.Model):
    """Collection of runs.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Run]
    :param next_link: The URI that can be used to request the next set of paged results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Run]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RunUpdateParameters(msrest.serialization.Model):
    """The set of run properties that can be updated.

    :param is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :type is_archive_enabled: bool
    """

    _attribute_map = {
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunUpdateParameters, self).__init__(**kwargs)
        self.is_archive_enabled = kwargs.get('is_archive_enabled', None)


class SecretObject(msrest.serialization.Model):
    """Describes the properties of a secret object value.

    :param value: The value of the secret. The format of this value will be determined
     based on the type of the secret object. If the type is Opaque, the value will be
     used as is without any modification.
    :type value: str
    :param type: The type of the secret object which determines how the value of the secret object
     has to be
     interpreted. Possible values include: "Opaque", "Vaultsecret".
    :type type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.SecretObjectType
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecretObject, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.type = kwargs.get('type', None)


class SetValue(msrest.serialization.Model):
    """The properties of a overridable value that can be passed to a task template.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the overridable value.
    :type name: str
    :param value: Required. The overridable value.
    :type value: str
    :param is_secret: Flag to indicate whether the value represents a secret or not.
    :type is_secret: bool
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'is_secret': {'key': 'isSecret', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SetValue, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.value = kwargs['value']
        self.is_secret = kwargs.get('is_secret', False)


class Sku(msrest.serialization.Model):
    """The SKU of a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The SKU name of the container registry. Required for registry creation.
     Possible values include: "Classic", "Basic", "Standard", "Premium".
    :type name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.SkuName
    :ivar tier: The SKU tier based on the SKU name. Possible values include: "Classic", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.containerregistry.v2019_05_01.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = None


class Source(msrest.serialization.Model):
    """The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.

    :param addr: The IP or hostname and the port of the registry node that generated the event.
     Generally, this will be resolved by os.Hostname() along with the running port.
    :type addr: str
    :param instance_id: The running instance of an application. Changes after each restart.
    :type instance_id: str
    """

    _attribute_map = {
        'addr': {'key': 'addr', 'type': 'str'},
        'instance_id': {'key': 'instanceID', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Source, self).__init__(**kwargs)
        self.addr = kwargs.get('addr', None)
        self.instance_id = kwargs.get('instance_id', None)


class SourceProperties(msrest.serialization.Model):
    """The properties of the source code repository.

    All required parameters must be populated in order to send to Azure.

    :param source_control_type: Required. The type of source control service. Possible values
     include: "Github", "VisualStudioTeamService".
    :type source_control_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceControlType
    :param repository_url: Required. The full URL to the source code repository.
    :type repository_url: str
    :param branch: The branch name of the source code.
    :type branch: str
    :param source_control_auth_properties: The authorization properties for accessing the source
     code repository and to set up
     webhooks for notifications.
    :type source_control_auth_properties: ~azure.mgmt.containerregistry.v2019_05_01.models.AuthInfo
    """

    _validation = {
        'source_control_type': {'required': True},
        'repository_url': {'required': True},
    }

    _attribute_map = {
        'source_control_type': {'key': 'sourceControlType', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch': {'key': 'branch', 'type': 'str'},
        'source_control_auth_properties': {'key': 'sourceControlAuthProperties', 'type': 'AuthInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceProperties, self).__init__(**kwargs)
        self.source_control_type = kwargs['source_control_type']
        self.repository_url = kwargs['repository_url']
        self.branch = kwargs.get('branch', None)
        self.source_control_auth_properties = kwargs.get('source_control_auth_properties', None)


class SourceRegistryCredentials(msrest.serialization.Model):
    """Describes the credential parameters for accessing the source registry.

    :param login_mode: The authentication mode which determines the source registry login scope.
     The credentials for the source registry
     will be generated using the given scope. These credentials will be used to login to
     the source registry during the run. Possible values include: "None", "Default".
    :type login_mode: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceRegistryLoginMode
    """

    _attribute_map = {
        'login_mode': {'key': 'loginMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceRegistryCredentials, self).__init__(**kwargs)
        self.login_mode = kwargs.get('login_mode', None)


class SourceTrigger(msrest.serialization.Model):
    """The properties of a source based trigger.

    All required parameters must be populated in order to send to Azure.

    :param source_repository: Required. The properties that describes the source(code) for the
     task.
    :type source_repository: ~azure.mgmt.containerregistry.v2019_05_01.models.SourceProperties
    :param source_trigger_events: Required. The source event corresponding to the trigger.
    :type source_trigger_events: list[str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceTriggerEvent]
    :param status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'source_repository': {'required': True},
        'source_trigger_events': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'source_repository': {'key': 'sourceRepository', 'type': 'SourceProperties'},
        'source_trigger_events': {'key': 'sourceTriggerEvents', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceTrigger, self).__init__(**kwargs)
        self.source_repository = kwargs['source_repository']
        self.source_trigger_events = kwargs['source_trigger_events']
        self.status = kwargs.get('status', None)
        self.name = kwargs['name']


class SourceTriggerDescriptor(msrest.serialization.Model):
    """The source trigger that caused a run.

    :param id: The unique ID of the trigger.
    :type id: str
    :param event_type: The event type of the trigger.
    :type event_type: str
    :param commit_id: The unique ID that identifies a commit.
    :type commit_id: str
    :param pull_request_id: The unique ID that identifies pull request.
    :type pull_request_id: str
    :param repository_url: The repository URL.
    :type repository_url: str
    :param branch_name: The branch name in the repository.
    :type branch_name: str
    :param provider_type: The source control provider type.
    :type provider_type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'commit_id': {'key': 'commitId', 'type': 'str'},
        'pull_request_id': {'key': 'pullRequestId', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch_name': {'key': 'branchName', 'type': 'str'},
        'provider_type': {'key': 'providerType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceTriggerDescriptor, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.event_type = kwargs.get('event_type', None)
        self.commit_id = kwargs.get('commit_id', None)
        self.pull_request_id = kwargs.get('pull_request_id', None)
        self.repository_url = kwargs.get('repository_url', None)
        self.branch_name = kwargs.get('branch_name', None)
        self.provider_type = kwargs.get('provider_type', None)


class SourceTriggerUpdateParameters(msrest.serialization.Model):
    """The properties for updating a source based trigger.

    All required parameters must be populated in order to send to Azure.

    :param source_repository: The properties that describes the source(code) for the task.
    :type source_repository:
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceUpdateParameters
    :param source_trigger_events: The source event corresponding to the trigger.
    :type source_trigger_events: list[str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceTriggerEvent]
    :param status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'source_repository': {'key': 'sourceRepository', 'type': 'SourceUpdateParameters'},
        'source_trigger_events': {'key': 'sourceTriggerEvents', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceTriggerUpdateParameters, self).__init__(**kwargs)
        self.source_repository = kwargs.get('source_repository', None)
        self.source_trigger_events = kwargs.get('source_trigger_events', None)
        self.status = kwargs.get('status', None)
        self.name = kwargs['name']


class SourceUpdateParameters(msrest.serialization.Model):
    """The properties for updating the source code repository.

    :param source_control_type: The type of source control service. Possible values include:
     "Github", "VisualStudioTeamService".
    :type source_control_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceControlType
    :param repository_url: The full URL to the source code repository.
    :type repository_url: str
    :param branch: The branch name of the source code.
    :type branch: str
    :param source_control_auth_properties: The authorization properties for accessing the source
     code repository and to set up
     webhooks for notifications.
    :type source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2019_05_01.models.AuthInfoUpdateParameters
    """

    _attribute_map = {
        'source_control_type': {'key': 'sourceControlType', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch': {'key': 'branch', 'type': 'str'},
        'source_control_auth_properties': {'key': 'sourceControlAuthProperties', 'type': 'AuthInfoUpdateParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceUpdateParameters, self).__init__(**kwargs)
        self.source_control_type = kwargs.get('source_control_type', None)
        self.repository_url = kwargs.get('repository_url', None)
        self.branch = kwargs.get('branch', None)
        self.source_control_auth_properties = kwargs.get('source_control_auth_properties', None)


class SourceUploadDefinition(msrest.serialization.Model):
    """The properties of a response to source upload request.

    :param upload_url: The URL where the client can upload the source.
    :type upload_url: str
    :param relative_path: The relative path to the source. This is used to submit the subsequent
     queue build request.
    :type relative_path: str
    """

    _attribute_map = {
        'upload_url': {'key': 'uploadUrl', 'type': 'str'},
        'relative_path': {'key': 'relativePath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceUploadDefinition, self).__init__(**kwargs)
        self.upload_url = kwargs.get('upload_url', None)
        self.relative_path = kwargs.get('relative_path', None)


class Status(msrest.serialization.Model):
    """The status of an Azure resource at the time the operation was called.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_status: The short label for the status.
    :vartype display_status: str
    :ivar message: The detailed message for the status, including alerts and error messages.
    :vartype message: str
    :ivar timestamp: The timestamp when the status was changed to the current value.
    :vartype timestamp: ~datetime.datetime
    """

    _validation = {
        'display_status': {'readonly': True},
        'message': {'readonly': True},
        'timestamp': {'readonly': True},
    }

    _attribute_map = {
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Status, self).__init__(**kwargs)
        self.display_status = None
        self.message = None
        self.timestamp = None


class StorageAccountProperties(msrest.serialization.Model):
    """The properties of a storage account for a container registry. Only applicable to Classic SKU.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The resource ID of the storage account.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountProperties, self).__init__(**kwargs)
        self.id = kwargs['id']


class Target(msrest.serialization.Model):
    """The target of the event.

    :param media_type: The MIME type of the referenced object.
    :type media_type: str
    :param size: The number of bytes of the content. Same as Length field.
    :type size: long
    :param digest: The digest of the content, as defined by the Registry V2 HTTP API Specification.
    :type digest: str
    :param length: The number of bytes of the content. Same as Size field.
    :type length: long
    :param repository: The repository name.
    :type repository: str
    :param url: The direct URL to the content.
    :type url: str
    :param tag: The tag name.
    :type tag: str
    :param name: The name of the artifact.
    :type name: str
    :param version: The version of the artifact.
    :type version: str
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'length': {'key': 'length', 'type': 'long'},
        'repository': {'key': 'repository', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Target, self).__init__(**kwargs)
        self.media_type = kwargs.get('media_type', None)
        self.size = kwargs.get('size', None)
        self.digest = kwargs.get('digest', None)
        self.length = kwargs.get('length', None)
        self.repository = kwargs.get('repository', None)
        self.url = kwargs.get('url', None)
        self.tag = kwargs.get('tag', None)
        self.name = kwargs.get('name', None)
        self.version = kwargs.get('version', None)


class Task(Resource):
    """The task that has the ARM resource and task properties. 
The task will have all information to schedule a run against it.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param identity: Identity for the resource.
    :type identity: ~azure.mgmt.containerregistry.v2019_05_01.models.IdentityProperties
    :ivar provisioning_state: The provisioning state of the task. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :ivar creation_date: The creation date of task.
    :vartype creation_date: ~datetime.datetime
    :param status: The current status of task. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TaskStatus
    :param platform: The platform properties against which the run has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param timeout: Run timeout in seconds.
    :type timeout: int
    :param step: The properties of a task step.
    :type step: ~azure.mgmt.containerregistry.v2019_05_01.models.TaskStepProperties
    :param trigger: The properties that describe all triggers for the task.
    :type trigger: ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerProperties
    :param credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :type credentials: ~azure.mgmt.containerregistry.v2019_05_01.models.Credentials
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_date': {'readonly': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'step': {'key': 'properties.step', 'type': 'TaskStepProperties'},
        'trigger': {'key': 'properties.trigger', 'type': 'TriggerProperties'},
        'credentials': {'key': 'properties.credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Task, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.provisioning_state = None
        self.creation_date = None
        self.status = kwargs.get('status', None)
        self.platform = kwargs.get('platform', None)
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.timeout = kwargs.get('timeout', 3600)
        self.step = kwargs.get('step', None)
        self.trigger = kwargs.get('trigger', None)
        self.credentials = kwargs.get('credentials', None)


class TaskListResult(msrest.serialization.Model):
    """The collection of tasks.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Task]
    :param next_link: The URI that can be used to request the next set of paged results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Task]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class TaskRunRequest(RunRequest):
    """The parameters for a task run request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the run request.Constant filled by server.
    :vartype type: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :type is_archive_enabled: bool
    :param task_name: Required. The name of task against which run has to be queued.
    :type task_name: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    """

    _validation = {
        'type': {'readonly': True},
        'task_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskRunRequest, self).__init__(**kwargs)
        self.type = None
        self.task_name = kwargs['task_name']
        self.values = kwargs.get('values', None)


class TaskUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a task.

    :param identity: Identity for the resource.
    :type identity: ~azure.mgmt.containerregistry.v2019_05_01.models.IdentityProperties
    :param tags: A set of tags. The ARM resource tags.
    :type tags: dict[str, str]
    :param status: The current status of task. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TaskStatus
    :param platform: The platform properties against which the run has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformUpdateParameters
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param timeout: Run timeout in seconds.
    :type timeout: int
    :param step: The properties for updating a task step.
    :type step: ~azure.mgmt.containerregistry.v2019_05_01.models.TaskStepUpdateParameters
    :param trigger: The properties for updating trigger properties.
    :type trigger: ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerUpdateParameters
    :param credentials: The parameters that describes a set of credentials that will be used when
     this run is invoked.
    :type credentials: ~azure.mgmt.containerregistry.v2019_05_01.models.Credentials
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformUpdateParameters'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'step': {'key': 'properties.step', 'type': 'TaskStepUpdateParameters'},
        'trigger': {'key': 'properties.trigger', 'type': 'TriggerUpdateParameters'},
        'credentials': {'key': 'properties.credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskUpdateParameters, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.tags = kwargs.get('tags', None)
        self.status = kwargs.get('status', None)
        self.platform = kwargs.get('platform', None)
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.timeout = kwargs.get('timeout', None)
        self.step = kwargs.get('step', None)
        self.trigger = kwargs.get('trigger', None)
        self.credentials = kwargs.get('credentials', None)


class TimerTrigger(msrest.serialization.Model):
    """The properties of a timer trigger.

    All required parameters must be populated in order to send to Azure.

    :param schedule: Required. The CRON expression for the task schedule.
    :type schedule: str
    :param status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'schedule': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'schedule': {'key': 'schedule', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimerTrigger, self).__init__(**kwargs)
        self.schedule = kwargs['schedule']
        self.status = kwargs.get('status', None)
        self.name = kwargs['name']


class TimerTriggerDescriptor(msrest.serialization.Model):
    """TimerTriggerDescriptor.

    :param timer_trigger_name: The timer trigger name that caused the run.
    :type timer_trigger_name: str
    :param schedule_occurrence: The occurrence that triggered the run.
    :type schedule_occurrence: str
    """

    _attribute_map = {
        'timer_trigger_name': {'key': 'timerTriggerName', 'type': 'str'},
        'schedule_occurrence': {'key': 'scheduleOccurrence', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimerTriggerDescriptor, self).__init__(**kwargs)
        self.timer_trigger_name = kwargs.get('timer_trigger_name', None)
        self.schedule_occurrence = kwargs.get('schedule_occurrence', None)


class TimerTriggerUpdateParameters(msrest.serialization.Model):
    """The properties for updating a timer trigger.

    All required parameters must be populated in order to send to Azure.

    :param schedule: The CRON expression for the task schedule.
    :type schedule: str
    :param status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'schedule': {'key': 'schedule', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimerTriggerUpdateParameters, self).__init__(**kwargs)
        self.schedule = kwargs.get('schedule', None)
        self.status = kwargs.get('status', None)
        self.name = kwargs['name']


class TriggerProperties(msrest.serialization.Model):
    """The properties of a trigger.

    :param timer_triggers: The collection of timer triggers.
    :type timer_triggers: list[~azure.mgmt.containerregistry.v2019_05_01.models.TimerTrigger]
    :param source_triggers: The collection of triggers based on source code repository.
    :type source_triggers: list[~azure.mgmt.containerregistry.v2019_05_01.models.SourceTrigger]
    :param base_image_trigger: The trigger based on base image dependencies.
    :type base_image_trigger: ~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageTrigger
    """

    _attribute_map = {
        'timer_triggers': {'key': 'timerTriggers', 'type': '[TimerTrigger]'},
        'source_triggers': {'key': 'sourceTriggers', 'type': '[SourceTrigger]'},
        'base_image_trigger': {'key': 'baseImageTrigger', 'type': 'BaseImageTrigger'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggerProperties, self).__init__(**kwargs)
        self.timer_triggers = kwargs.get('timer_triggers', None)
        self.source_triggers = kwargs.get('source_triggers', None)
        self.base_image_trigger = kwargs.get('base_image_trigger', None)


class TriggerUpdateParameters(msrest.serialization.Model):
    """The properties for updating triggers.

    :param timer_triggers: The collection of timer triggers.
    :type timer_triggers:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.TimerTriggerUpdateParameters]
    :param source_triggers: The collection of triggers based on source code repository.
    :type source_triggers:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.SourceTriggerUpdateParameters]
    :param base_image_trigger: The trigger based on base image dependencies.
    :type base_image_trigger:
     ~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageTriggerUpdateParameters
    """

    _attribute_map = {
        'timer_triggers': {'key': 'timerTriggers', 'type': '[TimerTriggerUpdateParameters]'},
        'source_triggers': {'key': 'sourceTriggers', 'type': '[SourceTriggerUpdateParameters]'},
        'base_image_trigger': {'key': 'baseImageTrigger', 'type': 'BaseImageTriggerUpdateParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggerUpdateParameters, self).__init__(**kwargs)
        self.timer_triggers = kwargs.get('timer_triggers', None)
        self.source_triggers = kwargs.get('source_triggers', None)
        self.base_image_trigger = kwargs.get('base_image_trigger', None)


class TrustPolicy(msrest.serialization.Model):
    """The content trust policy for a container registry.

    :param type: The type of trust policy. Possible values include: "Notary". Default value:
     "Notary".
    :type type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TrustPolicyType
    :param status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrustPolicy, self).__init__(**kwargs)
        self.type = kwargs.get('type', "Notary")
        self.status = kwargs.get('status', None)


class UserIdentityProperties(msrest.serialization.Model):
    """UserIdentityProperties.

    :param principal_id: The principal id of user assigned identity.
    :type principal_id: str
    :param client_id: The client id of user assigned identity.
    :type client_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserIdentityProperties, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.client_id = kwargs.get('client_id', None)


class VirtualNetworkRule(msrest.serialization.Model):
    """Virtual network rule.

    All required parameters must be populated in order to send to Azure.

    :param action: The action of virtual network rule. Possible values include: "Allow".
    :type action: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Action
    :param virtual_network_resource_id: Required. Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :type virtual_network_resource_id: str
    """

    _validation = {
        'virtual_network_resource_id': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'virtual_network_resource_id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)
        self.virtual_network_resource_id = kwargs['virtual_network_resource_id']


class Webhook(Resource):
    """An object that represents a webhook for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: The list of actions that trigger the webhook to post notifications.
    :type actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    :ivar provisioning_state: The provisioning state of the webhook at the time the operation was
     called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Webhook, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.scope = kwargs.get('scope', None)
        self.actions = kwargs.get('actions', None)
        self.provisioning_state = None


class WebhookCreateParameters(msrest.serialization.Model):
    """The parameters for creating a webhook.

    All required parameters must be populated in order to send to Azure.

    :param tags: A set of tags. The tags for the webhook.
    :type tags: dict[str, str]
    :param location: Required. The location of the webhook. This cannot be changed after the
     resource is created.
    :type location: str
    :param service_uri: The service URI for the webhook to post notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook notifications.
    :type custom_headers: dict[str, str]
    :param status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: The list of actions that trigger the webhook to post notifications.
    :type actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookCreateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']
        self.service_uri = kwargs.get('service_uri', None)
        self.custom_headers = kwargs.get('custom_headers', None)
        self.status = kwargs.get('status', None)
        self.scope = kwargs.get('scope', None)
        self.actions = kwargs.get('actions', None)


class WebhookListResult(msrest.serialization.Model):
    """The result of a request to list webhooks for a container registry.

    :param value: The list of webhooks. Since this list may be incomplete, the nextLink field
     should be used to request the next list of webhooks.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Webhook]
    :param next_link: The URI that can be used to request the next list of webhooks.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Webhook]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class WebhookUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a webhook.

    :param tags: A set of tags. The tags for the webhook.
    :type tags: dict[str, str]
    :param service_uri: The service URI for the webhook to post notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook notifications.
    :type custom_headers: dict[str, str]
    :param status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: The list of actions that trigger the webhook to post notifications.
    :type actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.service_uri = kwargs.get('service_uri', None)
        self.custom_headers = kwargs.get('custom_headers', None)
        self.status = kwargs.get('status', None)
        self.scope = kwargs.get('scope', None)
        self.actions = kwargs.get('actions', None)
