/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import viewer.common.Parameters;
import viewer.common.SwingWorker;
import viewer.zoomable.InitializableDialog;
import viewer.zoomable.SummarizableView;

public class OperationDurationPanel
extends JPanel {
    private static final long serialVersionUID = 4100L;
    private static final Component GLUE = Box.createHorizontalGlue();
    private static Border Normal_Border = null;
    private TimeBoundingBox timebox;
    private SummarizableView summarizable;
    private InitializableDialog summary_dialog;
    private Dialog root_dialog;

    public OperationDurationPanel(TimeBoundingBox timeBoundingBox, SummarizableView summarizableView) {
        super.setLayout(new BoxLayout(this, 1));
        this.timebox = timeBoundingBox;
        this.summarizable = summarizableView;
        this.summary_dialog = null;
        this.root_dialog = null;
        if (Normal_Border == null) {
            Normal_Border = BorderFactory.createEtchedBorder();
        }
        super.setBorder(Normal_Border);
        JPanel jPanel = new JPanel();
        JButton jButton = null;
        URL uRL = this.getURL("/images/Stat110x40.gif");
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            ImageIcon imageIcon2 = new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage()));
            jButton = new JButton(imageIcon);
            jButton.setPressedIcon(imageIcon2);
            Border border = BorderFactory.createRaisedBevelBorder();
            Border border2 = BorderFactory.createLoweredBevelBorder();
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
            CompoundBorder compoundBorder2 = BorderFactory.createCompoundBorder(border, compoundBorder);
            jButton.setBorder(compoundBorder2);
        } else {
            jButton = new JButton("Sumary Statistics");
        }
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.setToolTipText("Summary Statistics for the selected duration, timelines & legends");
        jButton.addActionListener(new StatBtnActionListener());
        jPanel.add(GLUE);
        jPanel.add(jButton);
        jPanel.add(GLUE);
        super.add(jPanel);
    }

    private URL getURL(String string) {
        URL uRL = null;
        uRL = this.getClass().getResource(string);
        return uRL;
    }

    private void createSummaryDialog() {
        this.root_dialog = (Dialog)SwingUtilities.windowForComponent(this);
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                OperationDurationPanel.this.summary_dialog = OperationDurationPanel.this.summarizable.createSummary(OperationDurationPanel.this.root_dialog, OperationDurationPanel.this.timebox);
                return null;
            }

            @Override
            public void finished() {
                OperationDurationPanel.this.summary_dialog.pack();
                if (Parameters.AUTO_WINDOWS_LOCATION) {
                    Rectangle rectangle = OperationDurationPanel.this.root_dialog.getBounds();
                    OperationDurationPanel.this.summary_dialog.setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                }
                OperationDurationPanel.this.summary_dialog.setVisible(true);
                OperationDurationPanel.this.summary_dialog.init();
            }
        };
        swingWorker.start();
    }

    private class StatBtnActionListener
    implements ActionListener {
        private StatBtnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OperationDurationPanel.this.createSummaryDialog();
        }
    }
}

