/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.conv.NumberListFormat;
import com.jclark.xsl.expr.Pattern;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.NumberListFormatTemplate;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.Result;

class SingleLevelNumberAction
implements Action {
    private Pattern count;
    private Pattern from;
    private NumberListFormatTemplate formatTemplate;

    SingleLevelNumberAction(Pattern count, Pattern from, NumberListFormatTemplate formatTemplate) {
        this.count = count;
        this.from = from;
        this.formatTemplate = formatTemplate;
    }

    public void invoke(ProcessContext context, Node node, Result result) throws XSLException {
        NumberListFormat format = this.formatTemplate.instantiate(context, node);
        result.characters(format.getPrefix(0));
        if (this.count == null) {
            if (node.getType() == 0) {
                Name name = node.getName();
                int n = 0;
                SafeNodeIterator iter = node.getParent().getChildren();
                while (true) {
                    Node tem;
                    if (!name.equals((tem = iter.next()).getName()) || tem.getType() != 0) {
                        continue;
                    }
                    ++n;
                    if (tem.equals(node)) break;
                }
                result.characters(format.formatNumber(0, n));
            }
        } else {
            Node parent;
            if (node.getType() == 2) {
                node = node.getParent();
            }
            do {
                parent = node.getParent();
                if (!this.count.matches(node, context)) continue;
                int n = 0;
                SafeNodeIterator iter = parent.getChildren();
                while (true) {
                    Node tem;
                    if (!this.count.matches(tem = iter.next(), context)) {
                        continue;
                    }
                    ++n;
                    if (tem.equals(node)) break;
                }
                result.characters(format.formatNumber(0, n));
                break;
            } while ((this.from == null || !this.from.matches(node, context)) && (node = parent) != null);
        }
        result.characters(format.getSuffix());
    }
}

