/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.OutputDocumentHandler;
import com.jclark.xsl.sax.RawCharactersHandler;
import java.io.IOException;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Indenter
implements OutputDocumentHandler,
CommentHandler,
RawCharactersHandler {
    private DocumentHandler documentHandler = null;
    private CommentHandler commentHandler = null;
    private RawCharactersHandler rawCharactersHandler;
    private char[] newline = new char[]{'\n'};
    private static final byte IN_PCDATA_CHUNK = 0;
    private static final byte JUST_HAD_START_TAG = 1;
    private static final byte OTHER = 2;
    private byte state = 0;

    public Indenter(DocumentHandler handler, RawCharactersHandler rawCharactersHandler) {
        this.documentHandler = handler;
        this.commentHandler = handler instanceof CommentHandler ? (CommentHandler)((Object)handler) : null;
        this.rawCharactersHandler = rawCharactersHandler;
    }

    public DocumentHandler init(Destination dest, AttributeList atts) throws IOException, SAXException {
        if (this.documentHandler instanceof OutputDocumentHandler) {
            this.documentHandler = ((OutputDocumentHandler)this.documentHandler).init(dest, atts);
        }
        return this;
    }

    public void setDocumentLocator(Locator locator) {
        this.documentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.documentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.maybeNewline();
        this.documentHandler.endDocument();
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        this.maybeNewline();
        this.state = 1;
        this.documentHandler.startElement(name, atts);
    }

    public void endElement(String name) throws SAXException {
        if (this.state == 1) {
            this.state = (byte)2;
        } else {
            this.maybeNewline();
        }
        this.documentHandler.endElement(name);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length > 0) {
            this.documentHandler.characters(ch, start, length);
            this.state = 0;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (length > 0) {
            this.documentHandler.ignorableWhitespace(ch, start, length);
            this.state = 0;
        }
    }

    public void rawCharacters(String chars) throws SAXException {
        if (chars.length() > 0) {
            this.rawCharactersHandler.rawCharacters(chars);
            this.state = 0;
        }
    }

    private final void maybeNewline() throws SAXException {
        if (this.state != 0) {
            this.documentHandler.characters(this.newline, 0, 1);
            this.newline[0] = 10;
        }
        this.state = (byte)2;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.maybeNewline();
        this.documentHandler.processingInstruction(target, data);
    }

    public void comment(String contents) throws SAXException {
        if (this.commentHandler != null) {
            this.maybeNewline();
            this.commentHandler.comment(contents);
        }
    }
}

