#!/bin/sh -e

# $1 = version
TAR=../libjboss-common-java_$1.orig.tar.gz
DIR=libjboss-common-java-$1.orig
REVISION=`echo $1 | sed -e 's/.*svn//'`

# clean up the upstream tarball
mkdir $DIR
(cd $DIR;\
svn export -r $REVISION http://anonsvn.jboss.org/repos/common/common-core/trunk common-core;\
svn export -r $REVISION http://anonsvn.jboss.org/repos/common/common-logging-jdk/trunk common-logging-jdk;\
svn export -r $REVISION http://anonsvn.jboss.org/repos/common/common-logging-log4j/trunk common-logging-log4j;\
svn export -r $REVISION http://anonsvn.jboss.org/repos/common/common-logging-spi/trunk common-logging-spi)
GZIP=--best tar -c -z -f $TAR $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi
