/*--------------------------------------------------------------------------+
$Id: Order.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.xml.example;

/**
 * XML facility demo model class.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: E90295498A709EF992D08C7EB1AA2137
 */
public class Order {

	/** Order description (persisted as text of {@link EXMLElement#ORDER}). */
	private final String description;

	/** Article number (persisted as {@link EXMLAttribute#ARTICLE_NUMBER}). */
	private final String articleNumber;

	/** Create new order. */
	public Order(String description, String articleNumber) {
		super();
		this.description = description;
		this.articleNumber = articleNumber;
	}

	/** Get description. */
	public String getDescription() {
		return description;
	}

	/** Get number. */
	public String getArticleNumber() {
		return articleNumber;
	}

	/** Deep equals. */
	@Override
	public boolean equals(Object other) {
		if (!(other instanceof Order)) {
			return false;
		}
		Order otherOrder = (Order) other;

		return description.equals(otherOrder.description)
				&& (articleNumber.equals(otherOrder.articleNumber));
	}

	/** {@inheritDoc} */
	@Override
	public int hashCode() {
		// using fixed hash code here as this method should not be used in the
		// tests
		return 13;
	}
}