/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.lisaac.ldt.LisaacMessages;
import org.lisaac.ldt.editors.AbstractLisaacEditor;
import org.lisaac.ldt.editors.LisaacScanner;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.refactor.RenamePrototypeRefactor;
import org.lisaac.ldt.refactor.RenamePrototypeWizard;

public class RenamePrototype
implements IWorkbenchWindowActionDelegate {
    private String prototypeName;
    private LisaacModel model;
    private IWorkbenchWindow fWindow = null;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        if (this.fWindow != null && this.prototypeName != null && this.model != null) {
            RenamePrototypeRefactor refactoring = new RenamePrototypeRefactor(this.prototypeName, this.model);
            String name = LisaacMessages.getString("RenamePrototype.0");
            this.run(new RenamePrototypeWizard(refactoring, this.prototypeName, name), this.fWindow.getShell(), name);
        }
    }

    public void run(RefactoringWizard wizard, Shell parent, String dialogTitle) {
        try {
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation(wizard);
            operation.run(parent, dialogTitle);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.prototypeName = null;
        if (selection instanceof ITextSelection) {
            IWorkbenchPart part;
            String text = ((ITextSelection)selection).getText();
            if (this.fWindow != null && (part = this.fWindow.getPartService().getActivePart()) instanceof AbstractLisaacEditor) {
                IDocument document = ((AbstractLisaacEditor)part).getDocument();
                IProject project = ((AbstractLisaacEditor)part).getProject();
                this.model = LisaacModel.getModel(project);
                try {
                    text = this.selectWord(document, ((ITextSelection)selection).getOffset());
                }
                catch (BadLocationException badLocationException) {
                    action.setEnabled(false);
                    return;
                }
            }
            if (LisaacScanner.isPrototypeIdentifier(text)) {
                this.prototypeName = text;
            }
        }
        action.setEnabled(this.prototypeName != null);
    }

    protected String selectWord(IDocument doc, int caretPos) throws BadLocationException {
        char c;
        int pos = caretPos;
        while (pos >= 0) {
            c = doc.getChar(pos);
            if (!Character.isJavaIdentifierPart(c)) break;
            --pos;
        }
        int startPos = pos + 1;
        pos = caretPos;
        int length = doc.getLength();
        while (pos < length) {
            c = doc.getChar(pos);
            if (!Character.isJavaIdentifierPart(c)) break;
            ++pos;
        }
        int endPos = pos;
        return doc.get(startPos, endPos - startPos);
    }
}

