/* Copyright (C) 2022-2025 Free Software Foundation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses>.  */

package org.gprofng.mpmt.picklist;

import java.util.EventObject;

/** Defines an event that encapsulates changes to a Picklist. */
public class PickListEvent extends EventObject {

  /** Identifies one or more changes in the lists contents. */
  public static final int CONTENTS_CHANGED = 0;
  /** * The type of this event; */
  private int type;

  /**
   * Constructs a PicklistDataEvent object.
   *
   * @param source the source Object (typically <code>this</code>)
   * @param type an int specifying {@link #CONTENTS_CHANGED}
   */
  public PickListEvent(Object source, int type) {
    super(source);
    this.type = type;
  }

  /**
   * Returns the event type. The possible values are:
   *
   * <ul>
   *   <li>{@link #CONTENTS_CHANGED}
   * </ul>
   *
   * @return an int representing the type value
   */
  public int getType() {
    return type;
  }
}
