package pom

import "sync"

// artifactQueue the queue of Items
type artifactQueue struct {
	items []artifact
	lock  sync.RWMutex
}

func newArtifactQueue() *artifactQueue {
	return &artifactQueue{}
}

func (s *artifactQueue) enqueue(items ...artifact) {
	s.lock.Lock()
	s.items = append(s.items, items...)
	s.lock.Unlock()
}

func (s *artifactQueue) dequeue() artifact {
	s.lock.Lock()
	item := s.items[0]
	s.items = s.items[1:]
	s.lock.Unlock()
	return item
}

// IsEmpty returns true if the queue is empty
func (s *artifactQueue) IsEmpty() bool {
	return len(s.items) == 0
}
