// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v4.23.1
// source: repository.proto

package gitalypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// RepositoryServiceClient is the client API for RepositoryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RepositoryServiceClient interface {
	// RepositoryExists returns whether a given repository exists.
	RepositoryExists(ctx context.Context, in *RepositoryExistsRequest, opts ...grpc.CallOption) (*RepositoryExistsResponse, error)
	// RepositorySize returns information on the complete on-disk repository size. If you need more
	// detailed information about the size of various sub-structures you should instead use the
	// repositoryInfo RPC.
	RepositorySize(ctx context.Context, in *RepositorySizeRequest, opts ...grpc.CallOption) (*RepositorySizeResponse, error)
	// RepositoryInfo returns detailed information about a repository and its data structures.
	RepositoryInfo(ctx context.Context, in *RepositoryInfoRequest, opts ...grpc.CallOption) (*RepositoryInfoResponse, error)
	// ObjectsSize calculates the total on-disk object size of reachable objects in bytes. In contrast
	// to RepositorySize and RepositoryInfo, this RPC performs a graph walk of the specified revisions
	// and will thus return an accurate view of how large the accumulated on-disk size of reachable
	// objects is.
	//
	// As this RPC needs to perform a revision walk, it is significantly more expensive than the RPCs
	// which simply check the size of on-disk data structures. On the other hand, it allows the caller
	// to accurately compute the size of objects in a way that is at least somewhat detached from the
	// on-disk representation:
	//
	//   - Objects which exist in multiple packfiles will not be double-counted.
	//   - Objects which aren't reachable will not be accounted for.
	//   - It is possible to only account for a subset of references, e.g. only those that an admin
	//     would have direct control over.
	//
	// It is thus recommended to use this RPC whenever you want to calculate sizes which will end up
	// being shown to the user.
	//
	// Note that the size is still bound to change when repositories are getting repacked and thus
	// cannot be considered to be stable. This is because the on-disk size of any object can change
	// depending on how Git decides to deltify it in a packfile. Thus, when a repack would cause a
	// different delta base to be picked, the actual on-disk size of any given object may change.
	ObjectsSize(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_ObjectsSizeClient, error)
	// ObjectFormat determines the object format that is being used by the repository.
	ObjectFormat(ctx context.Context, in *ObjectFormatRequest, opts ...grpc.CallOption) (*ObjectFormatResponse, error)
	// Deprecated: Do not use.
	// ApplyGitattributes writes the attributes from the given revision to info/attributes.
	// This RPC will be removed in 17.0.
	ApplyGitattributes(ctx context.Context, in *ApplyGitattributesRequest, opts ...grpc.CallOption) (*ApplyGitattributesResponse, error)
	// FetchRemote fetches references from a remote repository into the local
	// repository. The remote can be fetched via HTTP or SSH depending on the
	// request options provided.
	FetchRemote(ctx context.Context, in *FetchRemoteRequest, opts ...grpc.CallOption) (*FetchRemoteResponse, error)
	// CreateRepository creates a new empty repository.
	CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*CreateRepositoryResponse, error)
	// GetArchive produces and returns an archive of a repository.
	GetArchive(ctx context.Context, in *GetArchiveRequest, opts ...grpc.CallOption) (RepositoryService_GetArchiveClient, error)
	// HasLocalBranches returns whether the given repo contains any branches.
	HasLocalBranches(ctx context.Context, in *HasLocalBranchesRequest, opts ...grpc.CallOption) (*HasLocalBranchesResponse, error)
	// FetchSourceBranch fetches a branch from a second (potentially remote)
	// repository into the given repository.
	FetchSourceBranch(ctx context.Context, in *FetchSourceBranchRequest, opts ...grpc.CallOption) (*FetchSourceBranchResponse, error)
	// Fsck checks the repository for consistency via git-fsck(1). This can be used to check for
	// repository corruption.
	Fsck(ctx context.Context, in *FsckRequest, opts ...grpc.CallOption) (*FsckResponse, error)
	// WriteRef creates or updates a ref in a repository to point to a new value.
	WriteRef(ctx context.Context, in *WriteRefRequest, opts ...grpc.CallOption) (*WriteRefResponse, error)
	// FindMergeBase returns the best common ancestor between two or more commits. Consult the man
	// pages of git-merge-base(1) for more information on how this is calculated.
	FindMergeBase(ctx context.Context, in *FindMergeBaseRequest, opts ...grpc.CallOption) (*FindMergeBaseResponse, error)
	// CreateFork creates a new repository from a specific source repository. This new repository will
	// have the same branches and tags as the source repository. Internal references will not be
	// recreated in the forked repository.
	//
	// all objects of the source repository will be duplicated, that is there are no space savings by
	// creating the repository like this. The newly created repository does not join the object pool
	// of the source repository, if there is any.
	CreateFork(ctx context.Context, in *CreateForkRequest, opts ...grpc.CallOption) (*CreateForkResponse, error)
	// CreateRepositoryFromURL creates a new repo and seeds it with the contents of an existing Git repo
	// reachable at the provided URL.
	CreateRepositoryFromURL(ctx context.Context, in *CreateRepositoryFromURLRequest, opts ...grpc.CallOption) (*CreateRepositoryFromURLResponse, error)
	// CreateBundle creates a bundle from all refs
	CreateBundle(ctx context.Context, in *CreateBundleRequest, opts ...grpc.CallOption) (RepositoryService_CreateBundleClient, error)
	// CreateBundleFromRefList creates a bundle from a stream of ref patterns.
	// When the bundle would be empty the FailedPrecondition error code is returned.
	CreateBundleFromRefList(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_CreateBundleFromRefListClient, error)
	// FetchBundle fetches references from a bundle into the local repository.
	// refs will be mirrored to the target repository with the refspec
	// "+refs/*:refs/*" and refs that do not exist in the bundle will be removed.
	FetchBundle(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_FetchBundleClient, error)
	// CreateRepositoryFromBundle creates a Git repository at the specified storage and path, if it
	// does not already exist, from the provided Git bundle.
	CreateRepositoryFromBundle(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_CreateRepositoryFromBundleClient, error)
	// GetConfig reads the target repository's gitconfig and streams its contents
	// back. Returns a NotFound error in case no gitconfig was found.
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (RepositoryService_GetConfigClient, error)
	// FindLicense looks in the given repository and attempts to detect all the
	// details about the license used in the repository.
	FindLicense(ctx context.Context, in *FindLicenseRequest, opts ...grpc.CallOption) (*FindLicenseResponse, error)
	// Deprecated: Do not use.
	// GetInfoAttributes reads the contents from info/attributes.
	// This RPC will be removed in 17.0.
	GetInfoAttributes(ctx context.Context, in *GetInfoAttributesRequest, opts ...grpc.CallOption) (RepositoryService_GetInfoAttributesClient, error)
	// CalculateChecksum returns a checksum of the repository by hashing its references. Refs
	// outside of well-known namespaces are not considered when computing the checksum.
	CalculateChecksum(ctx context.Context, in *CalculateChecksumRequest, opts ...grpc.CallOption) (*CalculateChecksumResponse, error)
	// GetSnapshot returns a snapshot of the repository. A snapshot comprises all Git references
	// and objects required to recreate the state of a repository at a point in time.
	GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (RepositoryService_GetSnapshotClient, error)
	// CreateRepositoryFromSnapshot creates a new repository based on a snapshot created with
	// the GetSnapshot RPC. The snapshot is fetched via HTTP.
	CreateRepositoryFromSnapshot(ctx context.Context, in *CreateRepositoryFromSnapshotRequest, opts ...grpc.CallOption) (*CreateRepositoryFromSnapshotResponse, error)
	// GetRawChanges returns metadata in raw format on the changes between two revisions.
	GetRawChanges(ctx context.Context, in *GetRawChangesRequest, opts ...grpc.CallOption) (RepositoryService_GetRawChangesClient, error)
	// SearchFilesByContent searches files in the repository using the provided grep pattern.
	// For each result, the matched line is returned along with the two previous and next lines.
	SearchFilesByContent(ctx context.Context, in *SearchFilesByContentRequest, opts ...grpc.CallOption) (RepositoryService_SearchFilesByContentClient, error)
	// SearchFilesByName searches files in the repository based on its name and an
	// optional filter.
	SearchFilesByName(ctx context.Context, in *SearchFilesByNameRequest, opts ...grpc.CallOption) (RepositoryService_SearchFilesByNameClient, error)
	// Deprecated: Do not use.
	// RestoreCustomHooks sets the git hooks for a repository. The hooks are sent
	// in a tar archive containing a `custom_hooks` directory. This directory is
	// ultimately extracted to the repository.
	RestoreCustomHooks(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_RestoreCustomHooksClient, error)
	// SetCustomHooks sets the git hooks for a repository. The hooks are sent in a
	// tar archive containing a `custom_hooks` directory (i.e. the response from the
	// GetCustomHooksResponse RPC. This directory will be extracted into the repository.
	SetCustomHooks(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_SetCustomHooksClient, error)
	// Deprecated: Do not use.
	// BackupCustomHooks fetches the git hooks for a repository. The hooks are
	// sent in a tar archive containing a `custom_hooks` directory. If no hooks
	// are present in the repository, the response will have no data.
	BackupCustomHooks(ctx context.Context, in *BackupCustomHooksRequest, opts ...grpc.CallOption) (RepositoryService_BackupCustomHooksClient, error)
	// GetCustomHooks fetches the git hooks for a repository. The hooks are sent
	// in a tar archive containing a `custom_hooks` directory. If no hooks are
	// present in the repository, the response will have no data.
	GetCustomHooks(ctx context.Context, in *GetCustomHooksRequest, opts ...grpc.CallOption) (RepositoryService_GetCustomHooksClient, error)
	// GetObjectDirectorySize returns the size in kibibytes of the object directory of a repository.
	GetObjectDirectorySize(ctx context.Context, in *GetObjectDirectorySizeRequest, opts ...grpc.CallOption) (*GetObjectDirectorySizeResponse, error)
	// RemoveRepository will move the repository to `+gitaly/tmp/<relative_path>_removed` and
	// eventually remove it. This ensures that even on networked filesystems the
	// data is actually removed even if there's someone still handling the data.
	RemoveRepository(ctx context.Context, in *RemoveRepositoryRequest, opts ...grpc.CallOption) (*RemoveRepositoryResponse, error)
	// ReplicateRepository replicates data from a source repository to target repository. On the
	// target repository, this operation ensures synchronization of the following components:
	//
	// - Git config
	// - Git attributes
	// - Custom Git hooks,
	// - References and objects
	// - (Optional) Object deduplication network membership
	ReplicateRepository(ctx context.Context, in *ReplicateRepositoryRequest, opts ...grpc.CallOption) (*ReplicateRepositoryResponse, error)
	// OptimizeRepository performs all maintenance tasks in a repository to keep
	// it in an efficient state. It cleans up stale data, repacks objects,
	// updates auxiliary caches like commit-graphs and packs references. The
	// optimizations performed are based on heuristics and will adapt to the
	// repository's size. This RPC call is designed as a black-box such that
	// Gitaly has complete control of the on-disk state of repositories.
	OptimizeRepository(ctx context.Context, in *OptimizeRepositoryRequest, opts ...grpc.CallOption) (*OptimizeRepositoryResponse, error)
	// PruneUnreachableObjects will prune all objects which aren't reachable from
	// the repository's current set of references. Because pruning can only
	// happen for objects which aren't packed, you are required to first run
	// OptimizeRepository to explode any unreachable objects into loose objects.
	//
	// Furthermore, this RPC call has a grace period of 30 minutes: any
	// unreachable loose objects must not have been accessed or modified in the
	// last 30 minutes. This is a hard requirement to avoid repository corruption.
	//
	// to make proper use of this RPC you thus need to call OptimizeRepository,
	// wait 30 minutes, and then call PruneUnreachableObjects.
	PruneUnreachableObjects(ctx context.Context, in *PruneUnreachableObjectsRequest, opts ...grpc.CallOption) (*PruneUnreachableObjectsResponse, error)
	// Deprecated: Do not use.
	// SetFullPath writes the "gitlab.fullpath" configuration into the
	// repository's gitconfig. This is mainly to help debugging purposes in case
	// an admin inspects the repository's gitconfig such that he can easily see
	// what the repository name is.
	SetFullPath(ctx context.Context, in *SetFullPathRequest, opts ...grpc.CallOption) (*SetFullPathResponse, error)
	// Deprecated: Do not use.
	// FullPath reads the "gitlab.fullpath" configuration from the repository's
	// gitconfig. Returns an error in case the full path has not been configured.
	FullPath(ctx context.Context, in *FullPathRequest, opts ...grpc.CallOption) (*FullPathResponse, error)
	// RemoveAll deletes all repositories on a specified storage.
	RemoveAll(ctx context.Context, in *RemoveAllRequest, opts ...grpc.CallOption) (*RemoveAllResponse, error)
	// BackupRepository creates a full or incremental backup streamed directly to
	// object-storage. The backup is created synchronously. The destination must
	// be configured in config.backup.go_cloud_url
	BackupRepository(ctx context.Context, in *BackupRepositoryRequest, opts ...grpc.CallOption) (*BackupRepositoryResponse, error)
	// RestoreRepository restores a backup streamed directly from object-storage.
	// The repository is restored synchronously. The source object-storage must
	// be configured in config.backup.go_cloud_url
	RestoreRepository(ctx context.Context, in *RestoreRepositoryRequest, opts ...grpc.CallOption) (*RestoreRepositoryResponse, error)
	// GetFileAttributes queries given file attributes as specified in .gitattributes file
	GetFileAttributes(ctx context.Context, in *GetFileAttributesRequest, opts ...grpc.CallOption) (*GetFileAttributesResponse, error)
}

type repositoryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRepositoryServiceClient(cc grpc.ClientConnInterface) RepositoryServiceClient {
	return &repositoryServiceClient{cc}
}

func (c *repositoryServiceClient) RepositoryExists(ctx context.Context, in *RepositoryExistsRequest, opts ...grpc.CallOption) (*RepositoryExistsResponse, error) {
	out := new(RepositoryExistsResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RepositoryExists", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RepositorySize(ctx context.Context, in *RepositorySizeRequest, opts ...grpc.CallOption) (*RepositorySizeResponse, error) {
	out := new(RepositorySizeResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RepositorySize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RepositoryInfo(ctx context.Context, in *RepositoryInfoRequest, opts ...grpc.CallOption) (*RepositoryInfoResponse, error) {
	out := new(RepositoryInfoResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RepositoryInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) ObjectsSize(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_ObjectsSizeClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[0], "/gitaly.RepositoryService/ObjectsSize", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceObjectsSizeClient{stream}
	return x, nil
}

type RepositoryService_ObjectsSizeClient interface {
	Send(*ObjectsSizeRequest) error
	CloseAndRecv() (*ObjectsSizeResponse, error)
	grpc.ClientStream
}

type repositoryServiceObjectsSizeClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceObjectsSizeClient) Send(m *ObjectsSizeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *repositoryServiceObjectsSizeClient) CloseAndRecv() (*ObjectsSizeResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(ObjectsSizeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) ObjectFormat(ctx context.Context, in *ObjectFormatRequest, opts ...grpc.CallOption) (*ObjectFormatResponse, error) {
	out := new(ObjectFormatResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/ObjectFormat", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) ApplyGitattributes(ctx context.Context, in *ApplyGitattributesRequest, opts ...grpc.CallOption) (*ApplyGitattributesResponse, error) {
	out := new(ApplyGitattributesResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/ApplyGitattributes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FetchRemote(ctx context.Context, in *FetchRemoteRequest, opts ...grpc.CallOption) (*FetchRemoteResponse, error) {
	out := new(FetchRemoteResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/FetchRemote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*CreateRepositoryResponse, error) {
	out := new(CreateRepositoryResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/CreateRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetArchive(ctx context.Context, in *GetArchiveRequest, opts ...grpc.CallOption) (RepositoryService_GetArchiveClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[1], "/gitaly.RepositoryService/GetArchive", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceGetArchiveClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_GetArchiveClient interface {
	Recv() (*GetArchiveResponse, error)
	grpc.ClientStream
}

type repositoryServiceGetArchiveClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceGetArchiveClient) Recv() (*GetArchiveResponse, error) {
	m := new(GetArchiveResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) HasLocalBranches(ctx context.Context, in *HasLocalBranchesRequest, opts ...grpc.CallOption) (*HasLocalBranchesResponse, error) {
	out := new(HasLocalBranchesResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/HasLocalBranches", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FetchSourceBranch(ctx context.Context, in *FetchSourceBranchRequest, opts ...grpc.CallOption) (*FetchSourceBranchResponse, error) {
	out := new(FetchSourceBranchResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/FetchSourceBranch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) Fsck(ctx context.Context, in *FsckRequest, opts ...grpc.CallOption) (*FsckResponse, error) {
	out := new(FsckResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/Fsck", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) WriteRef(ctx context.Context, in *WriteRefRequest, opts ...grpc.CallOption) (*WriteRefResponse, error) {
	out := new(WriteRefResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/WriteRef", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FindMergeBase(ctx context.Context, in *FindMergeBaseRequest, opts ...grpc.CallOption) (*FindMergeBaseResponse, error) {
	out := new(FindMergeBaseResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/FindMergeBase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateFork(ctx context.Context, in *CreateForkRequest, opts ...grpc.CallOption) (*CreateForkResponse, error) {
	out := new(CreateForkResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/CreateFork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateRepositoryFromURL(ctx context.Context, in *CreateRepositoryFromURLRequest, opts ...grpc.CallOption) (*CreateRepositoryFromURLResponse, error) {
	out := new(CreateRepositoryFromURLResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/CreateRepositoryFromURL", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateBundle(ctx context.Context, in *CreateBundleRequest, opts ...grpc.CallOption) (RepositoryService_CreateBundleClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[2], "/gitaly.RepositoryService/CreateBundle", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceCreateBundleClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_CreateBundleClient interface {
	Recv() (*CreateBundleResponse, error)
	grpc.ClientStream
}

type repositoryServiceCreateBundleClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceCreateBundleClient) Recv() (*CreateBundleResponse, error) {
	m := new(CreateBundleResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) CreateBundleFromRefList(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_CreateBundleFromRefListClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[3], "/gitaly.RepositoryService/CreateBundleFromRefList", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceCreateBundleFromRefListClient{stream}
	return x, nil
}

type RepositoryService_CreateBundleFromRefListClient interface {
	Send(*CreateBundleFromRefListRequest) error
	Recv() (*CreateBundleFromRefListResponse, error)
	grpc.ClientStream
}

type repositoryServiceCreateBundleFromRefListClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceCreateBundleFromRefListClient) Send(m *CreateBundleFromRefListRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *repositoryServiceCreateBundleFromRefListClient) Recv() (*CreateBundleFromRefListResponse, error) {
	m := new(CreateBundleFromRefListResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) FetchBundle(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_FetchBundleClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[4], "/gitaly.RepositoryService/FetchBundle", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceFetchBundleClient{stream}
	return x, nil
}

type RepositoryService_FetchBundleClient interface {
	Send(*FetchBundleRequest) error
	CloseAndRecv() (*FetchBundleResponse, error)
	grpc.ClientStream
}

type repositoryServiceFetchBundleClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceFetchBundleClient) Send(m *FetchBundleRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *repositoryServiceFetchBundleClient) CloseAndRecv() (*FetchBundleResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(FetchBundleResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) CreateRepositoryFromBundle(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_CreateRepositoryFromBundleClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[5], "/gitaly.RepositoryService/CreateRepositoryFromBundle", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceCreateRepositoryFromBundleClient{stream}
	return x, nil
}

type RepositoryService_CreateRepositoryFromBundleClient interface {
	Send(*CreateRepositoryFromBundleRequest) error
	CloseAndRecv() (*CreateRepositoryFromBundleResponse, error)
	grpc.ClientStream
}

type repositoryServiceCreateRepositoryFromBundleClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceCreateRepositoryFromBundleClient) Send(m *CreateRepositoryFromBundleRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *repositoryServiceCreateRepositoryFromBundleClient) CloseAndRecv() (*CreateRepositoryFromBundleResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(CreateRepositoryFromBundleResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (RepositoryService_GetConfigClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[6], "/gitaly.RepositoryService/GetConfig", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceGetConfigClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_GetConfigClient interface {
	Recv() (*GetConfigResponse, error)
	grpc.ClientStream
}

type repositoryServiceGetConfigClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceGetConfigClient) Recv() (*GetConfigResponse, error) {
	m := new(GetConfigResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) FindLicense(ctx context.Context, in *FindLicenseRequest, opts ...grpc.CallOption) (*FindLicenseResponse, error) {
	out := new(FindLicenseResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/FindLicense", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) GetInfoAttributes(ctx context.Context, in *GetInfoAttributesRequest, opts ...grpc.CallOption) (RepositoryService_GetInfoAttributesClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[7], "/gitaly.RepositoryService/GetInfoAttributes", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceGetInfoAttributesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_GetInfoAttributesClient interface {
	Recv() (*GetInfoAttributesResponse, error)
	grpc.ClientStream
}

type repositoryServiceGetInfoAttributesClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceGetInfoAttributesClient) Recv() (*GetInfoAttributesResponse, error) {
	m := new(GetInfoAttributesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) CalculateChecksum(ctx context.Context, in *CalculateChecksumRequest, opts ...grpc.CallOption) (*CalculateChecksumResponse, error) {
	out := new(CalculateChecksumResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/CalculateChecksum", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (RepositoryService_GetSnapshotClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[8], "/gitaly.RepositoryService/GetSnapshot", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceGetSnapshotClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_GetSnapshotClient interface {
	Recv() (*GetSnapshotResponse, error)
	grpc.ClientStream
}

type repositoryServiceGetSnapshotClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceGetSnapshotClient) Recv() (*GetSnapshotResponse, error) {
	m := new(GetSnapshotResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) CreateRepositoryFromSnapshot(ctx context.Context, in *CreateRepositoryFromSnapshotRequest, opts ...grpc.CallOption) (*CreateRepositoryFromSnapshotResponse, error) {
	out := new(CreateRepositoryFromSnapshotResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/CreateRepositoryFromSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetRawChanges(ctx context.Context, in *GetRawChangesRequest, opts ...grpc.CallOption) (RepositoryService_GetRawChangesClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[9], "/gitaly.RepositoryService/GetRawChanges", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceGetRawChangesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_GetRawChangesClient interface {
	Recv() (*GetRawChangesResponse, error)
	grpc.ClientStream
}

type repositoryServiceGetRawChangesClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceGetRawChangesClient) Recv() (*GetRawChangesResponse, error) {
	m := new(GetRawChangesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) SearchFilesByContent(ctx context.Context, in *SearchFilesByContentRequest, opts ...grpc.CallOption) (RepositoryService_SearchFilesByContentClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[10], "/gitaly.RepositoryService/SearchFilesByContent", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceSearchFilesByContentClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_SearchFilesByContentClient interface {
	Recv() (*SearchFilesByContentResponse, error)
	grpc.ClientStream
}

type repositoryServiceSearchFilesByContentClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceSearchFilesByContentClient) Recv() (*SearchFilesByContentResponse, error) {
	m := new(SearchFilesByContentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) SearchFilesByName(ctx context.Context, in *SearchFilesByNameRequest, opts ...grpc.CallOption) (RepositoryService_SearchFilesByNameClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[11], "/gitaly.RepositoryService/SearchFilesByName", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceSearchFilesByNameClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_SearchFilesByNameClient interface {
	Recv() (*SearchFilesByNameResponse, error)
	grpc.ClientStream
}

type repositoryServiceSearchFilesByNameClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceSearchFilesByNameClient) Recv() (*SearchFilesByNameResponse, error) {
	m := new(SearchFilesByNameResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) RestoreCustomHooks(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_RestoreCustomHooksClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[12], "/gitaly.RepositoryService/RestoreCustomHooks", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceRestoreCustomHooksClient{stream}
	return x, nil
}

type RepositoryService_RestoreCustomHooksClient interface {
	Send(*RestoreCustomHooksRequest) error
	CloseAndRecv() (*RestoreCustomHooksResponse, error)
	grpc.ClientStream
}

type repositoryServiceRestoreCustomHooksClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceRestoreCustomHooksClient) Send(m *RestoreCustomHooksRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *repositoryServiceRestoreCustomHooksClient) CloseAndRecv() (*RestoreCustomHooksResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(RestoreCustomHooksResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) SetCustomHooks(ctx context.Context, opts ...grpc.CallOption) (RepositoryService_SetCustomHooksClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[13], "/gitaly.RepositoryService/SetCustomHooks", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceSetCustomHooksClient{stream}
	return x, nil
}

type RepositoryService_SetCustomHooksClient interface {
	Send(*SetCustomHooksRequest) error
	CloseAndRecv() (*SetCustomHooksResponse, error)
	grpc.ClientStream
}

type repositoryServiceSetCustomHooksClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceSetCustomHooksClient) Send(m *SetCustomHooksRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *repositoryServiceSetCustomHooksClient) CloseAndRecv() (*SetCustomHooksResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(SetCustomHooksResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) BackupCustomHooks(ctx context.Context, in *BackupCustomHooksRequest, opts ...grpc.CallOption) (RepositoryService_BackupCustomHooksClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[14], "/gitaly.RepositoryService/BackupCustomHooks", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceBackupCustomHooksClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_BackupCustomHooksClient interface {
	Recv() (*BackupCustomHooksResponse, error)
	grpc.ClientStream
}

type repositoryServiceBackupCustomHooksClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceBackupCustomHooksClient) Recv() (*BackupCustomHooksResponse, error) {
	m := new(BackupCustomHooksResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) GetCustomHooks(ctx context.Context, in *GetCustomHooksRequest, opts ...grpc.CallOption) (RepositoryService_GetCustomHooksClient, error) {
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[15], "/gitaly.RepositoryService/GetCustomHooks", opts...)
	if err != nil {
		return nil, err
	}
	x := &repositoryServiceGetCustomHooksClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RepositoryService_GetCustomHooksClient interface {
	Recv() (*GetCustomHooksResponse, error)
	grpc.ClientStream
}

type repositoryServiceGetCustomHooksClient struct {
	grpc.ClientStream
}

func (x *repositoryServiceGetCustomHooksClient) Recv() (*GetCustomHooksResponse, error) {
	m := new(GetCustomHooksResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *repositoryServiceClient) GetObjectDirectorySize(ctx context.Context, in *GetObjectDirectorySizeRequest, opts ...grpc.CallOption) (*GetObjectDirectorySizeResponse, error) {
	out := new(GetObjectDirectorySizeResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/GetObjectDirectorySize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RemoveRepository(ctx context.Context, in *RemoveRepositoryRequest, opts ...grpc.CallOption) (*RemoveRepositoryResponse, error) {
	out := new(RemoveRepositoryResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RemoveRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) ReplicateRepository(ctx context.Context, in *ReplicateRepositoryRequest, opts ...grpc.CallOption) (*ReplicateRepositoryResponse, error) {
	out := new(ReplicateRepositoryResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/ReplicateRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) OptimizeRepository(ctx context.Context, in *OptimizeRepositoryRequest, opts ...grpc.CallOption) (*OptimizeRepositoryResponse, error) {
	out := new(OptimizeRepositoryResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/OptimizeRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) PruneUnreachableObjects(ctx context.Context, in *PruneUnreachableObjectsRequest, opts ...grpc.CallOption) (*PruneUnreachableObjectsResponse, error) {
	out := new(PruneUnreachableObjectsResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/PruneUnreachableObjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) SetFullPath(ctx context.Context, in *SetFullPathRequest, opts ...grpc.CallOption) (*SetFullPathResponse, error) {
	out := new(SetFullPathResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/SetFullPath", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) FullPath(ctx context.Context, in *FullPathRequest, opts ...grpc.CallOption) (*FullPathResponse, error) {
	out := new(FullPathResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/FullPath", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RemoveAll(ctx context.Context, in *RemoveAllRequest, opts ...grpc.CallOption) (*RemoveAllResponse, error) {
	out := new(RemoveAllResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RemoveAll", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) BackupRepository(ctx context.Context, in *BackupRepositoryRequest, opts ...grpc.CallOption) (*BackupRepositoryResponse, error) {
	out := new(BackupRepositoryResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/BackupRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RestoreRepository(ctx context.Context, in *RestoreRepositoryRequest, opts ...grpc.CallOption) (*RestoreRepositoryResponse, error) {
	out := new(RestoreRepositoryResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/RestoreRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetFileAttributes(ctx context.Context, in *GetFileAttributesRequest, opts ...grpc.CallOption) (*GetFileAttributesResponse, error) {
	out := new(GetFileAttributesResponse)
	err := c.cc.Invoke(ctx, "/gitaly.RepositoryService/GetFileAttributes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RepositoryServiceServer is the server API for RepositoryService service.
// All implementations must embed UnimplementedRepositoryServiceServer
// for forward compatibility
type RepositoryServiceServer interface {
	// RepositoryExists returns whether a given repository exists.
	RepositoryExists(context.Context, *RepositoryExistsRequest) (*RepositoryExistsResponse, error)
	// RepositorySize returns information on the complete on-disk repository size. If you need more
	// detailed information about the size of various sub-structures you should instead use the
	// repositoryInfo RPC.
	RepositorySize(context.Context, *RepositorySizeRequest) (*RepositorySizeResponse, error)
	// RepositoryInfo returns detailed information about a repository and its data structures.
	RepositoryInfo(context.Context, *RepositoryInfoRequest) (*RepositoryInfoResponse, error)
	// ObjectsSize calculates the total on-disk object size of reachable objects in bytes. In contrast
	// to RepositorySize and RepositoryInfo, this RPC performs a graph walk of the specified revisions
	// and will thus return an accurate view of how large the accumulated on-disk size of reachable
	// objects is.
	//
	// As this RPC needs to perform a revision walk, it is significantly more expensive than the RPCs
	// which simply check the size of on-disk data structures. On the other hand, it allows the caller
	// to accurately compute the size of objects in a way that is at least somewhat detached from the
	// on-disk representation:
	//
	//   - Objects which exist in multiple packfiles will not be double-counted.
	//   - Objects which aren't reachable will not be accounted for.
	//   - It is possible to only account for a subset of references, e.g. only those that an admin
	//     would have direct control over.
	//
	// It is thus recommended to use this RPC whenever you want to calculate sizes which will end up
	// being shown to the user.
	//
	// Note that the size is still bound to change when repositories are getting repacked and thus
	// cannot be considered to be stable. This is because the on-disk size of any object can change
	// depending on how Git decides to deltify it in a packfile. Thus, when a repack would cause a
	// different delta base to be picked, the actual on-disk size of any given object may change.
	ObjectsSize(RepositoryService_ObjectsSizeServer) error
	// ObjectFormat determines the object format that is being used by the repository.
	ObjectFormat(context.Context, *ObjectFormatRequest) (*ObjectFormatResponse, error)
	// Deprecated: Do not use.
	// ApplyGitattributes writes the attributes from the given revision to info/attributes.
	// This RPC will be removed in 17.0.
	ApplyGitattributes(context.Context, *ApplyGitattributesRequest) (*ApplyGitattributesResponse, error)
	// FetchRemote fetches references from a remote repository into the local
	// repository. The remote can be fetched via HTTP or SSH depending on the
	// request options provided.
	FetchRemote(context.Context, *FetchRemoteRequest) (*FetchRemoteResponse, error)
	// CreateRepository creates a new empty repository.
	CreateRepository(context.Context, *CreateRepositoryRequest) (*CreateRepositoryResponse, error)
	// GetArchive produces and returns an archive of a repository.
	GetArchive(*GetArchiveRequest, RepositoryService_GetArchiveServer) error
	// HasLocalBranches returns whether the given repo contains any branches.
	HasLocalBranches(context.Context, *HasLocalBranchesRequest) (*HasLocalBranchesResponse, error)
	// FetchSourceBranch fetches a branch from a second (potentially remote)
	// repository into the given repository.
	FetchSourceBranch(context.Context, *FetchSourceBranchRequest) (*FetchSourceBranchResponse, error)
	// Fsck checks the repository for consistency via git-fsck(1). This can be used to check for
	// repository corruption.
	Fsck(context.Context, *FsckRequest) (*FsckResponse, error)
	// WriteRef creates or updates a ref in a repository to point to a new value.
	WriteRef(context.Context, *WriteRefRequest) (*WriteRefResponse, error)
	// FindMergeBase returns the best common ancestor between two or more commits. Consult the man
	// pages of git-merge-base(1) for more information on how this is calculated.
	FindMergeBase(context.Context, *FindMergeBaseRequest) (*FindMergeBaseResponse, error)
	// CreateFork creates a new repository from a specific source repository. This new repository will
	// have the same branches and tags as the source repository. Internal references will not be
	// recreated in the forked repository.
	//
	// all objects of the source repository will be duplicated, that is there are no space savings by
	// creating the repository like this. The newly created repository does not join the object pool
	// of the source repository, if there is any.
	CreateFork(context.Context, *CreateForkRequest) (*CreateForkResponse, error)
	// CreateRepositoryFromURL creates a new repo and seeds it with the contents of an existing Git repo
	// reachable at the provided URL.
	CreateRepositoryFromURL(context.Context, *CreateRepositoryFromURLRequest) (*CreateRepositoryFromURLResponse, error)
	// CreateBundle creates a bundle from all refs
	CreateBundle(*CreateBundleRequest, RepositoryService_CreateBundleServer) error
	// CreateBundleFromRefList creates a bundle from a stream of ref patterns.
	// When the bundle would be empty the FailedPrecondition error code is returned.
	CreateBundleFromRefList(RepositoryService_CreateBundleFromRefListServer) error
	// FetchBundle fetches references from a bundle into the local repository.
	// refs will be mirrored to the target repository with the refspec
	// "+refs/*:refs/*" and refs that do not exist in the bundle will be removed.
	FetchBundle(RepositoryService_FetchBundleServer) error
	// CreateRepositoryFromBundle creates a Git repository at the specified storage and path, if it
	// does not already exist, from the provided Git bundle.
	CreateRepositoryFromBundle(RepositoryService_CreateRepositoryFromBundleServer) error
	// GetConfig reads the target repository's gitconfig and streams its contents
	// back. Returns a NotFound error in case no gitconfig was found.
	GetConfig(*GetConfigRequest, RepositoryService_GetConfigServer) error
	// FindLicense looks in the given repository and attempts to detect all the
	// details about the license used in the repository.
	FindLicense(context.Context, *FindLicenseRequest) (*FindLicenseResponse, error)
	// Deprecated: Do not use.
	// GetInfoAttributes reads the contents from info/attributes.
	// This RPC will be removed in 17.0.
	GetInfoAttributes(*GetInfoAttributesRequest, RepositoryService_GetInfoAttributesServer) error
	// CalculateChecksum returns a checksum of the repository by hashing its references. Refs
	// outside of well-known namespaces are not considered when computing the checksum.
	CalculateChecksum(context.Context, *CalculateChecksumRequest) (*CalculateChecksumResponse, error)
	// GetSnapshot returns a snapshot of the repository. A snapshot comprises all Git references
	// and objects required to recreate the state of a repository at a point in time.
	GetSnapshot(*GetSnapshotRequest, RepositoryService_GetSnapshotServer) error
	// CreateRepositoryFromSnapshot creates a new repository based on a snapshot created with
	// the GetSnapshot RPC. The snapshot is fetched via HTTP.
	CreateRepositoryFromSnapshot(context.Context, *CreateRepositoryFromSnapshotRequest) (*CreateRepositoryFromSnapshotResponse, error)
	// GetRawChanges returns metadata in raw format on the changes between two revisions.
	GetRawChanges(*GetRawChangesRequest, RepositoryService_GetRawChangesServer) error
	// SearchFilesByContent searches files in the repository using the provided grep pattern.
	// For each result, the matched line is returned along with the two previous and next lines.
	SearchFilesByContent(*SearchFilesByContentRequest, RepositoryService_SearchFilesByContentServer) error
	// SearchFilesByName searches files in the repository based on its name and an
	// optional filter.
	SearchFilesByName(*SearchFilesByNameRequest, RepositoryService_SearchFilesByNameServer) error
	// Deprecated: Do not use.
	// RestoreCustomHooks sets the git hooks for a repository. The hooks are sent
	// in a tar archive containing a `custom_hooks` directory. This directory is
	// ultimately extracted to the repository.
	RestoreCustomHooks(RepositoryService_RestoreCustomHooksServer) error
	// SetCustomHooks sets the git hooks for a repository. The hooks are sent in a
	// tar archive containing a `custom_hooks` directory (i.e. the response from the
	// GetCustomHooksResponse RPC. This directory will be extracted into the repository.
	SetCustomHooks(RepositoryService_SetCustomHooksServer) error
	// Deprecated: Do not use.
	// BackupCustomHooks fetches the git hooks for a repository. The hooks are
	// sent in a tar archive containing a `custom_hooks` directory. If no hooks
	// are present in the repository, the response will have no data.
	BackupCustomHooks(*BackupCustomHooksRequest, RepositoryService_BackupCustomHooksServer) error
	// GetCustomHooks fetches the git hooks for a repository. The hooks are sent
	// in a tar archive containing a `custom_hooks` directory. If no hooks are
	// present in the repository, the response will have no data.
	GetCustomHooks(*GetCustomHooksRequest, RepositoryService_GetCustomHooksServer) error
	// GetObjectDirectorySize returns the size in kibibytes of the object directory of a repository.
	GetObjectDirectorySize(context.Context, *GetObjectDirectorySizeRequest) (*GetObjectDirectorySizeResponse, error)
	// RemoveRepository will move the repository to `+gitaly/tmp/<relative_path>_removed` and
	// eventually remove it. This ensures that even on networked filesystems the
	// data is actually removed even if there's someone still handling the data.
	RemoveRepository(context.Context, *RemoveRepositoryRequest) (*RemoveRepositoryResponse, error)
	// ReplicateRepository replicates data from a source repository to target repository. On the
	// target repository, this operation ensures synchronization of the following components:
	//
	// - Git config
	// - Git attributes
	// - Custom Git hooks,
	// - References and objects
	// - (Optional) Object deduplication network membership
	ReplicateRepository(context.Context, *ReplicateRepositoryRequest) (*ReplicateRepositoryResponse, error)
	// OptimizeRepository performs all maintenance tasks in a repository to keep
	// it in an efficient state. It cleans up stale data, repacks objects,
	// updates auxiliary caches like commit-graphs and packs references. The
	// optimizations performed are based on heuristics and will adapt to the
	// repository's size. This RPC call is designed as a black-box such that
	// Gitaly has complete control of the on-disk state of repositories.
	OptimizeRepository(context.Context, *OptimizeRepositoryRequest) (*OptimizeRepositoryResponse, error)
	// PruneUnreachableObjects will prune all objects which aren't reachable from
	// the repository's current set of references. Because pruning can only
	// happen for objects which aren't packed, you are required to first run
	// OptimizeRepository to explode any unreachable objects into loose objects.
	//
	// Furthermore, this RPC call has a grace period of 30 minutes: any
	// unreachable loose objects must not have been accessed or modified in the
	// last 30 minutes. This is a hard requirement to avoid repository corruption.
	//
	// to make proper use of this RPC you thus need to call OptimizeRepository,
	// wait 30 minutes, and then call PruneUnreachableObjects.
	PruneUnreachableObjects(context.Context, *PruneUnreachableObjectsRequest) (*PruneUnreachableObjectsResponse, error)
	// Deprecated: Do not use.
	// SetFullPath writes the "gitlab.fullpath" configuration into the
	// repository's gitconfig. This is mainly to help debugging purposes in case
	// an admin inspects the repository's gitconfig such that he can easily see
	// what the repository name is.
	SetFullPath(context.Context, *SetFullPathRequest) (*SetFullPathResponse, error)
	// Deprecated: Do not use.
	// FullPath reads the "gitlab.fullpath" configuration from the repository's
	// gitconfig. Returns an error in case the full path has not been configured.
	FullPath(context.Context, *FullPathRequest) (*FullPathResponse, error)
	// RemoveAll deletes all repositories on a specified storage.
	RemoveAll(context.Context, *RemoveAllRequest) (*RemoveAllResponse, error)
	// BackupRepository creates a full or incremental backup streamed directly to
	// object-storage. The backup is created synchronously. The destination must
	// be configured in config.backup.go_cloud_url
	BackupRepository(context.Context, *BackupRepositoryRequest) (*BackupRepositoryResponse, error)
	// RestoreRepository restores a backup streamed directly from object-storage.
	// The repository is restored synchronously. The source object-storage must
	// be configured in config.backup.go_cloud_url
	RestoreRepository(context.Context, *RestoreRepositoryRequest) (*RestoreRepositoryResponse, error)
	// GetFileAttributes queries given file attributes as specified in .gitattributes file
	GetFileAttributes(context.Context, *GetFileAttributesRequest) (*GetFileAttributesResponse, error)
	mustEmbedUnimplementedRepositoryServiceServer()
}

// UnimplementedRepositoryServiceServer must be embedded to have forward compatible implementations.
type UnimplementedRepositoryServiceServer struct {
}

func (UnimplementedRepositoryServiceServer) RepositoryExists(context.Context, *RepositoryExistsRequest) (*RepositoryExistsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepositoryExists not implemented")
}
func (UnimplementedRepositoryServiceServer) RepositorySize(context.Context, *RepositorySizeRequest) (*RepositorySizeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepositorySize not implemented")
}
func (UnimplementedRepositoryServiceServer) RepositoryInfo(context.Context, *RepositoryInfoRequest) (*RepositoryInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepositoryInfo not implemented")
}
func (UnimplementedRepositoryServiceServer) ObjectsSize(RepositoryService_ObjectsSizeServer) error {
	return status.Errorf(codes.Unimplemented, "method ObjectsSize not implemented")
}
func (UnimplementedRepositoryServiceServer) ObjectFormat(context.Context, *ObjectFormatRequest) (*ObjectFormatResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ObjectFormat not implemented")
}
func (UnimplementedRepositoryServiceServer) ApplyGitattributes(context.Context, *ApplyGitattributesRequest) (*ApplyGitattributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyGitattributes not implemented")
}
func (UnimplementedRepositoryServiceServer) FetchRemote(context.Context, *FetchRemoteRequest) (*FetchRemoteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchRemote not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepository(context.Context, *CreateRepositoryRequest) (*CreateRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) GetArchive(*GetArchiveRequest, RepositoryService_GetArchiveServer) error {
	return status.Errorf(codes.Unimplemented, "method GetArchive not implemented")
}
func (UnimplementedRepositoryServiceServer) HasLocalBranches(context.Context, *HasLocalBranchesRequest) (*HasLocalBranchesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HasLocalBranches not implemented")
}
func (UnimplementedRepositoryServiceServer) FetchSourceBranch(context.Context, *FetchSourceBranchRequest) (*FetchSourceBranchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchSourceBranch not implemented")
}
func (UnimplementedRepositoryServiceServer) Fsck(context.Context, *FsckRequest) (*FsckResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Fsck not implemented")
}
func (UnimplementedRepositoryServiceServer) WriteRef(context.Context, *WriteRefRequest) (*WriteRefResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteRef not implemented")
}
func (UnimplementedRepositoryServiceServer) FindMergeBase(context.Context, *FindMergeBaseRequest) (*FindMergeBaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindMergeBase not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateFork(context.Context, *CreateForkRequest) (*CreateForkResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFork not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepositoryFromURL(context.Context, *CreateRepositoryFromURLRequest) (*CreateRepositoryFromURLResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepositoryFromURL not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateBundle(*CreateBundleRequest, RepositoryService_CreateBundleServer) error {
	return status.Errorf(codes.Unimplemented, "method CreateBundle not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateBundleFromRefList(RepositoryService_CreateBundleFromRefListServer) error {
	return status.Errorf(codes.Unimplemented, "method CreateBundleFromRefList not implemented")
}
func (UnimplementedRepositoryServiceServer) FetchBundle(RepositoryService_FetchBundleServer) error {
	return status.Errorf(codes.Unimplemented, "method FetchBundle not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepositoryFromBundle(RepositoryService_CreateRepositoryFromBundleServer) error {
	return status.Errorf(codes.Unimplemented, "method CreateRepositoryFromBundle not implemented")
}
func (UnimplementedRepositoryServiceServer) GetConfig(*GetConfigRequest, RepositoryService_GetConfigServer) error {
	return status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}
func (UnimplementedRepositoryServiceServer) FindLicense(context.Context, *FindLicenseRequest) (*FindLicenseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindLicense not implemented")
}
func (UnimplementedRepositoryServiceServer) GetInfoAttributes(*GetInfoAttributesRequest, RepositoryService_GetInfoAttributesServer) error {
	return status.Errorf(codes.Unimplemented, "method GetInfoAttributes not implemented")
}
func (UnimplementedRepositoryServiceServer) CalculateChecksum(context.Context, *CalculateChecksumRequest) (*CalculateChecksumResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateChecksum not implemented")
}
func (UnimplementedRepositoryServiceServer) GetSnapshot(*GetSnapshotRequest, RepositoryService_GetSnapshotServer) error {
	return status.Errorf(codes.Unimplemented, "method GetSnapshot not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepositoryFromSnapshot(context.Context, *CreateRepositoryFromSnapshotRequest) (*CreateRepositoryFromSnapshotResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepositoryFromSnapshot not implemented")
}
func (UnimplementedRepositoryServiceServer) GetRawChanges(*GetRawChangesRequest, RepositoryService_GetRawChangesServer) error {
	return status.Errorf(codes.Unimplemented, "method GetRawChanges not implemented")
}
func (UnimplementedRepositoryServiceServer) SearchFilesByContent(*SearchFilesByContentRequest, RepositoryService_SearchFilesByContentServer) error {
	return status.Errorf(codes.Unimplemented, "method SearchFilesByContent not implemented")
}
func (UnimplementedRepositoryServiceServer) SearchFilesByName(*SearchFilesByNameRequest, RepositoryService_SearchFilesByNameServer) error {
	return status.Errorf(codes.Unimplemented, "method SearchFilesByName not implemented")
}
func (UnimplementedRepositoryServiceServer) RestoreCustomHooks(RepositoryService_RestoreCustomHooksServer) error {
	return status.Errorf(codes.Unimplemented, "method RestoreCustomHooks not implemented")
}
func (UnimplementedRepositoryServiceServer) SetCustomHooks(RepositoryService_SetCustomHooksServer) error {
	return status.Errorf(codes.Unimplemented, "method SetCustomHooks not implemented")
}
func (UnimplementedRepositoryServiceServer) BackupCustomHooks(*BackupCustomHooksRequest, RepositoryService_BackupCustomHooksServer) error {
	return status.Errorf(codes.Unimplemented, "method BackupCustomHooks not implemented")
}
func (UnimplementedRepositoryServiceServer) GetCustomHooks(*GetCustomHooksRequest, RepositoryService_GetCustomHooksServer) error {
	return status.Errorf(codes.Unimplemented, "method GetCustomHooks not implemented")
}
func (UnimplementedRepositoryServiceServer) GetObjectDirectorySize(context.Context, *GetObjectDirectorySizeRequest) (*GetObjectDirectorySizeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetObjectDirectorySize not implemented")
}
func (UnimplementedRepositoryServiceServer) RemoveRepository(context.Context, *RemoveRepositoryRequest) (*RemoveRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) ReplicateRepository(context.Context, *ReplicateRepositoryRequest) (*ReplicateRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplicateRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) OptimizeRepository(context.Context, *OptimizeRepositoryRequest) (*OptimizeRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OptimizeRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) PruneUnreachableObjects(context.Context, *PruneUnreachableObjectsRequest) (*PruneUnreachableObjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PruneUnreachableObjects not implemented")
}
func (UnimplementedRepositoryServiceServer) SetFullPath(context.Context, *SetFullPathRequest) (*SetFullPathResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetFullPath not implemented")
}
func (UnimplementedRepositoryServiceServer) FullPath(context.Context, *FullPathRequest) (*FullPathResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FullPath not implemented")
}
func (UnimplementedRepositoryServiceServer) RemoveAll(context.Context, *RemoveAllRequest) (*RemoveAllResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveAll not implemented")
}
func (UnimplementedRepositoryServiceServer) BackupRepository(context.Context, *BackupRepositoryRequest) (*BackupRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BackupRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) RestoreRepository(context.Context, *RestoreRepositoryRequest) (*RestoreRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) GetFileAttributes(context.Context, *GetFileAttributesRequest) (*GetFileAttributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFileAttributes not implemented")
}
func (UnimplementedRepositoryServiceServer) mustEmbedUnimplementedRepositoryServiceServer() {}

// UnsafeRepositoryServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RepositoryServiceServer will
// result in compilation errors.
type UnsafeRepositoryServiceServer interface {
	mustEmbedUnimplementedRepositoryServiceServer()
}

func RegisterRepositoryServiceServer(s grpc.ServiceRegistrar, srv RepositoryServiceServer) {
	s.RegisterService(&RepositoryService_ServiceDesc, srv)
}

func _RepositoryService_RepositoryExists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepositoryExistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RepositoryExists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RepositoryExists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RepositoryExists(ctx, req.(*RepositoryExistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RepositorySize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepositorySizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RepositorySize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RepositorySize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RepositorySize(ctx, req.(*RepositorySizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RepositoryInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepositoryInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RepositoryInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RepositoryInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RepositoryInfo(ctx, req.(*RepositoryInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_ObjectsSize_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).ObjectsSize(&repositoryServiceObjectsSizeServer{stream})
}

type RepositoryService_ObjectsSizeServer interface {
	SendAndClose(*ObjectsSizeResponse) error
	Recv() (*ObjectsSizeRequest, error)
	grpc.ServerStream
}

type repositoryServiceObjectsSizeServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceObjectsSizeServer) SendAndClose(m *ObjectsSizeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *repositoryServiceObjectsSizeServer) Recv() (*ObjectsSizeRequest, error) {
	m := new(ObjectsSizeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _RepositoryService_ObjectFormat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ObjectFormatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).ObjectFormat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/ObjectFormat",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).ObjectFormat(ctx, req.(*ObjectFormatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_ApplyGitattributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyGitattributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).ApplyGitattributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/ApplyGitattributes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).ApplyGitattributes(ctx, req.(*ApplyGitattributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FetchRemote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchRemoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FetchRemote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/FetchRemote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FetchRemote(ctx, req.(*FetchRemoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/CreateRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateRepository(ctx, req.(*CreateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetArchive_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetArchiveRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetArchive(m, &repositoryServiceGetArchiveServer{stream})
}

type RepositoryService_GetArchiveServer interface {
	Send(*GetArchiveResponse) error
	grpc.ServerStream
}

type repositoryServiceGetArchiveServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceGetArchiveServer) Send(m *GetArchiveResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_HasLocalBranches_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HasLocalBranchesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).HasLocalBranches(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/HasLocalBranches",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).HasLocalBranches(ctx, req.(*HasLocalBranchesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FetchSourceBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchSourceBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FetchSourceBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/FetchSourceBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FetchSourceBranch(ctx, req.(*FetchSourceBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_Fsck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FsckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).Fsck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/Fsck",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).Fsck(ctx, req.(*FsckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_WriteRef_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteRefRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).WriteRef(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/WriteRef",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).WriteRef(ctx, req.(*WriteRefRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FindMergeBase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindMergeBaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FindMergeBase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/FindMergeBase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FindMergeBase(ctx, req.(*FindMergeBaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateFork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateForkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateFork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/CreateFork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateFork(ctx, req.(*CreateForkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateRepositoryFromURL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryFromURLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateRepositoryFromURL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/CreateRepositoryFromURL",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateRepositoryFromURL(ctx, req.(*CreateRepositoryFromURLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateBundle_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CreateBundleRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).CreateBundle(m, &repositoryServiceCreateBundleServer{stream})
}

type RepositoryService_CreateBundleServer interface {
	Send(*CreateBundleResponse) error
	grpc.ServerStream
}

type repositoryServiceCreateBundleServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceCreateBundleServer) Send(m *CreateBundleResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_CreateBundleFromRefList_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).CreateBundleFromRefList(&repositoryServiceCreateBundleFromRefListServer{stream})
}

type RepositoryService_CreateBundleFromRefListServer interface {
	Send(*CreateBundleFromRefListResponse) error
	Recv() (*CreateBundleFromRefListRequest, error)
	grpc.ServerStream
}

type repositoryServiceCreateBundleFromRefListServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceCreateBundleFromRefListServer) Send(m *CreateBundleFromRefListResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *repositoryServiceCreateBundleFromRefListServer) Recv() (*CreateBundleFromRefListRequest, error) {
	m := new(CreateBundleFromRefListRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _RepositoryService_FetchBundle_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).FetchBundle(&repositoryServiceFetchBundleServer{stream})
}

type RepositoryService_FetchBundleServer interface {
	SendAndClose(*FetchBundleResponse) error
	Recv() (*FetchBundleRequest, error)
	grpc.ServerStream
}

type repositoryServiceFetchBundleServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceFetchBundleServer) SendAndClose(m *FetchBundleResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *repositoryServiceFetchBundleServer) Recv() (*FetchBundleRequest, error) {
	m := new(FetchBundleRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _RepositoryService_CreateRepositoryFromBundle_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).CreateRepositoryFromBundle(&repositoryServiceCreateRepositoryFromBundleServer{stream})
}

type RepositoryService_CreateRepositoryFromBundleServer interface {
	SendAndClose(*CreateRepositoryFromBundleResponse) error
	Recv() (*CreateRepositoryFromBundleRequest, error)
	grpc.ServerStream
}

type repositoryServiceCreateRepositoryFromBundleServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceCreateRepositoryFromBundleServer) SendAndClose(m *CreateRepositoryFromBundleResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *repositoryServiceCreateRepositoryFromBundleServer) Recv() (*CreateRepositoryFromBundleRequest, error) {
	m := new(CreateRepositoryFromBundleRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _RepositoryService_GetConfig_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetConfigRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetConfig(m, &repositoryServiceGetConfigServer{stream})
}

type RepositoryService_GetConfigServer interface {
	Send(*GetConfigResponse) error
	grpc.ServerStream
}

type repositoryServiceGetConfigServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceGetConfigServer) Send(m *GetConfigResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_FindLicense_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FindLicense(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/FindLicense",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FindLicense(ctx, req.(*FindLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetInfoAttributes_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetInfoAttributesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetInfoAttributes(m, &repositoryServiceGetInfoAttributesServer{stream})
}

type RepositoryService_GetInfoAttributesServer interface {
	Send(*GetInfoAttributesResponse) error
	grpc.ServerStream
}

type repositoryServiceGetInfoAttributesServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceGetInfoAttributesServer) Send(m *GetInfoAttributesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_CalculateChecksum_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateChecksumRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CalculateChecksum(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/CalculateChecksum",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CalculateChecksum(ctx, req.(*CalculateChecksumRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetSnapshot_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetSnapshotRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetSnapshot(m, &repositoryServiceGetSnapshotServer{stream})
}

type RepositoryService_GetSnapshotServer interface {
	Send(*GetSnapshotResponse) error
	grpc.ServerStream
}

type repositoryServiceGetSnapshotServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceGetSnapshotServer) Send(m *GetSnapshotResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_CreateRepositoryFromSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryFromSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateRepositoryFromSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/CreateRepositoryFromSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateRepositoryFromSnapshot(ctx, req.(*CreateRepositoryFromSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetRawChanges_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetRawChangesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetRawChanges(m, &repositoryServiceGetRawChangesServer{stream})
}

type RepositoryService_GetRawChangesServer interface {
	Send(*GetRawChangesResponse) error
	grpc.ServerStream
}

type repositoryServiceGetRawChangesServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceGetRawChangesServer) Send(m *GetRawChangesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_SearchFilesByContent_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SearchFilesByContentRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).SearchFilesByContent(m, &repositoryServiceSearchFilesByContentServer{stream})
}

type RepositoryService_SearchFilesByContentServer interface {
	Send(*SearchFilesByContentResponse) error
	grpc.ServerStream
}

type repositoryServiceSearchFilesByContentServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceSearchFilesByContentServer) Send(m *SearchFilesByContentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_SearchFilesByName_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SearchFilesByNameRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).SearchFilesByName(m, &repositoryServiceSearchFilesByNameServer{stream})
}

type RepositoryService_SearchFilesByNameServer interface {
	Send(*SearchFilesByNameResponse) error
	grpc.ServerStream
}

type repositoryServiceSearchFilesByNameServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceSearchFilesByNameServer) Send(m *SearchFilesByNameResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_RestoreCustomHooks_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).RestoreCustomHooks(&repositoryServiceRestoreCustomHooksServer{stream})
}

type RepositoryService_RestoreCustomHooksServer interface {
	SendAndClose(*RestoreCustomHooksResponse) error
	Recv() (*RestoreCustomHooksRequest, error)
	grpc.ServerStream
}

type repositoryServiceRestoreCustomHooksServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceRestoreCustomHooksServer) SendAndClose(m *RestoreCustomHooksResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *repositoryServiceRestoreCustomHooksServer) Recv() (*RestoreCustomHooksRequest, error) {
	m := new(RestoreCustomHooksRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _RepositoryService_SetCustomHooks_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).SetCustomHooks(&repositoryServiceSetCustomHooksServer{stream})
}

type RepositoryService_SetCustomHooksServer interface {
	SendAndClose(*SetCustomHooksResponse) error
	Recv() (*SetCustomHooksRequest, error)
	grpc.ServerStream
}

type repositoryServiceSetCustomHooksServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceSetCustomHooksServer) SendAndClose(m *SetCustomHooksResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *repositoryServiceSetCustomHooksServer) Recv() (*SetCustomHooksRequest, error) {
	m := new(SetCustomHooksRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _RepositoryService_BackupCustomHooks_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BackupCustomHooksRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).BackupCustomHooks(m, &repositoryServiceBackupCustomHooksServer{stream})
}

type RepositoryService_BackupCustomHooksServer interface {
	Send(*BackupCustomHooksResponse) error
	grpc.ServerStream
}

type repositoryServiceBackupCustomHooksServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceBackupCustomHooksServer) Send(m *BackupCustomHooksResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_GetCustomHooks_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetCustomHooksRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetCustomHooks(m, &repositoryServiceGetCustomHooksServer{stream})
}

type RepositoryService_GetCustomHooksServer interface {
	Send(*GetCustomHooksResponse) error
	grpc.ServerStream
}

type repositoryServiceGetCustomHooksServer struct {
	grpc.ServerStream
}

func (x *repositoryServiceGetCustomHooksServer) Send(m *GetCustomHooksResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RepositoryService_GetObjectDirectorySize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetObjectDirectorySizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).GetObjectDirectorySize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/GetObjectDirectorySize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).GetObjectDirectorySize(ctx, req.(*GetObjectDirectorySizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RemoveRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RemoveRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RemoveRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RemoveRepository(ctx, req.(*RemoveRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_ReplicateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).ReplicateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/ReplicateRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).ReplicateRepository(ctx, req.(*ReplicateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_OptimizeRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OptimizeRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).OptimizeRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/OptimizeRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).OptimizeRepository(ctx, req.(*OptimizeRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_PruneUnreachableObjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PruneUnreachableObjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).PruneUnreachableObjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/PruneUnreachableObjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).PruneUnreachableObjects(ctx, req.(*PruneUnreachableObjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_SetFullPath_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFullPathRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).SetFullPath(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/SetFullPath",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).SetFullPath(ctx, req.(*SetFullPathRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FullPath_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FullPathRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FullPath(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/FullPath",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FullPath(ctx, req.(*FullPathRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RemoveAll_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveAllRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RemoveAll(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RemoveAll",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RemoveAll(ctx, req.(*RemoveAllRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_BackupRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BackupRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).BackupRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/BackupRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).BackupRepository(ctx, req.(*BackupRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RestoreRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RestoreRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/RestoreRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RestoreRepository(ctx, req.(*RestoreRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetFileAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFileAttributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).GetFileAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RepositoryService/GetFileAttributes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).GetFileAttributes(ctx, req.(*GetFileAttributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RepositoryService_ServiceDesc is the grpc.ServiceDesc for RepositoryService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RepositoryService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.RepositoryService",
	HandlerType: (*RepositoryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RepositoryExists",
			Handler:    _RepositoryService_RepositoryExists_Handler,
		},
		{
			MethodName: "RepositorySize",
			Handler:    _RepositoryService_RepositorySize_Handler,
		},
		{
			MethodName: "RepositoryInfo",
			Handler:    _RepositoryService_RepositoryInfo_Handler,
		},
		{
			MethodName: "ObjectFormat",
			Handler:    _RepositoryService_ObjectFormat_Handler,
		},
		{
			MethodName: "ApplyGitattributes",
			Handler:    _RepositoryService_ApplyGitattributes_Handler,
		},
		{
			MethodName: "FetchRemote",
			Handler:    _RepositoryService_FetchRemote_Handler,
		},
		{
			MethodName: "CreateRepository",
			Handler:    _RepositoryService_CreateRepository_Handler,
		},
		{
			MethodName: "HasLocalBranches",
			Handler:    _RepositoryService_HasLocalBranches_Handler,
		},
		{
			MethodName: "FetchSourceBranch",
			Handler:    _RepositoryService_FetchSourceBranch_Handler,
		},
		{
			MethodName: "Fsck",
			Handler:    _RepositoryService_Fsck_Handler,
		},
		{
			MethodName: "WriteRef",
			Handler:    _RepositoryService_WriteRef_Handler,
		},
		{
			MethodName: "FindMergeBase",
			Handler:    _RepositoryService_FindMergeBase_Handler,
		},
		{
			MethodName: "CreateFork",
			Handler:    _RepositoryService_CreateFork_Handler,
		},
		{
			MethodName: "CreateRepositoryFromURL",
			Handler:    _RepositoryService_CreateRepositoryFromURL_Handler,
		},
		{
			MethodName: "FindLicense",
			Handler:    _RepositoryService_FindLicense_Handler,
		},
		{
			MethodName: "CalculateChecksum",
			Handler:    _RepositoryService_CalculateChecksum_Handler,
		},
		{
			MethodName: "CreateRepositoryFromSnapshot",
			Handler:    _RepositoryService_CreateRepositoryFromSnapshot_Handler,
		},
		{
			MethodName: "GetObjectDirectorySize",
			Handler:    _RepositoryService_GetObjectDirectorySize_Handler,
		},
		{
			MethodName: "RemoveRepository",
			Handler:    _RepositoryService_RemoveRepository_Handler,
		},
		{
			MethodName: "ReplicateRepository",
			Handler:    _RepositoryService_ReplicateRepository_Handler,
		},
		{
			MethodName: "OptimizeRepository",
			Handler:    _RepositoryService_OptimizeRepository_Handler,
		},
		{
			MethodName: "PruneUnreachableObjects",
			Handler:    _RepositoryService_PruneUnreachableObjects_Handler,
		},
		{
			MethodName: "SetFullPath",
			Handler:    _RepositoryService_SetFullPath_Handler,
		},
		{
			MethodName: "FullPath",
			Handler:    _RepositoryService_FullPath_Handler,
		},
		{
			MethodName: "RemoveAll",
			Handler:    _RepositoryService_RemoveAll_Handler,
		},
		{
			MethodName: "BackupRepository",
			Handler:    _RepositoryService_BackupRepository_Handler,
		},
		{
			MethodName: "RestoreRepository",
			Handler:    _RepositoryService_RestoreRepository_Handler,
		},
		{
			MethodName: "GetFileAttributes",
			Handler:    _RepositoryService_GetFileAttributes_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ObjectsSize",
			Handler:       _RepositoryService_ObjectsSize_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "GetArchive",
			Handler:       _RepositoryService_GetArchive_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CreateBundle",
			Handler:       _RepositoryService_CreateBundle_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CreateBundleFromRefList",
			Handler:       _RepositoryService_CreateBundleFromRefList_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "FetchBundle",
			Handler:       _RepositoryService_FetchBundle_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "CreateRepositoryFromBundle",
			Handler:       _RepositoryService_CreateRepositoryFromBundle_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "GetConfig",
			Handler:       _RepositoryService_GetConfig_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetInfoAttributes",
			Handler:       _RepositoryService_GetInfoAttributes_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetSnapshot",
			Handler:       _RepositoryService_GetSnapshot_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetRawChanges",
			Handler:       _RepositoryService_GetRawChanges_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SearchFilesByContent",
			Handler:       _RepositoryService_SearchFilesByContent_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SearchFilesByName",
			Handler:       _RepositoryService_SearchFilesByName_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RestoreCustomHooks",
			Handler:       _RepositoryService_RestoreCustomHooks_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "SetCustomHooks",
			Handler:       _RepositoryService_SetCustomHooks_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "BackupCustomHooks",
			Handler:       _RepositoryService_BackupCustomHooks_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetCustomHooks",
			Handler:       _RepositoryService_GetCustomHooks_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "repository.proto",
}
