// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Provides information about the permissions settings of the bucket-level access
// control list (ACL) for an S3 bucket.
type AccessControlList struct {

	// Specifies whether the ACL grants the general public with read access permissions
	// for the bucket.
	AllowsPublicReadAccess bool

	// Specifies whether the ACL grants the general public with write access
	// permissions for the bucket.
	AllowsPublicWriteAccess bool

	noSmithyDocumentSerde
}

// Specifies the details of an account to associate with an Amazon Macie
// administrator account.
type AccountDetail struct {

	// The Amazon Web Services account ID for the account.
	//
	// This member is required.
	AccountId *string

	// The email address for the account.
	//
	// This member is required.
	Email *string

	noSmithyDocumentSerde
}

// Provides information about the account-level permissions settings that apply to
// an S3 bucket.
type AccountLevelPermissions struct {

	// The block public access settings for the Amazon Web Services account that owns
	// the bucket.
	BlockPublicAccess *BlockPublicAccess

	noSmithyDocumentSerde
}

// Provides information about the delegated Amazon Macie administrator account for
// an organization in Organizations.
type AdminAccount struct {

	// The Amazon Web Services account ID for the account.
	AccountId *string

	// The current status of the account as the delegated Amazon Macie administrator
	// account for the organization.
	Status AdminStatus

	noSmithyDocumentSerde
}

// Provides information about an API operation that an entity invoked for an
// affected resource.
type ApiCallDetails struct {

	// The name of the operation that was invoked most recently and produced the
	// finding.
	Api *string

	// The URL of the Amazon Web Service that provides the operation, for example:
	// s3.amazonaws.com.
	ApiServiceName *string

	// The first date and time, in UTC and extended ISO 8601 format, when any operation
	// was invoked and produced the finding.
	FirstSeen *time.Time

	// The most recent date and time, in UTC and extended ISO 8601 format, when the
	// specified operation (api) was invoked and produced the finding.
	LastSeen *time.Time

	noSmithyDocumentSerde
}

// Provides information about an identity that performed an action on an affected
// resource by using temporary security credentials. The credentials were obtained
// using the AssumeRole operation of the Security Token Service (STS) API.
type AssumedRole struct {

	// The Amazon Web Services access key ID that identifies the credentials.
	AccessKeyId *string

	// The unique identifier for the Amazon Web Services account that owns the entity
	// that was used to get the credentials.
	AccountId *string

	// The Amazon Resource Name (ARN) of the entity that was used to get the
	// credentials.
	Arn *string

	// The unique identifier for the entity that was used to get the credentials.
	PrincipalId *string

	// The details of the session that was created for the credentials, including the
	// entity that issued the session.
	SessionContext *SessionContext

	noSmithyDocumentSerde
}

// Provides information about an Amazon Web Services account and entity that
// performed an action on an affected resource. The action was performed using the
// credentials for an Amazon Web Services account other than your own account.
type AwsAccount struct {

	// The unique identifier for the Amazon Web Services account.
	AccountId *string

	// The unique identifier for the entity that performed the action.
	PrincipalId *string

	noSmithyDocumentSerde
}

// Provides information about an Amazon Web Service that performed an action on an
// affected resource.
type AwsService struct {

	// The name of the Amazon Web Service that performed the action.
	InvokedBy *string

	noSmithyDocumentSerde
}

// Provides information about a custom data identifier.
type BatchGetCustomDataIdentifierSummary struct {

	// The Amazon Resource Name (ARN) of the custom data identifier.
	Arn *string

	// The date and time, in UTC and extended ISO 8601 format, when the custom data
	// identifier was created.
	CreatedAt *time.Time

	// Specifies whether the custom data identifier was deleted. If you delete a custom
	// data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft
	// deletes the identifier.
	Deleted bool

	// The custom description of the custom data identifier.
	Description *string

	// The unique identifier for the custom data identifier.
	Id *string

	// The custom name of the custom data identifier.
	Name *string

	noSmithyDocumentSerde
}

// Provides information about the block public access settings for an S3 bucket.
// These settings can apply to a bucket at the account level or bucket level. For
// detailed information about each setting, see Blocking public access to your
// Amazon S3 storage
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html)
// in the Amazon Simple Storage Service User Guide.
type BlockPublicAccess struct {

	// Specifies whether Amazon S3 blocks public access control lists (ACLs) for the
	// bucket and objects in the bucket.
	BlockPublicAcls bool

	// Specifies whether Amazon S3 blocks public bucket policies for the bucket.
	BlockPublicPolicy bool

	// Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in
	// the bucket.
	IgnorePublicAcls bool

	// Specifies whether Amazon S3 restricts public bucket policies for the bucket.
	RestrictPublicBuckets bool

	noSmithyDocumentSerde
}

// Provides information about the number of S3 buckets that are publicly accessible
// based on a combination of permissions settings for each bucket.
type BucketCountByEffectivePermission struct {

	// The total number of buckets that allow the general public to have read or write
	// access to the bucket.
	PubliclyAccessible int64

	// The total number of buckets that allow the general public to have read access to
	// the bucket.
	PubliclyReadable int64

	// The total number of buckets that allow the general public to have write access
	// to the bucket.
	PubliclyWritable int64

	// The total number of buckets that Amazon Macie wasn't able to evaluate
	// permissions settings for. Macie can't determine whether these buckets are
	// publicly accessible.
	Unknown int64

	noSmithyDocumentSerde
}

// Provides information about the number of S3 buckets that use certain types of
// server-side encryption by default or don't encrypt new objects by default. For
// detailed information about these settings, see Setting default server-side
// encryption behavior for Amazon S3 buckets
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html)
// in the Amazon Simple Storage Service User Guide.
type BucketCountByEncryptionType struct {

	// The total number of buckets that use an KMS key to encrypt new objects by
	// default, either an Amazon Web Services managed key or a customer managed key.
	// These buckets use KMS encryption (SSE-KMS) by default.
	KmsManaged int64

	// The total number of buckets that use an Amazon S3 managed key to encrypt new
	// objects by default. These buckets use Amazon S3 managed encryption (SSE-S3) by
	// default.
	S3Managed int64

	// The total number of buckets that don't encrypt new objects by default. Default
	// encryption is disabled for these buckets.
	Unencrypted int64

	// The total number of buckets that Amazon Macie doesn't have current encryption
	// metadata for. Macie can't provide current data about the default encryption
	// settings for these buckets.
	Unknown int64

	noSmithyDocumentSerde
}

// Provides information about the number of S3 buckets that are or aren't shared
// with other Amazon Web Services accounts.
type BucketCountBySharedAccessType struct {

	// The total number of buckets that are shared with an Amazon Web Services account
	// that isn't part of the same Amazon Macie organization.
	External int64

	// The total number of buckets that are shared with an Amazon Web Services account
	// that's part of the same Amazon Macie organization.
	Internal int64

	// The total number of buckets that aren't shared with other Amazon Web Services
	// accounts.
	NotShared int64

	// The total number of buckets that Amazon Macie wasn't able to evaluate shared
	// access settings for. Macie can't determine whether these buckets are shared with
	// other Amazon Web Services accounts.
	Unknown int64

	noSmithyDocumentSerde
}

// Provides information about the number of S3 buckets whose bucket policies do or
// don't require server-side encryption of objects when objects are uploaded to the
// buckets.
type BucketCountPolicyAllowsUnencryptedObjectUploads struct {

	// The total number of buckets that don't have a bucket policy or have a bucket
	// policy that doesn't require server-side encryption of new objects. If a bucket
	// policy exists, the policy doesn't require PutObject requests to include the
	// x-amz-server-side-encryption header and it doesn't require the value for that
	// header to be AES256 or aws:kms.
	AllowsUnencryptedObjectUploads int64

	// The total number of buckets whose bucket policies require server-side encryption
	// of new objects. PutObject requests for these buckets must include the
	// x-amz-server-side-encryption header and the value for that header must be AES256
	// or aws:kms.
	DeniesUnencryptedObjectUploads int64

	// The total number of buckets that Amazon Macie wasn't able to evaluate
	// server-side encryption requirements for. Macie can't determine whether the
	// bucket policies for these buckets require server-side encryption of new objects.
	Unknown int64

	noSmithyDocumentSerde
}

// Specifies the operator to use in a property-based condition that filters the
// results of a query for information about S3 buckets.
type BucketCriteriaAdditionalProperties struct {

	// The value for the property matches (equals) the specified value. If you specify
	// multiple values, Amazon Macie uses OR logic to join the values.
	Eq []string

	// The value for the property is greater than the specified value.
	Gt int64

	// The value for the property is greater than or equal to the specified value.
	Gte int64

	// The value for the property is less than the specified value.
	Lt int64

	// The value for the property is less than or equal to the specified value.
	Lte int64

	// The value for the property doesn't match (doesn't equal) the specified value. If
	// you specify multiple values, Amazon Macie uses OR logic to join the values.
	Neq []string

	// The name of the bucket begins with the specified value.
	Prefix *string

	noSmithyDocumentSerde
}

// Provides information about the bucket-level permissions settings for an S3
// bucket.
type BucketLevelPermissions struct {

	// The permissions settings of the access control list (ACL) for the bucket. This
	// value is null if an ACL hasn't been defined for the bucket.
	AccessControlList *AccessControlList

	// The block public access settings for the bucket.
	BlockPublicAccess *BlockPublicAccess

	// The permissions settings of the bucket policy for the bucket. This value is null
	// if a bucket policy hasn't been defined for the bucket.
	BucketPolicy *BucketPolicy

	noSmithyDocumentSerde
}

// Provides statistical data and other information about an S3 bucket that Amazon
// Macie monitors and analyzes for your account. If an error occurs when Macie
// attempts to retrieve and process information about the bucket or the bucket's
// objects, the value for the versioning property is false and the value for most
// other properties is null. Exceptions are accountId, bucketArn, bucketCreatedAt,
// bucketName, lastUpdated, and region. To identify the cause of the error, refer
// to the errorCode and errorMessage values.
type BucketMetadata struct {

	// The unique identifier for the Amazon Web Services account that owns the bucket.
	AccountId *string

	// Specifies whether the bucket policy for the bucket requires server-side
	// encryption of objects when objects are uploaded to the bucket. Possible values
	// are:
	//
	// * FALSE - The bucket policy requires server-side encryption of new
	// objects. PutObject requests must include the x-amz-server-side-encryption header
	// and the value for that header must be AES256 or aws:kms.
	//
	// * TRUE - The bucket
	// doesn't have a bucket policy or it has a bucket policy that doesn't require
	// server-side encryption of new objects. If a bucket policy exists, it doesn't
	// require PutObject requests to include the x-amz-server-side-encryption header
	// and it doesn't require the value for that header to be AES256 or aws:kms.
	//
	// *
	// UNKNOWN - Amazon Macie can't determine whether the bucket policy requires
	// server-side encryption of new objects.
	AllowsUnencryptedObjectUploads AllowsUnencryptedObjectUploads

	// The Amazon Resource Name (ARN) of the bucket.
	BucketArn *string

	// The date and time, in UTC and extended ISO 8601 format, when the bucket was
	// created.
	BucketCreatedAt *time.Time

	// The name of the bucket.
	BucketName *string

	// The total number of objects that Amazon Macie can analyze in the bucket. These
	// objects use a supported storage class and have a file name extension for a
	// supported file or storage format.
	ClassifiableObjectCount int64

	// The total storage size, in bytes, of the objects that Amazon Macie can analyze
	// in the bucket. These objects use a supported storage class and have a file name
	// extension for a supported file or storage format. If versioning is enabled for
	// the bucket, Macie calculates this value based on the size of the latest version
	// of each applicable object in the bucket. This value doesn't reflect the storage
	// size of all versions of each applicable object in the bucket.
	ClassifiableSizeInBytes int64

	// Specifies the error code for an error that prevented Amazon Macie from
	// retrieving and processing information about the bucket and the bucket's objects.
	// If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the
	// information. For example, the bucket has a restrictive bucket policy and Amazon
	// S3 denied the request. If this value is null, Macie was able to retrieve and
	// process the information.
	ErrorCode BucketMetadataErrorCode

	// A brief description of the error (errorCode) that prevented Amazon Macie from
	// retrieving and processing information about the bucket and the bucket's objects.
	// This value is null if Macie was able to retrieve and process the information.
	ErrorMessage *string

	// Specifies whether any one-time or recurring classification jobs are configured
	// to analyze data in the bucket, and, if so, the details of the job that ran most
	// recently.
	JobDetails *JobDetails

	// The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most
	// recently retrieved both bucket and object metadata from Amazon S3 for the
	// bucket.
	LastUpdated *time.Time

	// The total number of objects in the bucket.
	ObjectCount int64

	// The total number of objects that are in the bucket, grouped by server-side
	// encryption type. This includes a grouping that reports the total number of
	// objects that aren't encrypted or use client-side encryption.
	ObjectCountByEncryptionType *ObjectCountByEncryptionType

	// Specifies whether the bucket is publicly accessible due to the combination of
	// permissions settings that apply to the bucket, and provides information about
	// those settings.
	PublicAccess *BucketPublicAccess

	// The Amazon Web Services Region that hosts the bucket.
	Region *string

	// Specifies whether the bucket is configured to replicate one or more objects to
	// buckets for other Amazon Web Services accounts and, if so, which accounts.
	ReplicationDetails *ReplicationDetails

	// Specifies whether the bucket encrypts new objects by default and, if so, the
	// type of server-side encryption that's used.
	ServerSideEncryption *BucketServerSideEncryption

	// Specifies whether the bucket is shared with another Amazon Web Services account.
	// Possible values are:
	//
	// * EXTERNAL - The bucket is shared with an Amazon Web
	// Services account that isn't part of the same Amazon Macie organization.
	//
	// *
	// INTERNAL - The bucket is shared with an Amazon Web Services account that's part
	// of the same Amazon Macie organization.
	//
	// * NOT_SHARED - The bucket isn't shared
	// with other Amazon Web Services accounts.
	//
	// * UNKNOWN - Amazon Macie wasn't able
	// to evaluate the shared access settings for the bucket.
	SharedAccess SharedAccess

	// The total storage size, in bytes, of the bucket. If versioning is enabled for
	// the bucket, Amazon Macie calculates this value based on the size of the latest
	// version of each object in the bucket. This value doesn't reflect the storage
	// size of all versions of each object in the bucket.
	SizeInBytes int64

	// The total storage size, in bytes, of the objects that are compressed (.gz,
	// .gzip, .zip) files in the bucket. If versioning is enabled for the bucket,
	// Amazon Macie calculates this value based on the size of the latest version of
	// each applicable object in the bucket. This value doesn't reflect the storage
	// size of all versions of each applicable object in the bucket.
	SizeInBytesCompressed int64

	// An array that specifies the tags (keys and values) that are associated with the
	// bucket.
	Tags []KeyValuePair

	// The total number of objects that Amazon Macie can't analyze in the bucket. These
	// objects don't use a supported storage class or don't have a file name extension
	// for a supported file or storage format.
	UnclassifiableObjectCount *ObjectLevelStatistics

	// The total storage size, in bytes, of the objects that Amazon Macie can't analyze
	// in the bucket. These objects don't use a supported storage class or don't have a
	// file name extension for a supported file or storage format.
	UnclassifiableObjectSizeInBytes *ObjectLevelStatistics

	// Specifies whether versioning is enabled for the bucket.
	Versioning bool

	noSmithyDocumentSerde
}

// Provides information about the account-level and bucket-level permissions
// settings for an S3 bucket.
type BucketPermissionConfiguration struct {

	// The account-level permissions settings that apply to the bucket.
	AccountLevelPermissions *AccountLevelPermissions

	// The bucket-level permissions settings for the bucket.
	BucketLevelPermissions *BucketLevelPermissions

	noSmithyDocumentSerde
}

// Provides information about the permissions settings of the bucket policy for an
// S3 bucket.
type BucketPolicy struct {

	// Specifies whether the bucket policy allows the general public to have read
	// access to the bucket.
	AllowsPublicReadAccess bool

	// Specifies whether the bucket policy allows the general public to have write
	// access to the bucket.
	AllowsPublicWriteAccess bool

	noSmithyDocumentSerde
}

// Provides information about the permissions settings that determine whether an S3
// bucket is publicly accessible.
type BucketPublicAccess struct {

	// Specifies whether the bucket is publicly accessible due to the combination of
	// permissions settings that apply to the bucket. Possible values are:
	//
	// *
	// NOT_PUBLIC - The bucket isn't publicly accessible.
	//
	// * PUBLIC - The bucket is
	// publicly accessible.
	//
	// * UNKNOWN - Amazon Macie can't determine whether the
	// bucket is publicly accessible.
	EffectivePermission EffectivePermission

	// The account-level and bucket-level permissions settings for the bucket.
	PermissionConfiguration *BucketPermissionConfiguration

	noSmithyDocumentSerde
}

// Provides information about the default server-side encryption settings for an S3
// bucket. For detailed information about these settings, see Setting default
// server-side encryption behavior for Amazon S3 buckets
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html)
// in the Amazon Simple Storage Service User Guide.
type BucketServerSideEncryption struct {

	// The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key
	// that's used by default to encrypt objects that are added to the bucket. This
	// value is null if the bucket uses an Amazon S3 managed key to encrypt new objects
	// or the bucket doesn't encrypt new objects by default.
	KmsMasterKeyId *string

	// The type of server-side encryption that's used by default when storing new
	// objects in the bucket. Possible values are:
	//
	// * AES256 - New objects are
	// encrypted with an Amazon S3 managed key. They use SSE-S3 encryption.
	//
	// * aws:kms
	// - New objects are encrypted with an KMS key (kmsMasterKeyId), either an Amazon
	// Web Services managed key or a customer managed key. They use SSE-KMS
	// encryption.
	//
	// * NONE - New objects aren't encrypted by default. Default
	// encryption is disabled for the bucket.
	Type Type

	noSmithyDocumentSerde
}

// Specifies criteria for sorting the results of a query for information about S3
// buckets.
type BucketSortCriteria struct {

	// The name of the bucket property to sort the results by. This value can be one of
	// the following properties that Amazon Macie defines as bucket metadata:
	// accountId, bucketName, classifiableObjectCount, classifiableSizeInBytes,
	// objectCount, or sizeInBytes.
	AttributeName *string

	// The sort order to apply to the results, based on the value specified by the
	// attributeName property. Valid values are: ASC, sort the results in ascending
	// order; and, DESC, sort the results in descending order.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// Specifies the location of an occurrence of sensitive data in a Microsoft Excel
// workbook, CSV file, or TSV file.
type Cell struct {

	// The location of the cell, as an absolute cell reference, that contains the
	// sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel
	// workbook. This value is null for CSV and TSV files.
	CellReference *string

	// The column number of the column that contains the sensitive data. For a
	// Microsoft Excel workbook, this value correlates to the alphabetical character(s)
	// for a column identifier, for example: 1 for column A, 2 for column B, and so on.
	Column int64

	// The name of the column that contains the sensitive data, if available.
	ColumnName *string

	// The row number of the row that contains the sensitive data.
	Row int64

	noSmithyDocumentSerde
}

// Provides information about a sensitive data finding and the details of the
// finding.
type ClassificationDetails struct {

	// The path to the folder or file (in Amazon S3) that contains the corresponding
	// sensitive data discovery result for the finding. If a finding applies to a large
	// archive or compressed file, this value is the path to a folder. Otherwise, this
	// value is the path to a file.
	DetailedResultsLocation *string

	// The Amazon Resource Name (ARN) of the classification job that produced the
	// finding.
	JobArn *string

	// The unique identifier for the classification job that produced the finding.
	JobId *string

	// Specifies how Amazon Macie found the sensitive data that produced the finding:
	// SENSITIVE_DATA_DISCOVERY_JOB, for a classification job.
	OriginType OriginType

	// The status and other details of the finding.
	Result *ClassificationResult

	noSmithyDocumentSerde
}

// Specifies where to store data classification results, and the encryption
// settings to use when storing results in that location. Currently, you can store
// classification results only in an S3 bucket.
type ClassificationExportConfiguration struct {

	// The S3 bucket to store data classification results in, and the encryption
	// settings to use when storing results in that bucket.
	S3Destination *S3Destination

	noSmithyDocumentSerde
}

// Provides the details of a sensitive data finding, including the types, number of
// occurrences, and locations of the sensitive data that was detected.
type ClassificationResult struct {

	// Specifies whether Amazon Macie detected additional occurrences of sensitive data
	// in the S3 object. A finding includes location data for a maximum of 15
	// occurrences of sensitive data. This value can help you determine whether to
	// investigate additional occurrences of sensitive data in an object. You can do
	// this by referring to the corresponding sensitive data discovery result for the
	// finding (ClassificationDetails.detailedResultsLocation).
	AdditionalOccurrences bool

	// The custom data identifiers that detected the sensitive data and the number of
	// occurrences of the data that they detected.
	CustomDataIdentifiers *CustomDataIdentifiers

	// The type of content, as a MIME type, that the finding applies to. For example,
	// application/gzip, for a GNU Gzip compressed archive file, or application/pdf,
	// for an Adobe Portable Document Format file.
	MimeType *string

	// The category, types, and number of occurrences of the sensitive data that
	// produced the finding.
	SensitiveData []SensitiveDataItem

	// The total size, in bytes, of the data that the finding applies to.
	SizeClassified int64

	// The status of the finding.
	Status *ClassificationResultStatus

	noSmithyDocumentSerde
}

// Provides information about the status of a sensitive data finding.
type ClassificationResultStatus struct {

	// The status of the finding. Possible values are:
	//
	// * COMPLETE - Amazon Macie
	// successfully completed its analysis of the S3 object that the finding applies
	// to.
	//
	// * PARTIAL - Macie analyzed only a subset of the data in the S3 object that
	// the finding applies to. For example, the object is an archive file that contains
	// files in an unsupported format.
	//
	// * SKIPPED - Macie wasn't able to analyze the S3
	// object that the finding applies to. For example, the object is a file that uses
	// an unsupported format.
	Code *string

	// A brief description of the status of the finding. This value is null if the
	// status (code) of the finding is COMPLETE. Amazon Macie uses this value to notify
	// you of any errors, warnings, or considerations that might impact your analysis
	// of the finding and the affected S3 object. Possible values are:
	//
	// *
	// ARCHIVE_CONTAINS_UNPROCESSED_FILES - The object is an archive file and Macie
	// extracted and analyzed only some or none of the files in the archive. To
	// determine which files Macie analyzed, if any, you can refer to the corresponding
	// sensitive data discovery result for the finding
	// (ClassificationDetails.detailedResultsLocation).
	//
	// * ARCHIVE_EXCEEDS_SIZE_LIMIT -
	// The object is an archive file whose total storage size exceeds the size quota
	// for this type of archive.
	//
	// * ARCHIVE_NESTING_LEVEL_OVER_LIMIT - The object is an
	// archive file whose nested depth exceeds the quota for the maximum number of
	// nested levels that Macie analyzes for this type of archive.
	//
	// *
	// ARCHIVE_TOTAL_BYTES_EXTRACTED_OVER_LIMIT - The object is an archive file that
	// exceeds the quota for the maximum amount of data that Macie extracts and
	// analyzes for this type of archive.
	//
	// *
	// ARCHIVE_TOTAL_DOCUMENTS_PROCESSED_OVER_LIMIT - The object is an archive file
	// that contains more than the maximum number of files that Macie extracts and
	// analyzes for this type of archive.
	//
	// * FILE_EXCEEDS_SIZE_LIMIT - The storage size
	// of the object exceeds the size quota for this type of file.
	//
	// *
	// INVALID_ENCRYPTION - The object is encrypted using server-side encryption but
	// Macie isn’t allowed to use the key. Macie can’t decrypt and analyze the
	// object.
	//
	// * INVALID_KMS_KEY - The object is encrypted with an KMS key that was
	// disabled or is being deleted. Macie can’t decrypt and analyze the object.
	//
	// *
	// INVALID_OBJECT_STATE - The object doesn’t use a supported Amazon S3 storage
	// class. For more information, see Discovering sensitive data
	// (https://docs.aws.amazon.com/macie/latest/user/data-classification.html) in the
	// Amazon Macie User Guide.
	//
	// * JSON_NESTING_LEVEL_OVER_LIMIT - The object contains
	// JSON data and the nested depth of the data exceeds the quota for the number of
	// nested levels that Macie analyzes for this type of file.
	//
	// * MALFORMED_FILE - The
	// object is a malformed or corrupted file. An error occurred when Macie attempted
	// to detect the file’s type or extract data from the file.
	//
	// *
	// OBJECT_VERSION_MISMATCH - The object was changed while Macie was analyzing
	// it.
	//
	// * NO_SUCH_BUCKET_AVAILABLE - The object was in a bucket that was deleted
	// shortly before or when Macie attempted to analyze the object.
	//
	// *
	// MALFORMED_OR_FILE_SIZE_EXCEEDS_LIMIT - The object is a Microsoft Office file
	// that is malformed or exceeds the size quota for this type of file. If the file
	// is malformed, an error occurred when Macie attempted to extract data from the
	// file.
	//
	// * OOXML_UNCOMPRESSED_SIZE_EXCEEDS_LIMIT - The object is an Office Open
	// XML file that exceeds the size quota for this type of file.
	//
	// *
	// OOXML_UNCOMPRESSED_RATIO_EXCEEDS_LIMIT - The object is an Office Open XML file
	// whose compression ratio exceeds the compression quota for this type of file.
	//
	// *
	// PERMISSION_DENIED - Macie isn’t allowed to access the object. The object’s
	// permissions settings prevent Macie from analyzing the object.
	//
	// *
	// SOURCE_OBJECT_NO_LONGER_AVAILABLE - The object was deleted shortly before or
	// when Macie attempted to analyze it.
	//
	// * UNABLE_TO_PARSE_FILE - The object is a
	// file that contains structured data and an error occurred when Macie attempted to
	// parse the data.
	//
	// * UNSUPPORTED_FILE_TYPE_EXCEPTION - The object is a file that
	// uses an unsupported file or storage format. For more information, see Supported
	// file and storage formats
	// (https://docs.aws.amazon.com/macie/latest/user/discovery-supported-formats.html)
	// in the Amazon Macie User Guide.
	//
	// For information about sensitive data discovery
	// quotas for files, see Amazon Macie quotas
	// (https://docs.aws.amazon.com/macie/latest/user/macie-quotas.html) in the Amazon
	// Macie User Guide.
	Reason *string

	noSmithyDocumentSerde
}

// Specifies one or more property- and tag-based conditions that define criteria
// for including or excluding S3 buckets from a classification job.
type CriteriaBlockForJob struct {

	// An array of conditions, one for each condition that determines which buckets to
	// include or exclude from the job. If you specify more than one condition, Amazon
	// Macie uses AND logic to join the conditions.
	And []CriteriaForJob

	noSmithyDocumentSerde
}

// Specifies a property- or tag-based condition that defines criteria for including
// or excluding S3 buckets from a classification job.
type CriteriaForJob struct {

	// A property-based condition that defines a property, operator, and one or more
	// values for including or excluding buckets from the job.
	SimpleCriterion *SimpleCriterionForJob

	// A tag-based condition that defines an operator and tag keys, tag values, or tag
	// key and value pairs for including or excluding buckets from the job.
	TagCriterion *TagCriterionForJob

	noSmithyDocumentSerde
}

// Specifies the operator to use in a property-based condition that filters the
// results of a query for findings. For detailed information and examples of each
// operator, see Fundamentals of filtering findings
// (https://docs.aws.amazon.com/macie/latest/user/findings-filter-basics.html) in
// the Amazon Macie User Guide.
type CriterionAdditionalProperties struct {

	// The value for the property matches (equals) the specified value. If you specify
	// multiple values, Macie uses OR logic to join the values.
	Eq []string

	// The value for the property exclusively matches (equals an exact match for) all
	// the specified values. If you specify multiple values, Amazon Macie uses AND
	// logic to join the values. You can use this operator with the following
	// properties: customDataIdentifiers.detections.arn,
	// customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
	// resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
	// resourcesAffected.s3Object.tags.value, sensitiveData.category, and
	// sensitiveData.detections.type.
	EqExactMatch []string

	// The value for the property is greater than the specified value.
	Gt int64

	// The value for the property is greater than or equal to the specified value.
	Gte int64

	// The value for the property is less than the specified value.
	Lt int64

	// The value for the property is less than or equal to the specified value.
	Lte int64

	// The value for the property doesn't match (doesn't equal) the specified value. If
	// you specify multiple values, Macie uses OR logic to join the values.
	Neq []string

	noSmithyDocumentSerde
}

// Provides information about custom data identifiers that produced a sensitive
// data finding, and the number of occurrences of the data that they detected for
// the finding.
type CustomDataIdentifiers struct {

	// The custom data identifiers that detected the data, and the number of
	// occurrences of the data that each identifier detected.
	Detections []CustomDetection

	// The total number of occurrences of the data that was detected by the custom data
	// identifiers and produced the finding.
	TotalCount int64

	noSmithyDocumentSerde
}

// Provides information about a custom data identifier.
type CustomDataIdentifierSummary struct {

	// The Amazon Resource Name (ARN) of the custom data identifier.
	Arn *string

	// The date and time, in UTC and extended ISO 8601 format, when the custom data
	// identifier was created.
	CreatedAt *time.Time

	// The custom description of the custom data identifier.
	Description *string

	// The unique identifier for the custom data identifier.
	Id *string

	// The custom name of the custom data identifier.
	Name *string

	noSmithyDocumentSerde
}

// Provides information about a custom data identifier that produced a sensitive
// data finding, and the sensitive data that it detected for the finding.
type CustomDetection struct {

	// The Amazon Resource Name (ARN) of the custom data identifier.
	Arn *string

	// The total number of occurrences of the sensitive data that the custom data
	// identifier detected.
	Count int64

	// The name of the custom data identifier.
	Name *string

	// The location of 1-15 occurrences of the sensitive data that the custom data
	// identifier detected. A finding includes location data for a maximum of 15
	// occurrences of sensitive data.
	Occurrences *Occurrences

	noSmithyDocumentSerde
}

// Specifies that a classification job runs once a day, every day. This is an empty
// object.
type DailySchedule struct {
	noSmithyDocumentSerde
}

// Provides information about a type of sensitive data that was detected by a
// managed data identifier and produced a sensitive data finding.
type DefaultDetection struct {

	// The total number of occurrences of the type of sensitive data that was detected.
	Count int64

	// The location of 1-15 occurrences of the sensitive data that was detected. A
	// finding includes location data for a maximum of 15 occurrences of sensitive
	// data.
	Occurrences *Occurrences

	// The type of sensitive data that was detected. For example, AWS_CREDENTIALS,
	// PHONE_NUMBER, or ADDRESS.
	Type *string

	noSmithyDocumentSerde
}

// Specifies 1-10 occurrences of a specific type of sensitive data reported by a
// finding.
type DetectedDataDetails struct {

	// An occurrence of the specified type of sensitive data. Each occurrence can
	// contain 1-128 characters.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Provides information about the domain name of the device that an entity used to
// perform an action on an affected resource.
type DomainDetails struct {

	// The name of the domain.
	DomainName *string

	noSmithyDocumentSerde
}

// Provides information about an identity that performed an action on an affected
// resource by using temporary security credentials. The credentials were obtained
// using the GetFederationToken operation of the Security Token Service (STS) API.
type FederatedUser struct {

	// The Amazon Web Services access key ID that identifies the credentials.
	AccessKeyId *string

	// The unique identifier for the Amazon Web Services account that owns the entity
	// that was used to get the credentials.
	AccountId *string

	// The Amazon Resource Name (ARN) of the entity that was used to get the
	// credentials.
	Arn *string

	// The unique identifier for the entity that was used to get the credentials.
	PrincipalId *string

	// The details of the session that was created for the credentials, including the
	// entity that issued the session.
	SessionContext *SessionContext

	noSmithyDocumentSerde
}

// Provides the details of a finding.
type Finding struct {

	// The unique identifier for the Amazon Web Services account that the finding
	// applies to. This is typically the account that owns the affected resource.
	AccountId *string

	// Specifies whether the finding is archived (suppressed).
	Archived bool

	// The category of the finding. Possible values are: CLASSIFICATION, for a
	// sensitive data finding; and, POLICY, for a policy finding.
	Category FindingCategory

	// The details of a sensitive data finding. This value is null for a policy
	// finding.
	ClassificationDetails *ClassificationDetails

	// The total number of occurrences of the finding. For sensitive data findings,
	// this value is always 1. All sensitive data findings are considered new (unique)
	// because they derive from individual classification jobs.
	Count int64

	// The date and time, in UTC and extended ISO 8601 format, when the finding was
	// created.
	CreatedAt *time.Time

	// The description of the finding.
	Description *string

	// The unique identifier for the finding. This is a random string that Amazon Macie
	// generates and assigns to a finding when it creates the finding.
	Id *string

	// The Amazon Web Services partition that Amazon Macie created the finding in.
	Partition *string

	// The details of a policy finding. This value is null for a sensitive data
	// finding.
	PolicyDetails *PolicyDetails

	// The Amazon Web Services Region that Amazon Macie created the finding in.
	Region *string

	// The resources that the finding applies to.
	ResourcesAffected *ResourcesAffected

	// Specifies whether the finding is a sample finding. A sample finding is a finding
	// that uses example data to demonstrate what a finding might contain.
	Sample bool

	// The version of the schema that was used to define the data structures in the
	// finding.
	SchemaVersion *string

	// The severity level and score for the finding.
	Severity *Severity

	// The brief description of the finding.
	Title *string

	// The type of the finding.
	Type FindingType

	// The date and time, in UTC and extended ISO 8601 format, when the finding was
	// last updated. For sensitive data findings, this value is the same as the value
	// for the createdAt property. All sensitive data findings are considered new
	// (unique) because they derive from individual classification jobs.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides information about an action that occurred for a resource and produced a
// policy finding.
type FindingAction struct {

	// The type of action that occurred for the affected resource. This value is
	// typically AWS_API_CALL, which indicates that an entity invoked an API operation
	// for the resource.
	ActionType FindingActionType

	// The invocation details of the API operation that an entity invoked for the
	// affected resource, if the value for the actionType property is AWS_API_CALL.
	ApiCallDetails *ApiCallDetails

	noSmithyDocumentSerde
}

// Provides information about an entity that performed an action that produced a
// policy finding for a resource.
type FindingActor struct {

	// The domain name of the device that the entity used to perform the action on the
	// affected resource.
	DomainDetails *DomainDetails

	// The IP address of the device that the entity used to perform the action on the
	// affected resource. This object also provides information such as the owner and
	// geographic location for the IP address.
	IpAddressDetails *IpAddressDetails

	// The type and other characteristics of the entity that performed the action on
	// the affected resource.
	UserIdentity *UserIdentity

	noSmithyDocumentSerde
}

// Specifies, as a map, one or more property-based conditions that filter the
// results of a query for findings.
type FindingCriteria struct {

	// A condition that specifies the property, operator, and one or more values to use
	// to filter the results.
	Criterion map[string]CriterionAdditionalProperties

	noSmithyDocumentSerde
}

// Provides information about a findings filter.
type FindingsFilterListItem struct {

	// The action that's performed on findings that meet the filter criteria. Possible
	// values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP,
	// don't perform any action on the findings.
	Action FindingsFilterAction

	// The Amazon Resource Name (ARN) of the filter.
	Arn *string

	// The unique identifier for the filter.
	Id *string

	// The custom name of the filter.
	Name *string

	// A map of key-value pairs that identifies the tags (keys and values) that are
	// associated with the filter.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Specifies criteria for sorting the results of a query that retrieves aggregated
// statistical data about findings.
type FindingStatisticsSortCriteria struct {

	// The grouping to sort the results by. Valid values are: count, sort the results
	// by the number of findings in each group of results; and, groupKey, sort the
	// results by the name of each group of results.
	AttributeName FindingStatisticsSortAttributeName

	// The sort order to apply to the results, based on the value for the property
	// specified by the attributeName property. Valid values are: ASC, sort the results
	// in ascending order; and, DESC, sort the results in descending order.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// Provides a group of results for a query that retrieved aggregated statistical
// data about findings.
type GroupCount struct {

	// The total number of findings in the group of query results.
	Count int64

	// The name of the property that defines the group in the query results, as
	// specified by the groupBy property in the query request.
	GroupKey *string

	noSmithyDocumentSerde
}

// Provides information about an Identity and Access Management (IAM) user who
// performed an action on an affected resource.
type IamUser struct {

	// The unique identifier for the Amazon Web Services account that's associated with
	// the IAM user who performed the action.
	AccountId *string

	// The Amazon Resource Name (ARN) of the principal that performed the action. The
	// last section of the ARN contains the name of the user who performed the action.
	Arn *string

	// The unique identifier for the IAM user who performed the action.
	PrincipalId *string

	// The user name of the IAM user who performed the action.
	UserName *string

	noSmithyDocumentSerde
}

// Provides information about an Amazon Macie membership invitation.
type Invitation struct {

	// The Amazon Web Services account ID for the account that sent the invitation.
	AccountId *string

	// The unique identifier for the invitation.
	InvitationId *string

	// The date and time, in UTC and extended ISO 8601 format, when the invitation was
	// sent.
	InvitedAt *time.Time

	// The status of the relationship between the account that sent the invitation and
	// the account that received the invitation.
	RelationshipStatus RelationshipStatus

	noSmithyDocumentSerde
}

// Provides information about the IP address of the device that an entity used to
// perform an action on an affected resource.
type IpAddressDetails struct {

	// The Internet Protocol version 4 (IPv4) address of the device.
	IpAddressV4 *string

	// The city that the IP address originated from.
	IpCity *IpCity

	// The country that the IP address originated from.
	IpCountry *IpCountry

	// The geographic coordinates of the location that the IP address originated from.
	IpGeoLocation *IpGeoLocation

	// The registered owner of the IP address.
	IpOwner *IpOwner

	noSmithyDocumentSerde
}

// Provides information about the city that an IP address originated from.
type IpCity struct {

	// The name of the city.
	Name *string

	noSmithyDocumentSerde
}

// Provides information about the country that an IP address originated from.
type IpCountry struct {

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country that the
	// IP address originated from. For example, US for the United States.
	Code *string

	// The name of the country that the IP address originated from.
	Name *string

	noSmithyDocumentSerde
}

// Provides geographic coordinates that indicate where a specified IP address
// originated from.
type IpGeoLocation struct {

	// The latitude coordinate of the location, rounded to four decimal places.
	Lat float64

	// The longitude coordinate of the location, rounded to four decimal places.
	Lon float64

	noSmithyDocumentSerde
}

// Provides information about the registered owner of an IP address.
type IpOwner struct {

	// The autonomous system number (ASN) for the autonomous system that included the
	// IP address.
	Asn *string

	// The organization identifier that's associated with the autonomous system number
	// (ASN) for the autonomous system that included the IP address.
	AsnOrg *string

	// The name of the internet service provider (ISP) that owned the IP address.
	Isp *string

	// The name of the organization that owned the IP address.
	Org *string

	noSmithyDocumentSerde
}

// Specifies whether any one-time or recurring classification jobs are configured
// to analyze data in an S3 bucket, and, if so, the details of the job that ran
// most recently.
type JobDetails struct {

	// Specifies whether any one-time or recurring jobs are configured to analyze data
	// in the bucket. Possible values are:
	//
	// * TRUE - The bucket is explicitly included
	// in the bucket definition (S3BucketDefinitionForJob) for one or more jobs and at
	// least one of those jobs has a status other than CANCELLED. Or the bucket matched
	// the bucket criteria (S3BucketCriteriaForJob) for at least one job that
	// previously ran.
	//
	// * FALSE - The bucket isn't explicitly included in the bucket
	// definition (S3BucketDefinitionForJob) for any jobs, all the jobs that explicitly
	// include the bucket in their bucket definitions have a status of CANCELLED, or
	// the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any
	// jobs that previously ran.
	//
	// * UNKNOWN - An exception occurred when Amazon Macie
	// attempted to retrieve job data for the bucket.
	IsDefinedInJob IsDefinedInJob

	// Specifies whether any recurring jobs are configured to analyze data in the
	// bucket. Possible values are:
	//
	// * TRUE - The bucket is explicitly included in the
	// bucket definition (S3BucketDefinitionForJob) for one or more recurring jobs or
	// the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more
	// recurring jobs. At least one of those jobs has a status other than CANCELLED.
	//
	// *
	// FALSE - The bucket isn't explicitly included in the bucket definition
	// (S3BucketDefinitionForJob) for any recurring jobs, the bucket doesn't match the
	// bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or all the
	// recurring jobs that are configured to analyze data in the bucket have a status
	// of CANCELLED.
	//
	// * UNKNOWN - An exception occurred when Amazon Macie attempted to
	// retrieve job data for the bucket.
	IsMonitoredByJob IsMonitoredByJob

	// The unique identifier for the job that ran most recently and is configured to
	// analyze data in the bucket, either the latest run of a recurring job or the only
	// run of a one-time job. This value is typically null if the value for the
	// isDefinedInJob property is FALSE or UNKNOWN.
	LastJobId *string

	// The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId)
	// started. If the job is a recurring job, this value indicates when the most
	// recent run started. This value is typically null if the value for the
	// isDefinedInJob property is FALSE or UNKNOWN.
	LastJobRunTime *time.Time

	noSmithyDocumentSerde
}

// Specifies the recurrence pattern for running a classification job.
type JobScheduleFrequency struct {

	// Specifies a daily recurrence pattern for running the job.
	DailySchedule *DailySchedule

	// Specifies a monthly recurrence pattern for running the job.
	MonthlySchedule *MonthlySchedule

	// Specifies a weekly recurrence pattern for running the job.
	WeeklySchedule *WeeklySchedule

	noSmithyDocumentSerde
}

// Specifies a property- or tag-based condition that defines criteria for including
// or excluding S3 objects from a classification job. A JobScopeTerm object can
// contain only one simpleScopeTerm object or one tagScopeTerm object.
type JobScopeTerm struct {

	// A property-based condition that defines a property, operator, and one or more
	// values for including or excluding objects from the job.
	SimpleScopeTerm *SimpleScopeTerm

	// A tag-based condition that defines the operator and tag keys or tag key and
	// value pairs for including or excluding objects from the job.
	TagScopeTerm *TagScopeTerm

	noSmithyDocumentSerde
}

// Specifies one or more property- and tag-based conditions that define criteria
// for including or excluding S3 objects from a classification job.
type JobScopingBlock struct {

	// An array of conditions, one for each property- or tag-based condition that
	// determines which objects to include or exclude from the job. If you specify more
	// than one condition, Amazon Macie uses AND logic to join the conditions.
	And []JobScopeTerm

	noSmithyDocumentSerde
}

// Provides information about a classification job, including the current status of
// the job.
type JobSummary struct {

	// The property- and tag-based conditions that determine which S3 buckets are
	// included or excluded from the job's analysis. Each time the job runs, the job
	// uses these criteria to determine which buckets to analyze. A job's definition
	// can contain a bucketCriteria object or a bucketDefinitions array, not both.
	BucketCriteria *S3BucketCriteriaForJob

	// An array of objects, one for each Amazon Web Services account that owns specific
	// S3 buckets for the job to analyze. Each object specifies the account ID for an
	// account and one or more buckets to analyze for that account. A job's definition
	// can contain a bucketDefinitions array or a bucketCriteria object, not both.
	BucketDefinitions []S3BucketDefinitionForJob

	// The date and time, in UTC and extended ISO 8601 format, when the job was
	// created.
	CreatedAt *time.Time

	// The unique identifier for the job.
	JobId *string

	// The current status of the job. Possible values are:
	//
	// * CANCELLED - You cancelled
	// the job or, if it's a one-time job, you paused the job and didn't resume it
	// within 30 days.
	//
	// * COMPLETE - For a one-time job, Amazon Macie finished
	// processing the data specified for the job. This value doesn't apply to recurring
	// jobs.
	//
	// * IDLE - For a recurring job, the previous scheduled run is complete and
	// the next scheduled run is pending. This value doesn't apply to one-time jobs.
	//
	// *
	// PAUSED - Macie started running the job but additional processing would exceed
	// the monthly sensitive data discovery quota for your account or one or more
	// member accounts that the job analyzes data for.
	//
	// * RUNNING - For a one-time job,
	// the job is in progress. For a recurring job, a scheduled run is in progress.
	//
	// *
	// USER_PAUSED - You paused the job. If you paused the job while it had a status of
	// RUNNING and you don't resume it within 30 days of pausing it, the job or job run
	// will expire and be cancelled, depending on the job's type. To check the
	// expiration date, refer to the UserPausedDetails.jobExpiresAt property.
	JobStatus JobStatus

	// The schedule for running the job. Possible values are:
	//
	// * ONE_TIME - The job
	// runs only once.
	//
	// * SCHEDULED - The job runs on a daily, weekly, or monthly
	// basis.
	JobType JobType

	// Specifies whether any account- or bucket-level access errors occurred when the
	// job ran. For a recurring job, this value indicates the error status of the job's
	// most recent run.
	LastRunErrorStatus *LastRunErrorStatus

	// The custom name of the job.
	Name *string

	// If the current status of the job is USER_PAUSED, specifies when the job was
	// paused and when the job or job run will expire and be cancelled if it isn't
	// resumed. This value is present only if the value for jobStatus is USER_PAUSED.
	UserPausedDetails *UserPausedDetails

	noSmithyDocumentSerde
}

// Provides information about the tags that are associated with an S3 bucket or
// object. Each tag consists of a required tag key and an associated tag value.
type KeyValuePair struct {

	// One part of a key-value pair that comprises a tag. A tag key is a general label
	// that acts as a category for more specific tag values.
	Key *string

	// One part of a key-value pair that comprises a tag. A tag value acts as a
	// descriptor for a tag key. A tag value can be an empty string.
	Value *string

	noSmithyDocumentSerde
}

// Specifies whether any account- or bucket-level access errors occurred when a
// classification job ran. For information about using logging data to investigate
// these errors, see Monitoring sensitive data discovery jobs
// (https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-monitor-cw-logs.html)
// in the Amazon Macie User Guide.
type LastRunErrorStatus struct {

	// Specifies whether any account- or bucket-level access errors occurred when the
	// job ran. For a recurring job, this value indicates the error status of the job's
	// most recent run. Possible values are:
	//
	// * ERROR - One or more errors occurred.
	// Amazon Macie didn't process all the data specified for the job.
	//
	// * NONE - No
	// errors occurred. Macie processed all the data specified for the job.
	Code LastRunErrorStatusCode

	noSmithyDocumentSerde
}

// Specifies criteria for filtering the results of a request for information about
// classification jobs.
type ListJobsFilterCriteria struct {

	// An array of objects, one for each condition that determines which jobs to
	// exclude from the results.
	Excludes []ListJobsFilterTerm

	// An array of objects, one for each condition that determines which jobs to
	// include in the results.
	Includes []ListJobsFilterTerm

	noSmithyDocumentSerde
}

// Specifies a condition that filters the results of a request for information
// about classification jobs. Each condition consists of a property, an operator,
// and one or more values.
type ListJobsFilterTerm struct {

	// The operator to use to filter the results.
	Comparator JobComparator

	// The property to use to filter the results.
	Key ListJobsFilterKey

	// An array that lists one or more values to use to filter the results.
	Values []string

	noSmithyDocumentSerde
}

// Specifies criteria for sorting the results of a request for information about
// classification jobs.
type ListJobsSortCriteria struct {

	// The property to sort the results by.
	AttributeName ListJobsSortAttributeName

	// The sort order to apply to the results, based on the value for the property
	// specified by the attributeName property. Valid values are: ASC, sort the results
	// in ascending order; and, DESC, sort the results in descending order.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// Provides information about a managed data identifier. For additional
// information, see Using managed data identifiers
// (https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html) in
// the Amazon Macie User Guide.
type ManagedDataIdentifierSummary struct {

	// The category of sensitive data that the managed data identifier detects:
	// CREDENTIALS, for credentials data such as private keys or Amazon Web Services
	// secret access keys; FINANCIAL_INFORMATION, for financial data such as credit
	// card numbers; or, PERSONAL_INFORMATION, for personal health information, such as
	// health insurance identification numbers, or personally identifiable information,
	// such as passport numbers.
	Category SensitiveDataItemCategory

	// The unique identifier for the managed data identifier. This is a string that
	// describes the type of sensitive data that the managed data identifier detects.
	// For example: OPENSSH_PRIVATE_KEY for OpenSSH private keys, CREDIT_CARD_NUMBER
	// for credit card numbers, or USA_PASSPORT_NUMBER for US passport numbers.
	Id *string

	noSmithyDocumentSerde
}

// Provides statistical data and other information about an S3 bucket that Amazon
// Macie monitors and analyzes for your account. If an error occurs when Macie
// attempts to retrieve and process information about the bucket or the bucket's
// objects, the value for most of these properties is null. Exceptions are
// accountId and bucketName. To identify the cause of the error, refer to the
// errorCode and errorMessage values.
type MatchingBucket struct {

	// The unique identifier for the Amazon Web Services account that owns the bucket.
	AccountId *string

	// The name of the bucket.
	BucketName *string

	// The total number of objects that Amazon Macie can analyze in the bucket. These
	// objects use a supported storage class and have a file name extension for a
	// supported file or storage format.
	ClassifiableObjectCount int64

	// The total storage size, in bytes, of the objects that Amazon Macie can analyze
	// in the bucket. These objects use a supported storage class and have a file name
	// extension for a supported file or storage format. If versioning is enabled for
	// the bucket, Macie calculates this value based on the size of the latest version
	// of each applicable object in the bucket. This value doesn't reflect the storage
	// size of all versions of each applicable object in the bucket.
	ClassifiableSizeInBytes int64

	// Specifies the error code for an error that prevented Amazon Macie from
	// retrieving and processing information about the bucket and the bucket's objects.
	// If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the
	// information. For example, the bucket has a restrictive bucket policy and Amazon
	// S3 denied the request. If this value is null, Macie was able to retrieve and
	// process the information.
	ErrorCode BucketMetadataErrorCode

	// A brief description of the error (errorCode) that prevented Amazon Macie from
	// retrieving and processing information about the bucket and the bucket's objects.
	// This value is null if Macie was able to retrieve and process the information.
	ErrorMessage *string

	// Specifies whether any one-time or recurring classification jobs are configured
	// to analyze objects in the bucket, and, if so, the details of the job that ran
	// most recently.
	JobDetails *JobDetails

	// The total number of objects in the bucket.
	ObjectCount int64

	// The total number of objects that are in the bucket, grouped by server-side
	// encryption type. This includes a grouping that reports the total number of
	// objects that aren't encrypted or use client-side encryption.
	ObjectCountByEncryptionType *ObjectCountByEncryptionType

	// The total storage size, in bytes, of the bucket. If versioning is enabled for
	// the bucket, Amazon Macie calculates this value based on the size of the latest
	// version of each object in the bucket. This value doesn't reflect the storage
	// size of all versions of each object in the bucket.
	SizeInBytes int64

	// The total storage size, in bytes, of the objects that are compressed (.gz,
	// .gzip, .zip) files in the bucket. If versioning is enabled for the bucket,
	// Amazon Macie calculates this value based on the size of the latest version of
	// each applicable object in the bucket. This value doesn't reflect the storage
	// size of all versions of each applicable object in the bucket.
	SizeInBytesCompressed int64

	// The total number of objects that Amazon Macie can't analyze in the bucket. These
	// objects don't use a supported storage class or don't have a file name extension
	// for a supported file or storage format.
	UnclassifiableObjectCount *ObjectLevelStatistics

	// The total storage size, in bytes, of the objects that Amazon Macie can't analyze
	// in the bucket. These objects don't use a supported storage class or don't have a
	// file name extension for a supported file or storage format.
	UnclassifiableObjectSizeInBytes *ObjectLevelStatistics

	noSmithyDocumentSerde
}

// Provides statistical data and other information about an Amazon Web Services
// resource that Amazon Macie monitors and analyzes for your account.
type MatchingResource struct {

	// The details of an S3 bucket that Amazon Macie monitors and analyzes.
	MatchingBucket *MatchingBucket

	noSmithyDocumentSerde
}

// Provides information about an account that's associated with an Amazon Macie
// administrator account.
type Member struct {

	// The Amazon Web Services account ID for the account.
	AccountId *string

	// The Amazon Web Services account ID for the administrator account.
	AdministratorAccountId *string

	// The Amazon Resource Name (ARN) of the account.
	Arn *string

	// The email address for the account.
	Email *string

	// The date and time, in UTC and extended ISO 8601 format, when an Amazon Macie
	// membership invitation was last sent to the account. This value is null if an
	// invitation hasn't been sent to the account.
	InvitedAt *time.Time

	// (Deprecated) The Amazon Web Services account ID for the administrator account.
	// This property has been replaced by the administratorAccountId property and is
	// retained only for backward compatibility.
	MasterAccountId *string

	// The current status of the relationship between the account and the administrator
	// account.
	RelationshipStatus RelationshipStatus

	// A map of key-value pairs that identifies the tags (keys and values) that are
	// associated with the account in Amazon Macie.
	Tags map[string]string

	// The date and time, in UTC and extended ISO 8601 format, of the most recent
	// change to the status of the relationship between the account and the
	// administrator account.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Specifies a monthly recurrence pattern for running a classification job.
type MonthlySchedule struct {

	// The numeric day of the month when Amazon Macie runs the job. This value can be
	// an integer from 1 through 31. If this value exceeds the number of days in a
	// certain month, Macie doesn't run the job that month. Macie runs the job only
	// during months that have the specified day. For example, if this value is 31 and
	// a month has only 30 days, Macie doesn't run the job that month. To run the job
	// every month, specify a value that's less than 29.
	DayOfMonth int32

	noSmithyDocumentSerde
}

// Provides information about the number of objects that are in an S3 bucket and
// use certain types of server-side encryption, use client-side encryption, or
// aren't encrypted.
type ObjectCountByEncryptionType struct {

	// The total number of objects that are encrypted with a customer-provided key. The
	// objects use customer-provided server-side encryption (SSE-C).
	CustomerManaged int64

	// The total number of objects that are encrypted with an KMS key, either an Amazon
	// Web Services managed key or a customer managed key. The objects use KMS
	// encryption (SSE-KMS).
	KmsManaged int64

	// The total number of objects that are encrypted with an Amazon S3 managed key.
	// The objects use Amazon S3 managed encryption (SSE-S3).
	S3Managed int64

	// The total number of objects that aren't encrypted or use client-side encryption.
	Unencrypted int64

	// The total number of objects that Amazon Macie doesn't have current encryption
	// metadata for. Macie can't provide current data about the encryption settings for
	// these objects.
	Unknown int64

	noSmithyDocumentSerde
}

// Provides information about the total storage size (in bytes) or number of
// objects that Amazon Macie can't analyze in one or more S3 buckets. In a
// BucketMetadata or MatchingBucket object, this data is for a specific bucket. In
// a GetBucketStatisticsResponse object, this data is aggregated for the buckets in
// the query results. If versioning is enabled for a bucket, total storage size
// values are based on the size of the latest version of each applicable object in
// the bucket.
type ObjectLevelStatistics struct {

	// The total storage size (in bytes) or number of objects that Amazon Macie can't
	// analyze because the objects don't have a file name extension for a supported
	// file or storage format.
	FileType int64

	// The total storage size (in bytes) or number of objects that Amazon Macie can't
	// analyze because the objects use an unsupported storage class.
	StorageClass int64

	// The total storage size (in bytes) or number of objects that Amazon Macie can't
	// analyze because the objects use an unsupported storage class or don't have a
	// file name extension for a supported file or storage format.
	Total int64

	noSmithyDocumentSerde
}

// Specifies the location of 1-15 occurrences of sensitive data that was detected
// by a managed data identifier or a custom data identifier and produced a
// sensitive data finding. Depending on the file or storage format of the affected
// S3 object, you can optionally retrieve (reveal) sample occurrences of the
// sensitive data that was detected.
type Occurrences struct {

	// An array of objects, one for each occurrence of sensitive data in a Microsoft
	// Excel workbook, CSV file, or TSV file. This value is null for all other types of
	// files.Each Cell object specifies a cell or field that contains the sensitive
	// data.
	Cells []Cell

	// An array of objects, one for each occurrence of sensitive data in a non-binary
	// text file, such as an HTML, TXT, or XML file. Each Range object specifies a line
	// or inclusive range of lines that contains the sensitive data, and the position
	// of the data on the specified line or lines. This value is often null for file
	// types that are supported by Cell, Page, or Record objects. Exceptions are the
	// location of sensitive data in: unstructured sections of an otherwise structured
	// file, such as a comment in a file; a malformed file that Amazon Macie analyzes
	// as plain text; and, a CSV or TSV file that has any column names that contain
	// sensitive data.
	LineRanges []Range

	// Reserved for future use.
	OffsetRanges []Range

	// An array of objects, one for each occurrence of sensitive data in an Adobe
	// Portable Document Format file. This value is null for all other types of
	// files.Each Page object specifies a page that contains the sensitive data.
	Pages []Page

	// An array of objects, one for each occurrence of sensitive data in an Apache Avro
	// object container, Apache Parquet file, JSON file, or JSON Lines file. This value
	// is null for all other types of files. For an Avro object container or Parquet
	// file, each Record object specifies a record index and the path to a field in a
	// record that contains the sensitive data. For a JSON or JSON Lines file, each
	// Record object specifies the path to a field or array that contains the sensitive
	// data. For a JSON Lines file, it also specifies the index of the line that
	// contains the data.
	Records []Record

	noSmithyDocumentSerde
}

// Specifies the location of an occurrence of sensitive data in an Adobe Portable
// Document Format file.
type Page struct {

	// Reserved for future use.
	LineRange *Range

	// Reserved for future use.
	OffsetRange *Range

	// The page number of the page that contains the sensitive data.
	PageNumber int64

	noSmithyDocumentSerde
}

// Provides the details of a policy finding.
type PolicyDetails struct {

	// The action that produced the finding.
	Action *FindingAction

	// The entity that performed the action that produced the finding.
	Actor *FindingActor

	noSmithyDocumentSerde
}

// Specifies the location of an occurrence of sensitive data in a non-binary text
// file, such as an HTML, TXT, or XML file.
type Range struct {

	// The number of lines from the beginning of the file to the end of the sensitive
	// data.
	End int64

	// The number of lines from the beginning of the file to the beginning of the
	// sensitive data.
	Start int64

	// The number of characters, with spaces and starting from 1, from the beginning of
	// the first line that contains the sensitive data (start) to the beginning of the
	// sensitive data.
	StartColumn int64

	noSmithyDocumentSerde
}

// Specifies the location of an occurrence of sensitive data in an Apache Avro
// object container, Apache Parquet file, JSON file, or JSON Lines file.
type Record struct {

	// The path, as a JSONPath expression, to the sensitive data. For an Avro object
	// container or Parquet file, this is the path to the field in the record
	// (recordIndex) that contains the data. For a JSON or JSON Lines file, this is the
	// path to the field or array that contains the data. If the data is a value in an
	// array, the path also indicates which value contains the data. If Amazon Macie
	// detects sensitive data in the name of any element in the path, Macie omits this
	// field. If the name of an element exceeds 20 characters, Macie truncates the name
	// by removing characters from the beginning of the name. If the resulting full
	// path exceeds 250 characters, Macie also truncates the path, starting with the
	// first element in the path, until the path contains 250 or fewer characters.
	JsonPath *string

	// For an Avro object container or Parquet file, the record index, starting from 0,
	// for the record that contains the sensitive data. For a JSON Lines file, the line
	// index, starting from 0, for the line that contains the sensitive data. This
	// value is always 0 for JSON files.
	RecordIndex int64

	noSmithyDocumentSerde
}

// Provides information about settings that define whether one or more objects in
// an S3 bucket are replicated to S3 buckets for other Amazon Web Services accounts
// and, if so, which accounts.
type ReplicationDetails struct {

	// Specifies whether the bucket is configured to replicate one or more objects to
	// any destination.
	Replicated bool

	// Specifies whether the bucket is configured to replicate one or more objects to
	// an Amazon Web Services account that isn't part of the same Amazon Macie
	// organization.
	ReplicatedExternally bool

	// An array of Amazon Web Services account IDs, one for each Amazon Web Services
	// account that the bucket is configured to replicate one or more objects to.
	ReplicationAccounts []string

	noSmithyDocumentSerde
}

// Provides information about the resources that a finding applies to.
type ResourcesAffected struct {

	// The details of the S3 bucket that the finding applies to.
	S3Bucket *S3Bucket

	// The details of the S3 object that the finding applies to.
	S3Object *S3Object

	noSmithyDocumentSerde
}

// Specifies the configuration settings for retrieving occurrences of sensitive
// data reported by findings, and the status of the configuration for an Amazon
// Macie account. When you enable the configuration for the first time, your
// request must specify an AWS Key Management Service (AWS KMS) key. Otherwise, an
// error occurs. Macie uses the specified key to encrypt the sensitive data that
// you retrieve.
type RevealConfiguration struct {

	// The status of the configuration for the Amazon Macie account. In a request,
	// valid values are: ENABLED, enable the configuration for the account; and,
	// DISABLED, disable the configuration for the account. In a response, possible
	// values are: ENABLED, the configuration is currently enabled for the account;
	// and, DISABLED, the configuration is currently disabled for the account.
	//
	// This member is required.
	Status RevealStatus

	// The Amazon Resource Name (ARN), ID, or alias of the KMS key to use to encrypt
	// sensitive data that's retrieved. The key must be an existing, customer managed,
	// symmetric encryption key that's in the same Amazon Web Services Region as the
	// Amazon Macie account. If this value specifies an alias, it must include the
	// following prefix: alias/. If this value specifies a key that's owned by another
	// Amazon Web Services account, it must specify the ARN of the key or the ARN of
	// the key's alias.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Provides information about the S3 bucket that a finding applies to.
type S3Bucket struct {

	// Specifies whether the bucket policy for the bucket requires server-side
	// encryption of objects when objects are uploaded to the bucket. Possible values
	// are:
	//
	// * FALSE - The bucket policy requires server-side encryption of new
	// objects. PutObject requests must include the x-amz-server-side-encryption header
	// and the value for that header must be AES256 or aws:kms.
	//
	// * TRUE - The bucket
	// doesn't have a bucket policy or it has a bucket policy that doesn't require
	// server-side encryption of new objects. If a bucket policy exists, it doesn't
	// require PutObject requests to include the x-amz-server-side-encryption header
	// and it doesn't require the value for that header to be AES256 or aws:kms.
	//
	// *
	// UNKNOWN - Amazon Macie can't determine whether the bucket policy requires
	// server-side encryption of objects.
	AllowsUnencryptedObjectUploads AllowsUnencryptedObjectUploads

	// The Amazon Resource Name (ARN) of the bucket.
	Arn *string

	// The date and time, in UTC and extended ISO 8601 format, when the bucket was
	// created.
	CreatedAt *time.Time

	// The type of server-side encryption that's used by default to encrypt objects in
	// the bucket.
	DefaultServerSideEncryption *ServerSideEncryption

	// The name of the bucket.
	Name *string

	// The display name and canonical user ID for the Amazon Web Services account that
	// owns the bucket.
	Owner *S3BucketOwner

	// The permissions settings that determine whether the bucket is publicly
	// accessible.
	PublicAccess *BucketPublicAccess

	// The tags that are associated with the bucket.
	Tags []KeyValuePair

	noSmithyDocumentSerde
}

// Specifies property- and tag-based conditions that define criteria for including
// or excluding S3 buckets from a classification job. Exclude conditions take
// precedence over include conditions.
type S3BucketCriteriaForJob struct {

	// The property- and tag-based conditions that determine which buckets to exclude
	// from the job.
	Excludes *CriteriaBlockForJob

	// The property- and tag-based conditions that determine which buckets to include
	// in the job.
	Includes *CriteriaBlockForJob

	noSmithyDocumentSerde
}

// Specifies an Amazon Web Services account that owns S3 buckets for a
// classification job to analyze, and one or more specific buckets to analyze for
// that account.
type S3BucketDefinitionForJob struct {

	// The unique identifier for the Amazon Web Services account that owns the buckets.
	//
	// This member is required.
	AccountId *string

	// An array that lists the names of the buckets.
	//
	// This member is required.
	Buckets []string

	noSmithyDocumentSerde
}

// Provides information about the Amazon Web Services account that owns an S3
// bucket.
type S3BucketOwner struct {

	// The display name of the account that owns the bucket.
	DisplayName *string

	// The canonical user ID for the account that owns the bucket.
	Id *string

	noSmithyDocumentSerde
}

// Specifies an S3 bucket to store data classification results in, and the
// encryption settings to use when storing results in that bucket.
type S3Destination struct {

	// The name of the bucket.
	//
	// This member is required.
	BucketName *string

	// The Amazon Resource Name (ARN) of the customer managed KMS key to use for
	// encryption of the results. This must be the ARN of an existing, symmetric
	// encryption KMS key that's in the same Amazon Web Services Region as the bucket.
	//
	// This member is required.
	KmsKeyArn *string

	// The path prefix to use in the path to the location in the bucket. This prefix
	// specifies where to store classification results in the bucket.
	KeyPrefix *string

	noSmithyDocumentSerde
}

// Specifies which S3 buckets contain the objects that a classification job
// analyzes, and the scope of that analysis. The bucket specification can be static
// (bucketDefinitions) or dynamic (bucketCriteria). If it's static, the job
// analyzes objects in the same predefined set of buckets each time the job runs.
// If it's dynamic, the job analyzes objects in any buckets that match the
// specified criteria each time the job starts to run.
type S3JobDefinition struct {

	// The property- and tag-based conditions that determine which S3 buckets to
	// include or exclude from the analysis. Each time the job runs, the job uses these
	// criteria to determine which buckets contain objects to analyze. A job's
	// definition can contain a bucketCriteria object or a bucketDefinitions array, not
	// both.
	BucketCriteria *S3BucketCriteriaForJob

	// An array of objects, one for each Amazon Web Services account that owns specific
	// S3 buckets to analyze. Each object specifies the account ID for an account and
	// one or more buckets to analyze for that account. A job's definition can contain
	// a bucketDefinitions array or a bucketCriteria object, not both.
	BucketDefinitions []S3BucketDefinitionForJob

	// The property- and tag-based conditions that determine which S3 objects to
	// include or exclude from the analysis. Each time the job runs, the job uses these
	// criteria to determine which objects to analyze.
	Scoping *Scoping

	noSmithyDocumentSerde
}

// Provides information about the S3 object that a finding applies to.
type S3Object struct {

	// The Amazon Resource Name (ARN) of the bucket that contains the object.
	BucketArn *string

	// The entity tag (ETag) that identifies the affected version of the object. If the
	// object was overwritten or changed after Amazon Macie produced the finding, this
	// value might be different from the current ETag for the object.
	ETag *string

	// The file name extension of the object. If the object doesn't have a file name
	// extension, this value is "".
	Extension *string

	// The full key (name) that's assigned to the object.
	Key *string

	// The date and time, in UTC and extended ISO 8601 format, when the object was last
	// modified.
	LastModified *time.Time

	// The path to the object, including the full key (name).
	Path *string

	// Specifies whether the object is publicly accessible due to the combination of
	// permissions settings that apply to the object.
	PublicAccess bool

	// The type of server-side encryption that's used to encrypt the object.
	ServerSideEncryption *ServerSideEncryption

	// The total storage size, in bytes, of the object.
	Size int64

	// The storage class of the object.
	StorageClass StorageClass

	// The tags that are associated with the object.
	Tags []KeyValuePair

	// The identifier for the affected version of the object.
	VersionId *string

	noSmithyDocumentSerde
}

// Specifies one or more property- and tag-based conditions that define criteria
// for including or excluding S3 objects from a classification job. Exclude
// conditions take precedence over include conditions.
type Scoping struct {

	// The property- and tag-based conditions that determine which objects to exclude
	// from the analysis.
	Excludes *JobScopingBlock

	// The property- and tag-based conditions that determine which objects to include
	// in the analysis.
	Includes *JobScopingBlock

	noSmithyDocumentSerde
}

// Specifies property- and tag-based conditions that define filter criteria for
// including or excluding S3 buckets from the query results. Exclude conditions
// take precedence over include conditions.
type SearchResourcesBucketCriteria struct {

	// The property- and tag-based conditions that determine which buckets to exclude
	// from the results.
	Excludes *SearchResourcesCriteriaBlock

	// The property- and tag-based conditions that determine which buckets to include
	// in the results.
	Includes *SearchResourcesCriteriaBlock

	noSmithyDocumentSerde
}

// Specifies a property- or tag-based filter condition for including or excluding
// Amazon Web Services resources from the query results.
type SearchResourcesCriteria struct {

	// A property-based condition that defines a property, operator, and one or more
	// values for including or excluding resources from the results.
	SimpleCriterion *SearchResourcesSimpleCriterion

	// A tag-based condition that defines an operator and tag keys, tag values, or tag
	// key and value pairs for including or excluding resources from the results.
	TagCriterion *SearchResourcesTagCriterion

	noSmithyDocumentSerde
}

// Specifies property- and tag-based conditions that define filter criteria for
// including or excluding Amazon Web Services resources from the query results.
type SearchResourcesCriteriaBlock struct {

	// An array of objects, one for each property- or tag-based condition that includes
	// or excludes resources from the query results. If you specify more than one
	// condition, Amazon Macie uses AND logic to join the conditions.
	And []SearchResourcesCriteria

	noSmithyDocumentSerde
}

// Specifies a property-based filter condition that determines which Amazon Web
// Services resources are included or excluded from the query results.
type SearchResourcesSimpleCriterion struct {

	// The operator to use in the condition. Valid values are EQ (equals) and NE (not
	// equals).
	Comparator SearchResourcesComparator

	// The property to use in the condition.
	Key SearchResourcesSimpleCriterionKey

	// An array that lists one or more values to use in the condition. If you specify
	// multiple values, Amazon Macie uses OR logic to join the values. Valid values for
	// each supported property (key) are:
	//
	// * ACCOUNT_ID - A string that represents the
	// unique identifier for the Amazon Web Services account that owns the resource.
	//
	// *
	// S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value
	// that Macie defines for the BucketPublicAccess.effectivePermission
	// (https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission)
	// property of an S3 bucket.
	//
	// * S3_BUCKET_NAME - A string that represents the name
	// of an S3 bucket.
	//
	// * S3_BUCKET_SHARED_ACCESS - A string that represents an
	// enumerated value that Macie defines for the BucketMetadata.sharedAccess
	// (https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess)
	// property of an S3 bucket.
	//
	// Values are case sensitive. Also, Macie doesn't
	// support use of partial values or wildcard characters in values.
	Values []string

	noSmithyDocumentSerde
}

// Specifies criteria for sorting the results of a query for information about
// Amazon Web Services resources that Amazon Macie monitors and analyzes.
type SearchResourcesSortCriteria struct {

	// The property to sort the results by.
	AttributeName SearchResourcesSortAttributeName

	// The sort order to apply to the results, based on the value for the property
	// specified by the attributeName property. Valid values are: ASC, sort the results
	// in ascending order; and, DESC, sort the results in descending order.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// Specifies a tag-based filter condition that determines which Amazon Web Services
// resources are included or excluded from the query results.
type SearchResourcesTagCriterion struct {

	// The operator to use in the condition. Valid values are EQ (equals) and NE (not
	// equals).
	Comparator SearchResourcesComparator

	// The tag keys, tag values, or tag key and value pairs to use in the condition.
	TagValues []SearchResourcesTagCriterionPair

	noSmithyDocumentSerde
}

// Specifies a tag key, a tag value, or a tag key and value (as a pair) to use in a
// tag-based filter condition for a query. Tag keys and values are case sensitive.
// Also, Amazon Macie doesn't support use of partial values or wildcard characters
// in tag-based filter conditions.
type SearchResourcesTagCriterionPair struct {

	// The value for the tag key to use in the condition.
	Key *string

	// The tag value to use in the condition.
	Value *string

	noSmithyDocumentSerde
}

// Specifies configuration settings that determine which findings are published to
// Security Hub automatically. For information about how Macie publishes findings
// to Security Hub, see Amazon Macie integration with Security Hub
// (https://docs.aws.amazon.com/macie/latest/user/securityhub-integration.html) in
// the Amazon Macie User Guide.
type SecurityHubConfiguration struct {

	// Specifies whether to publish sensitive data findings to Security Hub. If you set
	// this value to true, Amazon Macie automatically publishes all sensitive data
	// findings that weren't suppressed by a findings filter. The default value is
	// false.
	//
	// This member is required.
	PublishClassificationFindings bool

	// Specifies whether to publish policy findings to Security Hub. If you set this
	// value to true, Amazon Macie automatically publishes all new and updated policy
	// findings that weren't suppressed by a findings filter. The default value is
	// true.
	//
	// This member is required.
	PublishPolicyFindings bool

	noSmithyDocumentSerde
}

// Provides information about the category, types, and occurrences of sensitive
// data that produced a sensitive data finding.
type SensitiveDataItem struct {

	// The category of sensitive data that was detected. For example: CREDENTIALS, for
	// credentials data such as private keys or Amazon Web Services secret access keys;
	// FINANCIAL_INFORMATION, for financial data such as credit card numbers; or,
	// PERSONAL_INFORMATION, for personal health information, such as health insurance
	// identification numbers, or personally identifiable information, such as passport
	// numbers.
	Category SensitiveDataItemCategory

	// An array of objects, one for each type of sensitive data that was detected. Each
	// object reports the number of occurrences of a specific type of sensitive data
	// that was detected, and the location of up to 15 of those occurrences.
	Detections []DefaultDetection

	// The total number of occurrences of the sensitive data that was detected.
	TotalCount int64

	noSmithyDocumentSerde
}

// Provides information about the server-side encryption settings for an S3 bucket
// or S3 object.
type ServerSideEncryption struct {

	// The server-side encryption algorithm that's used when storing data in the bucket
	// or object. If default encryption is disabled for the bucket or the object isn't
	// encrypted using server-side encryption, this value is NONE.
	EncryptionType EncryptionType

	// The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key
	// that's used to encrypt data in the bucket or the object. This value is null if
	// an KMS key isn't used to encrypt the data.
	KmsMasterKeyId *string

	noSmithyDocumentSerde
}

// Specifies a current quota for an Amazon Macie account.
type ServiceLimit struct {

	// Specifies whether the account has met the quota that corresponds to the metric
	// specified by the UsageByAccount.type field in the response.
	IsServiceLimited bool

	// The unit of measurement for the value specified by the value field.
	Unit Unit

	// The value for the metric specified by the UsageByAccount.type field in the
	// response.
	Value int64

	noSmithyDocumentSerde
}

// Provides information about a session that was created for an entity that
// performed an action by using temporary security credentials.
type SessionContext struct {

	// The date and time when the credentials were issued, and whether the credentials
	// were authenticated with a multi-factor authentication (MFA) device.
	Attributes *SessionContextAttributes

	// The source and type of credentials that were issued to the entity.
	SessionIssuer *SessionIssuer

	noSmithyDocumentSerde
}

// Provides information about the context in which temporary security credentials
// were issued to an entity.
type SessionContextAttributes struct {

	// The date and time, in UTC and ISO 8601 format, when the credentials were issued.
	CreationDate *time.Time

	// Specifies whether the credentials were authenticated with a multi-factor
	// authentication (MFA) device.
	MfaAuthenticated bool

	noSmithyDocumentSerde
}

// Provides information about the source and type of temporary security credentials
// that were issued to an entity.
type SessionIssuer struct {

	// The unique identifier for the Amazon Web Services account that owns the entity
	// that was used to get the credentials.
	AccountId *string

	// The Amazon Resource Name (ARN) of the source account, IAM user, or role that was
	// used to get the credentials.
	Arn *string

	// The unique identifier for the entity that was used to get the credentials.
	PrincipalId *string

	// The source of the temporary security credentials, such as Root, IAMUser, or
	// Role.
	Type *string

	// The name or alias of the user or role that issued the session. This value is
	// null if the credentials were obtained from a root account that doesn't have an
	// alias.
	UserName *string

	noSmithyDocumentSerde
}

// Provides the numerical and qualitative representations of a finding's severity.
type Severity struct {

	// The qualitative representation of the finding's severity, ranging from Low
	// (least severe) to High (most severe).
	Description SeverityDescription

	// The numerical representation of the finding's severity, ranging from 1 (least
	// severe) to 3 (most severe).
	Score int64

	noSmithyDocumentSerde
}

// Specifies a severity level for findings that a custom data identifier produces.
// A severity level determines which severity is assigned to the findings, based on
// the number of occurrences of text that matches the custom data identifier's
// detection criteria.
type SeverityLevel struct {

	// The minimum number of occurrences of text that must match the custom data
	// identifier's detection criteria in order to produce a finding with the specified
	// severity (severity).
	//
	// This member is required.
	OccurrencesThreshold int64

	// The severity to assign to a finding: if the number of occurrences is greater
	// than or equal to the specified threshold (occurrencesThreshold); and, if
	// applicable, the number of occurrences is less than the threshold for the next
	// consecutive severity level for the custom data identifier, moving from LOW to
	// HIGH.
	//
	// This member is required.
	Severity DataIdentifierSeverity

	noSmithyDocumentSerde
}

// Specifies a property-based condition that determines whether an S3 bucket is
// included or excluded from a classification job.
type SimpleCriterionForJob struct {

	// The operator to use in the condition. Valid values are EQ (equals) and NE (not
	// equals).
	Comparator JobComparator

	// The property to use in the condition.
	Key SimpleCriterionKeyForJob

	// An array that lists one or more values to use in the condition. If you specify
	// multiple values, Amazon Macie uses OR logic to join the values. Valid values for
	// each supported property (key) are:
	//
	// * ACCOUNT_ID - A string that represents the
	// unique identifier for the Amazon Web Services account that owns the bucket.
	//
	// *
	// S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value
	// that Macie defines for the BucketPublicAccess.effectivePermission
	// (https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission)
	// property of a bucket.
	//
	// * S3_BUCKET_NAME - A string that represents the name of a
	// bucket.
	//
	// * S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated
	// value that Macie defines for the BucketMetadata.sharedAccess
	// (https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess)
	// property of a bucket.
	//
	// Values are case sensitive. Also, Macie doesn't support
	// use of partial values or wildcard characters in these values.
	Values []string

	noSmithyDocumentSerde
}

// Specifies a property-based condition that determines whether an S3 object is
// included or excluded from a classification job.
type SimpleScopeTerm struct {

	// The operator to use in the condition. Valid values for each supported property
	// (key) are:
	//
	// * OBJECT_EXTENSION - EQ (equals) or NE (not equals)
	//
	// * OBJECT_KEY -
	// STARTS_WITH
	//
	// * OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS
	//
	// *
	// OBJECT_SIZE - Any operator except CONTAINS
	Comparator JobComparator

	// The object property to use in the condition.
	Key ScopeFilterKey

	// An array that lists the values to use in the condition. If the value for the key
	// property is OBJECT_EXTENSION or OBJECT_KEY, this array can specify multiple
	// values and Amazon Macie uses OR logic to join the values. Otherwise, this array
	// can specify only one value. Valid values for each supported property (key)
	// are:
	//
	// * OBJECT_EXTENSION - A string that represents the file name extension of
	// an object. For example: docx or pdf
	//
	// * OBJECT_KEY - A string that represents the
	// key prefix (folder name or path) of an object. For example: logs or
	// awslogs/eventlogs. This value applies a condition to objects whose keys (names)
	// begin with the specified value.
	//
	// * OBJECT_LAST_MODIFIED_DATE - The date and time
	// (in UTC and extended ISO 8601 format) when an object was created or last
	// changed, whichever is latest. For example: 2020-09-28T14:31:13Z
	//
	// * OBJECT_SIZE -
	// An integer that represents the storage size (in bytes) of an object.
	//
	// Macie
	// doesn't support use of wildcard characters in these values. Also, string values
	// are case sensitive.
	Values []string

	noSmithyDocumentSerde
}

// Specifies criteria for sorting the results of a request for findings.
type SortCriteria struct {

	// The name of the property to sort the results by. This value can be the name of
	// any property that Amazon Macie defines for a finding.
	AttributeName *string

	// The sort order to apply to the results, based on the value for the property
	// specified by the attributeName property. Valid values are: ASC, sort the results
	// in ascending order; and, DESC, sort the results in descending order.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// Provides processing statistics for a classification job.
type Statistics struct {

	// The approximate number of objects that the job has yet to process during its
	// current run.
	ApproximateNumberOfObjectsToProcess float64

	// The number of times that the job has run.
	NumberOfRuns float64

	noSmithyDocumentSerde
}

// Specifies a tag-based condition that determines whether an S3 bucket is included
// or excluded from a classification job.
type TagCriterionForJob struct {

	// The operator to use in the condition. Valid values are EQ (equals) and NE (not
	// equals).
	Comparator JobComparator

	// The tag keys, tag values, or tag key and value pairs to use in the condition.
	TagValues []TagCriterionPairForJob

	noSmithyDocumentSerde
}

// Specifies a tag key, a tag value, or a tag key and value (as a pair) to use in a
// tag-based condition that determines whether an S3 bucket is included or excluded
// from a classification job. Tag keys and values are case sensitive. Also, Amazon
// Macie doesn't support use of partial values or wildcard characters in tag-based
// conditions.
type TagCriterionPairForJob struct {

	// The value for the tag key to use in the condition.
	Key *string

	// The tag value to use in the condition.
	Value *string

	noSmithyDocumentSerde
}

// Specifies a tag-based condition that determines whether an S3 object is included
// or excluded from a classification job.
type TagScopeTerm struct {

	// The operator to use in the condition. Valid values are EQ (equals) or NE (not
	// equals).
	Comparator JobComparator

	// The object property to use in the condition. The only valid value is TAG.
	Key *string

	// The tag keys or tag key and value pairs to use in the condition. To specify only
	// tag keys in a condition, specify the keys in this array and set the value for
	// each associated tag value to an empty string.
	TagValues []TagValuePair

	// The type of object to apply the condition to.
	Target TagTarget

	noSmithyDocumentSerde
}

// Specifies a tag key or tag key and value pair to use in a tag-based condition
// that determines whether an S3 object is included or excluded from a
// classification job. Tag keys and values are case sensitive. Also, Amazon Macie
// doesn't support use of partial values or wildcard characters in tag-based
// conditions.
type TagValuePair struct {

	// The value for the tag key to use in the condition.
	Key *string

	// The tag value, associated with the specified tag key (key), to use in the
	// condition. To specify only a tag key for a condition, specify the tag key for
	// the key property and set this value to an empty string.
	Value *string

	noSmithyDocumentSerde
}

// Provides information about an account-related request that hasn't been
// processed.
type UnprocessedAccount struct {

	// The Amazon Web Services account ID for the account that the request applies to.
	AccountId *string

	// The source of the issue or delay in processing the request.
	ErrorCode ErrorCode

	// The reason why the request hasn't been processed.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Provides data for a specific usage metric and the corresponding quota for an
// Amazon Macie account.
type UsageByAccount struct {

	// The type of currency that the value for the metric (estimatedCost) is reported
	// in.
	Currency Currency

	// The estimated value for the metric.
	EstimatedCost *string

	// The current value for the quota that corresponds to the metric specified by the
	// type field.
	ServiceLimit *ServiceLimit

	// The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for
	// monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects
	// to detect sensitive data.
	Type UsageType

	noSmithyDocumentSerde
}

// Provides quota and aggregated usage data for an Amazon Macie account.
type UsageRecord struct {

	// The unique identifier for the Amazon Web Services account that the data applies
	// to.
	AccountId *string

	// The date and time, in UTC and extended ISO 8601 format, when the free trial
	// started for the account.
	FreeTrialStartDate *time.Time

	// An array of objects that contains usage data and quotas for the account. Each
	// object contains the data for a specific usage metric and the corresponding
	// quota.
	Usage []UsageByAccount

	noSmithyDocumentSerde
}

// Specifies a condition for filtering the results of a query for quota and usage
// data for one or more Amazon Macie accounts.
type UsageStatisticsFilter struct {

	// The operator to use in the condition. If the value for the key property is
	// accountId, this value must be CONTAINS. If the value for the key property is any
	// other supported field, this value can be EQ, GT, GTE, LT, LTE, or NE.
	Comparator UsageStatisticsFilterComparator

	// The field to use in the condition.
	Key UsageStatisticsFilterKey

	// An array that lists values to use in the condition, based on the value for the
	// field specified by the key property. If the value for the key property is
	// accountId, this array can specify multiple values. Otherwise, this array can
	// specify only one value. Valid values for each supported field are:
	//
	// * accountId
	// - The unique identifier for an Amazon Web Services account.
	//
	// *
	// freeTrialStartDate - The date and time, in UTC and extended ISO 8601 format,
	// when the free trial started for an account.
	//
	// * serviceLimit - A Boolean (true or
	// false) value that indicates whether an account has reached its monthly quota.
	//
	// *
	// total - A string that represents the current estimated cost for an account.
	Values []string

	noSmithyDocumentSerde
}

// Specifies criteria for sorting the results of a query for Amazon Macie account
// quotas and usage data.
type UsageStatisticsSortBy struct {

	// The field to sort the results by.
	Key UsageStatisticsSortKey

	// The sort order to apply to the results, based on the value for the field
	// specified by the key property. Valid values are: ASC, sort the results in
	// ascending order; and, DESC, sort the results in descending order.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// Provides aggregated data for an Amazon Macie usage metric. The value for the
// metric reports estimated usage data for an account for the preceding 30 days or
// the current calendar month to date, depending on the time period (timeRange)
// specified in the request.
type UsageTotal struct {

	// The type of currency that the value for the metric (estimatedCost) is reported
	// in.
	Currency Currency

	// The estimated value for the metric.
	EstimatedCost *string

	// The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for
	// monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects
	// to detect sensitive data.
	Type UsageType

	noSmithyDocumentSerde
}

// Provides information about the type and other characteristics of an entity that
// performed an action on an affected resource.
type UserIdentity struct {

	// If the action was performed with temporary security credentials that were
	// obtained using the AssumeRole operation of the Security Token Service (STS) API,
	// the identifiers, session context, and other details about the identity.
	AssumedRole *AssumedRole

	// If the action was performed using the credentials for another Amazon Web
	// Services account, the details of that account.
	AwsAccount *AwsAccount

	// If the action was performed by an Amazon Web Services account that belongs to an
	// Amazon Web Service, the name of the service.
	AwsService *AwsService

	// If the action was performed with temporary security credentials that were
	// obtained using the GetFederationToken operation of the Security Token Service
	// (STS) API, the identifiers, session context, and other details about the
	// identity.
	FederatedUser *FederatedUser

	// If the action was performed using the credentials for an Identity and Access
	// Management (IAM) user, the name and other details about the user.
	IamUser *IamUser

	// If the action was performed using the credentials for your Amazon Web Services
	// account, the details of your account.
	Root *UserIdentityRoot

	// The type of entity that performed the action.
	Type UserIdentityType

	noSmithyDocumentSerde
}

// Provides information about an Amazon Web Services account and entity that
// performed an action on an affected resource. The action was performed using the
// credentials for your Amazon Web Services account.
type UserIdentityRoot struct {

	// The unique identifier for the Amazon Web Services account.
	AccountId *string

	// The Amazon Resource Name (ARN) of the principal that performed the action. The
	// last section of the ARN contains the name of the user or role that performed the
	// action.
	Arn *string

	// The unique identifier for the entity that performed the action.
	PrincipalId *string

	noSmithyDocumentSerde
}

// Provides information about when a classification job was paused. For a one-time
// job, this object also specifies when the job will expire and be cancelled if it
// isn't resumed. For a recurring job, this object also specifies when the paused
// job run will expire and be cancelled if it isn't resumed. This object is present
// only if a job's current status (jobStatus) is USER_PAUSED. The information in
// this object applies only to a job that was paused while it had a status of
// RUNNING.
type UserPausedDetails struct {

	// The date and time, in UTC and extended ISO 8601 format, when the job or job run
	// will expire and be cancelled if you don't resume it first.
	JobExpiresAt *time.Time

	// The Amazon Resource Name (ARN) of the Health event that Amazon Macie sent to
	// notify you of the job or job run's pending expiration and cancellation. This
	// value is null if a job has been paused for less than 23 days.
	JobImminentExpirationHealthEventArn *string

	// The date and time, in UTC and extended ISO 8601 format, when you paused the job.
	JobPausedAt *time.Time

	noSmithyDocumentSerde
}

// Specifies a weekly recurrence pattern for running a classification job.
type WeeklySchedule struct {

	// The day of the week when Amazon Macie runs the job.
	DayOfWeek DayOfWeek

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
