// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates some of the parameters of a previously created location for self-managed
// object storage server access. For information about creating a self-managed
// object storage location, see Creating a location for object storage
// (https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html).
func (c *Client) UpdateLocationObjectStorage(ctx context.Context, params *UpdateLocationObjectStorageInput, optFns ...func(*Options)) (*UpdateLocationObjectStorageOutput, error) {
	if params == nil {
		params = &UpdateLocationObjectStorageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateLocationObjectStorage", params, optFns, c.addOperationUpdateLocationObjectStorageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateLocationObjectStorageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateLocationObjectStorageInput struct {

	// The Amazon Resource Name (ARN) of the self-managed object storage server
	// location to be updated.
	//
	// This member is required.
	LocationArn *string

	// Optional. The access key is used if credentials are required to access the
	// self-managed object storage server. If your object storage requires a user name
	// and password to authenticate, use AccessKey and SecretKey to provide the user
	// name and password, respectively.
	AccessKey *string

	// The Amazon Resource Name (ARN) of the agents associated with the self-managed
	// object storage server location.
	AgentArns []string

	// Optional. The secret key is used if credentials are required to access the
	// self-managed object storage server. If your object storage requires a user name
	// and password to authenticate, use AccessKey and SecretKey to provide the user
	// name and password, respectively.
	SecretKey *string

	// The port that your self-managed object storage server accepts inbound network
	// traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443
	// (HTTPS). You can specify a custom port if your self-managed object storage
	// server requires one.
	ServerPort *int32

	// The protocol that the object storage server uses to communicate. Valid values
	// are HTTP or HTTPS.
	ServerProtocol types.ObjectStorageServerProtocol

	// The subdirectory in the self-managed object storage server that is used to read
	// data from.
	Subdirectory *string

	noSmithyDocumentSerde
}

type UpdateLocationObjectStorageOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateLocationObjectStorageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateLocationObjectStorage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateLocationObjectStorage{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateLocationObjectStorageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateLocationObjectStorage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateLocationObjectStorage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "datasync",
		OperationName: "UpdateLocationObjectStorage",
	}
}
