// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The configuration for the artifacts.
type ArtifactsConfiguration struct {

	// The configuration for the audio artifacts.
	//
	// This member is required.
	Audio *AudioArtifactsConfiguration

	// The configuration for the content artifacts.
	//
	// This member is required.
	Content *ContentArtifactsConfiguration

	// The configuration for the video artifacts.
	//
	// This member is required.
	Video *VideoArtifactsConfiguration

	noSmithyDocumentSerde
}

// The audio artifact configuration object.
type AudioArtifactsConfiguration struct {

	// The MUX type of the audio artifact configuration object.
	//
	// This member is required.
	MuxType AudioMuxType

	noSmithyDocumentSerde
}

// The configuration object of the Amazon Chime SDK meeting for a specified media
// capture pipeline. SourceType must be ChimeSdkMeeting.
type ChimeSdkMeetingConfiguration struct {

	// The configuration for the artifacts in an Amazon Chime SDK meeting.
	ArtifactsConfiguration *ArtifactsConfiguration

	// The source configuration for a specified media capture pipline.
	SourceConfiguration *SourceConfiguration

	noSmithyDocumentSerde
}

// The content artifact object.
type ContentArtifactsConfiguration struct {

	// Indicates whether the content artifact is enabled or disabled.
	//
	// This member is required.
	State ArtifactsState

	// The MUX type of the artifact configuration.
	MuxType ContentMuxType

	noSmithyDocumentSerde
}

// A media capture pipeline object consisting of an ID, source type, source ARN, a
// sink type, a sink ARN, and a configuration object.
type MediaCapturePipeline struct {

	// The configuration for a specified media capture pipeline. SourceType must be
	// ChimeSdkMeeting.
	ChimeSdkMeetingConfiguration *ChimeSdkMeetingConfiguration

	// The time at which the capture pipeline was created, in ISO 8601 format.
	CreatedTimestamp *time.Time

	// The ARN of a media capture pipeline.
	MediaPipelineArn *string

	// The ID of a media capture pipeline.
	MediaPipelineId *string

	// ARN of the destination to which the media artifacts are saved.
	SinkArn *string

	// Destination type to which the media artifacts are saved. You must use an S3
	// Bucket.
	SinkType MediaPipelineSinkType

	// ARN of the source from which the media artifacts are saved.
	SourceArn *string

	// Source type from which media artifacts are saved. You must use ChimeMeeting.
	SourceType MediaPipelineSourceType

	// The status of the media capture pipeline.
	Status MediaPipelineStatus

	// The time at which the capture pipeline was updated, in ISO 8601 format.
	UpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// A summary of a media capture pipeline.
type MediaCapturePipelineSummary struct {

	// The ARN of a media capture pipeline.
	MediaPipelineArn *string

	// The ID of a media capture pipeline.
	MediaPipelineId *string

	noSmithyDocumentSerde
}

// The video streams to capture for a specified media capture pipeline. The total
// number of video streams can't exceed 25.
type SelectedVideoStreams struct {

	// The attendee IDs of the streams selected for a media capture pipeline.
	AttendeeIds []string

	// The external user IDs of the streams selected for a media capture pipeline.
	ExternalUserIds []string

	noSmithyDocumentSerde
}

// Source configuration for a specified media capture pipeline.
type SourceConfiguration struct {

	// The selected video streams to capture for a specified media capture pipeline.
	// The number of video streams can't exceed 25.
	SelectedVideoStreams *SelectedVideoStreams

	noSmithyDocumentSerde
}

// Describes a tag applied to a resource.
type Tag struct {

	// The key of the tag.
	//
	// This member is required.
	Key *string

	// The value of the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The video artifact configuration object.
type VideoArtifactsConfiguration struct {

	// Indicates whether the video artifact is enabled or disabled.
	//
	// This member is required.
	State ArtifactsState

	// The MUX type of the video artifact configuration object.
	MuxType VideoMuxType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
