/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.misc;

import geotrans3.enumerations.CoordinateType;
import geotrans3.enumerations.SourceOrTarget;
import geotrans3.exception.CoordinateConversionException;
import geotrans3.misc.StringToVal;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class StringHandler {
    private final String title = "MSP GEOTRANS 3.7";
    private String[] errorMsg = new String[20];
    private boolean ccsError = false;
    private int numErrors = 0;
    private StringToVal stringToVal;
    private final int maxErrors = 20;

    public StringHandler() {
        this.stringToVal = new StringToVal();
        this.initialize();
    }

    public StringHandler(StringToVal stringToVal) {
        this.stringToVal = stringToVal;
        this.initialize();
    }

    public void setPrecision(int n) {
        this.stringToVal.setPrecision(n);
    }

    public void setLeadingZeros(boolean bl) {
        this.stringToVal.showLeadingZeros(bl);
    }

    public void setSeparator(char c) {
        this.stringToVal.setSeparator(c);
    }

    public void setLonRange(int n) {
        this.stringToVal.setLongRange(n);
    }

    public String longitudeToString(double d, boolean bl, boolean bl2, boolean bl3) throws CoordinateConversionException {
        return this.stringToVal.longitudeToString(d, bl, bl2, bl3);
    }

    public String latitudeToString(double d, boolean bl, boolean bl2, boolean bl3) throws CoordinateConversionException {
        return this.stringToVal.latitudeToString(d, bl, bl2, bl3);
    }

    public String meterToString(double d) {
        return this.stringToVal.meterToString(d);
    }

    public String surveyFeetToString(double d) {
        return this.stringToVal.surveyFeetToString(d);
    }

    public double stringToLatitude(String string, String string2) {
        double d = 0.0;
        try {
            d = this.stringToVal.stringToLatitude(string) * (Math.PI / 180);
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.errorMsg[this.numErrors] = string2 + ": " + coordinateConversionException.getMessage();
            ++this.numErrors;
            this.ccsError = true;
        }
        return d;
    }

    public double stringToLongitude(String string, String string2) {
        double d = 0.0;
        try {
            d = this.stringToVal.stringToLongitude(string) * (Math.PI / 180);
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.errorMsg[this.numErrors] = string2 + ": " + coordinateConversionException.getMessage();
            ++this.numErrors;
            this.ccsError = true;
        }
        return d;
    }

    public double stringToDouble(String string, String string2) {
        double d = 0.0;
        try {
            d = this.stringToVal.stringToDouble(string);
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.errorMsg[this.numErrors] = string2 + ": " + coordinateConversionException.getMessage();
            ++this.numErrors;
            this.ccsError = true;
        }
        return d;
    }

    public int stringToInt(String string, String string2) {
        int n = 0;
        try {
            n = this.stringToVal.stringToInt(string);
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.errorMsg[this.numErrors] = string2 + ": " + coordinateConversionException.getMessage();
            ++this.numErrors;
            this.ccsError = true;
        }
        return n;
    }

    public void displayErrorMsg(Component component) {
        JOptionPane.showMessageDialog(component, this.errorMsg, "MSP GEOTRANS 3.7", 0);
        this.initialize();
    }

    public void displayErrorMsg(Component component, String string) {
        JOptionPane.showMessageDialog(component, "Error: \n" + string, "MSP GEOTRANS 3.7", 0);
    }

    public void displayErrorMsg(Component component, int n, int n2) {
        this.errorMsg[0] = "Error: \n" + SourceOrTarget.name(n) + " " + CoordinateType.name(n2) + ": ";
        this.errorMsg[1] = " ";
        JOptionPane.showMessageDialog(component, this.errorMsg, "MSP GEOTRANS 3.7", 0);
        this.initialize();
    }

    public void displayWarningMsg(Component component, String string) {
        JOptionPane.showMessageDialog(component, "Warning: \n" + string, "MSP GEOTRANS 3.7", 2);
    }

    public void displayPlainMsg(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, "MSP GEOTRANS 3.7", -1);
    }

    public boolean getError() {
        return this.ccsError;
    }

    public void setErrorMessage(boolean bl, String string) {
        this.ccsError = bl;
        this.errorMsg[this.numErrors] = string;
        ++this.numErrors;
    }

    private void initialize() {
        this.ccsError = false;
        this.numErrors = 2;
        for (int i = 0; i < 20; ++i) {
            this.errorMsg[i] = "";
        }
    }

    public void setNumberFormat(JTextField jTextField, double d, int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(n);
        jTextField.setText(numberFormat.format(d));
    }

    public String getTitle() {
        return "MSP GEOTRANS 3.7";
    }
}

