/* PROGRAM:     testmain
 * FILE:        $Header: /home/egg/src/RCS/testmain.c,v 1.1 1998/07/21 11:34:11 ghn Exp $
 * PURPOSE:     First draft eggsh
 * AUTHOR:      Greg Nelson
 * DATE:        98-05-09
 *
 * REVISED:     $Log: testmain.c,v $
 * REVISED:     Revision 1.1  1998/07/21 11:34:11  ghn
 * REVISED:     Initial revision
 * REVISED:
 * Copyright 1998 - Greg Nelson
 * Redistributable under the terms of the GNU Public Licence (GPL)
 */

#include <stdio.h>
#include <stdlib.h>
#include "global.h"
#include "genlib.h"
#include "hwapi.h"
#include "collect.h"
#include "storage.h"
#include "network.h"
#include "errnos.h"

#define BASKETHOST	"halebopp.qtmsys.com"

char *baskethost = BASKETHOST;

void MakeAwake(AwakePacket *pkt);
void MakeDataPkt(char **pkt, EggCarton *src);

int main(int argc, char *argv[]) {
  int 			res, cdres, i;
  int32 sdlisten;
  double sps;
  int32 collyes, collno, alignover, alignwait;
  DevOpts devopts;
  CollectRecord		coll;
  EggCarton		retrcart;
  AwakePacket		awake;
  ReqPacket		*rpktp;
  struct sockaddr_in	rhost, bhost;
  char			*pktbuf, *outpktbuf;
  uint16		pkttype, pktsize;

  pgmname = argv[0];

  if (argc != 6) {
    printf("Usage: %s <ttynum> <baud> <trialsz> <sec_rec> <samp_rec>\n", pgmname);
    exit(-1);
  }

  devopts.port = atoi(argv[1]);
  devopts.baud = atoi(argv[2]);
  coll.opts.trialsz = atoi(argv[3]);
  coll.opts.sec_rec = atoi(argv[4]);
  coll.opts.samp_rec = atoi(argv[5]);
  coll.opts.eggid = GetID();

  coll.opts.rec_pkt = SEC_PKT / coll.opts.sec_rec;
  if (coll.opts.rec_pkt < 1) coll.opts.rec_pkt = 1;
  if (coll.opts.rec_pkt > MAXREC_PKT) coll.opts.rec_pkt = MAXREC_PKT;

  if (coll.opts.trialsz < MINBITS || coll.opts.trialsz > MAXBITS) {
    fprintf(stderr, "Trial size must be between %d and %d.\n",
	    MINBITS, MAXBITS);
    exit(-1);
  }

  if (coll.opts.sec_rec < 1 || coll.opts.sec_rec > MAXSEC_REC) {
    fprintf(stderr, "Seconds/record must be between 1 and %d.\n", MAXSEC_REC);
    exit(-1);
  }

  if (coll.opts.samp_rec < 1 || coll.opts.samp_rec > MAXSAMP_REC) {
    fprintf(stderr, "Samples/record must be between 1 and %d.\n", MAXSAMP_REC);
    exit(-1);
  }

  sps = (double)coll.opts.samp_rec / (double)coll.opts.sec_rec;

  printf("Effective sample rate is about %f samp/sec or %f bits/sec\n",
	 sps, coll.opts.trialsz * sps);
  printf("Packets contain %d records\n", coll.opts.rec_pkt);

  if ((coll.dd = OpenDev(&devopts)) < 0) exit(1);
  if (EvalSpeed(coll.dd) < coll.opts.trialsz * sps) {
    fprintf(stderr, "Requested speed exceeds device capabilities.\n");
    exit(-1);
  }

  coll.sampct = 0;
  collyes = collno = 0;
  alignover = alignwait = 0;

  InitStorage(NULL);
  sdlisten = InitNetwork(EGGPORT);

  /* Get us aligned for the first time */
  while(AlignRecord(&coll, TRUE) < 0);

  while(1) {
    res = NetListen(sdlisten, &pktbuf, &rhost, FALSE);
    if (res < 0 && res != ERR_COMM_TMOUT) {
      fprintf(stderr, "NetListen error: %d\n", res);
      continue;
    }
    if (res == ERR_NONE) {
      pkttype = ((GenPacket *)pktbuf)->type;
      pktsize = ((GenPacket *)pktbuf)->pktsize;
      switch(pkttype) {
      case DATA_PACKET:
	fprintf(stderr, "Egg received data?\n");
	break;
      case REQ_PACKET:
	/* Basket wants data! */
	rpktp = (ReqPacket *)pktbuf;
	
	/* Find the desired data. */
	res = LoadNextPacket(rpktp->starttm, &retrcart);

	if (res == ERR_NONE) {
	  /* NetPacketize it */
	  MakeDataPkt(&outpktbuf, &retrcart);
	  rhost.sin_port = htons(BASKETPORT);
	  res = NetTalk(&rhost, outpktbuf);
	  if (res < 0) {
	    fprintf(stderr, "NetTalk failed (%d)\n", res);
	  }
	  free(outpktbuf);
	}
	break;
      case AWAKE_PACKET:
	fprintf(stderr, "Egg received awake?\n");
	break;
      case SETTINGS_PACKET:
	/* Install new settings! */
	break;
      }
      free(pktbuf);
    }
    
    if (coll.sampct == 0) {
      cdres = AlignRecord(&coll, FALSE);
      if (cdres < 0) {
	if (cdres == -3) alignover++; else alignwait++;
	continue;
      }
    }
    cdres = CollectData(&coll);
    if (cdres < 0) {
      collno++;
      continue;
    }
    collyes++;
    if (cdres == 1) {
      SaveRecord(&coll);
      MakeAwake(&awake);
      i = NetGetAddr(&bhost, baskethost, BASKETPORT);
      i = NetTalk(&bhost, (char *)&awake);
      printf(" collect:nodata over:wait = %ld:%ld %ld:%ld\n",
	     collyes, collno, alignover, alignwait);
      printf("Record: %d points (transmission %d)\n  %ld: ",
	     coll.sampct, i, coll.data.timestamp);
      for (i = 0; i < coll.sampct; i++)
	printf("%3d ", coll.data.trials[i]);
      printf("\n");
      coll.sampct = 0;
    }
  }

  return 0;
}


void MakeAwake(AwakePacket *pkt) {
  struct timeval now;

  pkt->type = AWAKE_PACKET;
  pkt->pktsize = sizeof(AwakePacket);
  pkt->eggid = GetID();
  getzulutime(&now);
  pkt->nowtm = now.tv_sec;
}

void MakeDataPkt(char **pkt, EggCarton *src) {
  uint16 pktsize, offset, rec, sbuf;
  uint32 lbuf;

  pktsize = sizeof(EggHeader);
  pktsize += src->hdr.numrec * (sizeof(uint32) + 
			        src->hdr.samp_rec * sizeof(trial));
  pktsize += sizeof(uint16);	/* Checksum */

  src->hdr.type = DATA_PACKET;
  src->hdr.pktsize = pktsize;

  *pkt = (char *)malloc(pktsize);
  memcpy(*pkt, &(src->hdr), sizeof(EggHeader));
  offset = sizeof(EggHeader);

  for (rec = 0; rec < src->hdr.numrec; rec++) {
    lbuf = src->records[rec].timestamp;
    memcpy((*pkt)+offset, &lbuf, sizeof(uint32));
    offset += sizeof(uint32);
    /* Assumes sizeof(trial) = 1 */
    memcpy((*pkt)+offset, &(src->records[rec].trials), src->hdr.samp_rec);
    offset += src->hdr.samp_rec;
  }

  /* Normal CRC */
  sbuf = BlockCRC16(*pkt, offset);
  memcpy((*pkt)+offset, &sbuf, sizeof(uint16));
  offset += sizeof(uint16);

  if (offset != pktsize) {
    fprintf(stderr, "Error in packet generation!\n");
  }
}

