/*
	Copyright (C) Slava Astashonok <sla@0n.ru>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License.

	$Id: netflow.h,v 1.3.2.5.2.1 2004/08/13 21:03:10 sla Exp $
*/

#ifndef _NETFLOW_H_
#define _NETFLOW_H_

#include <my_inttypes.h>

#define NETFLOW_BYTES_32 1
#define NETFLOW_BYTES_32_SIZE 4

#define NETFLOW_PKTS_32 2
#define NETFLOW_PKTS_32_SIZE 4

#define NETFLOW_FLOWS 3
#define NETFLOW_FLOWS_SIZE 4

#define NETFLOW_PROT 4
#define NETFLOW_PROT_SIZE 1

#define NETFLOW_SRC_TOS 5
#define NETFLOW_SRC_TOS_SIZE 1

#define NETFLOW_TCP_FLAGS 6
#define NETFLOW_TCP_FLAGS_SIZE 1

#define NETFLOW_L4_SRC_PORT 7
#define NETFLOW_L4_SRC_PORT_SIZE 2

#define NETFLOW_IPV4_SRC_ADDR 8
#define NETFLOW_IPV4_SRC_ADDR_SIZE 4

#define NETFLOW_SRC_MASK 9
#define NETFLOW_SRC_MASK_SIZE 1

#define NETFLOW_INPUT_SNMP 10
#define NETFLOW_INPUT_SNMP_SIZE 2

#define NETFLOW_L4_DST_PORT 11
#define NETFLOW_L4_DST_PORT_SIZE 2

#define NETFLOW_IPV4_DST_ADDR 12
#define NETFLOW_IPV4_DST_ADDR_SIZE 4

#define NETFLOW_DST_MASK 13
#define NETFLOW_DST_MASK_SIZE 1

#define NETFLOW_OUTPUT_SNMP 14
#define NETFLOW_OUTPUT_SNMP_SIZE 2

#define NETFLOW_IPV4_NEXT_HOP 15
#define NETFLOW_IPV4_NEXT_HOP_SIZE 4

#define NETFLOW_SRC_AS 16
#define NETFLOW_SRC_AS_SIZE 2

#define NETFLOW_DST_AS 17
#define NETFLOW_DST_AS_SIZE 2

#define NETFLOW_BGP_NEXT_HOP 18
#define NETFLOW_BGP_NEXT_HOP_SIZE 4

#define NETFLOW_IPM_DPKTS 19
#define NETFLOW_IPM_DPKTS_SIZE 4

#define NETFLOW_IPM_DOCTETS 20
#define NETFLOW_IPM_DOCTETS_SIZE 4

#define NETFLOW_LAST_SWITCHED 21
#define NETFLOW_LAST_SWITCHED_SIZE 4

#define NETFLOW_FIRST_SWITCHED 22
#define NETFLOW_FIRST_SWITCHED_SIZE 4

#define NETFLOW_BYTES_64 23
#define NETFLOW_BYTES_64_SIZE 8

#define NETFLOW_PKTS_64 24
#define NETFLOW_PKTS_64_SIZE 8

#define NETFLOW_MAC_ADDR 25
#define NETFLOW_MAC_ADDR_SIZE 6

#define NETFLOW_VLAN_ID 26
#define NETFLOW_VLAN_ID_SIZE 2

#define NETFLOW_IPV6_SRC_ADDR 27
#define NETFLOW_IPV6_SRC_ADDR_SIZE 16

#define NETFLOW_IPV6_DST_ADDR 28
#define NETFLOW_IPV6_DST_ADDR_SIZE 16

#define NETFLOW_IPV6_SRC_MASK 29
#define NETFLOW_IPV6_SRC_MASK_SIZE 1

#define NETFLOW_IPV6_DST_MASK 30
#define NETFLOW_IPV6_DST_MASK_SIZE 1

#define NETFLOW_FLOW_LABEL 31
#define NETFLOW_FLOW_LABEL_SZIE 3

#define NETFLOW_ICMP_TYPE 32
#define NETFLOW_ICMP_TYPE_SIZE 1

#define NETFLOW_MUL_IGMP_TYPE 33
#define NETFLOW_MUL_IGMP_TYPE_SIZE 1

#define NETFLOW_SAMPLING_INTERVAL 34
#define NETFLOW_SAMPLING_INTERVAL_SIZE 4

#define NETFLOW_SAMPLING_ALGORITHM 35
#define NETFLOW_SAMPLING_ALGORITHM_SIZE 1

#define NETFLOW_FLOW_ACTIVE_TIMEOUT 36
#define NETFLOW_FLOW_ACTIVE_TIMEOUT_SIZE 2

#define NETFLOW_FLOW_INACTIVE_TIMEOUT 37
#define NETFLOW_FLOW_INACTIVE_TIMEOUT_SIZE 2

#define NETFLOW_ENGINE_TYPE 38
#define NETFLOW_ENGINE_TYPE_SIZE 1

#define NETFLOW_ENGINE_ID 39
#define NETFLOW_ENGINE_ID_SIZE 1

#define NETFLOW_TOTAL_BYTES_EXPORTED 40
#define NETFLOW_TOTAL_BYTES_EXPORTED_SIZE 4

#define NETFLOW_TOTAL_EXPORT_PKTS_SENT 41
#define NETFLOW_TOTAL_EXPORT_PKTS_SENT_SIZE 4

#define NETFLOW_TOTAL_FLOWS_EXPORTED 42
#define NETFLOW_TOTAL_FLOWS_EXPORTED_SIZE 4

#define NETFLOW_FLOW_SAMPLER_ID 48
#define NETFLOW_FLOW_SAMPLER_ID_SIZE 1

#define NETFLOW_FLOW_SAMPLER_MODE 49
#define NETFLOW_FLOW_SAMPLER_MODE_SIZE 1

#define NETFLOW_FLOW_SAMPLER_RANDOM_INTERVAL 50
#define NETFLOW_FLOW_SAMPLER_RANDOM_INTERVAL_SIZE 4

#define NETFLOW_IP_PROTOCOL_VERSION 60
#define NETFLOW_IP_PROTOCOL_VERSION_SIZE 1

#define NETFLOW_DIRECTION 61
#define NETFLOW_DIRECTION_SIZE 1

#define NETFLOW_IPV6_NEXT_HOP 62
#define NETFLOW_IPV6_NEXT_HOP_SIZE 16

#define NETFLOW_BGP_IPV6_NEXT_HOP 63
#define NETFLOW_BGP_IPV6_NEXT_HOP_SIZE 16

#define NETFLOW_IPV6_OPTION_HEADERS 64
#define NETFLOW_IPV6_OPTION_HEADERS_SIZE 4


#define NETFLOW_VERSION 1001
#define NETFLOW_VERSION_SIZE 2

#define NETFLOW_COUNT 1002
#define NETFLOW_COUNT_SIZE 2

#define NETFLOW_UPTIME 1003
#define NETFLOW_UPTIME_SIZE 4

#define NETFLOW_UNIX_SECS 1004
#define NETFLOW_UNIX_SECS_SIZE 4

#define NETFLOW_UNIX_NSECS 1005
#define NETFLOW_UNIX_NSECS_SIZE 4

#define NETFLOW_FLOW_SEQUENCE 1006
#define NETFLOW_FLOW_SEQUENCE_SIZE 4

#define NETFLOW_HEADER_SAMPLING_INTERVAL 1009 /* ??? */
#define NETFLOW_HEADER_SAMPLING_INTERVAL_SIZE 2

#define NETFLOW_FLAGS7_1 1010
#define NETFLOW_FLAGS7_1_SIZE 1

#define NETFLOW_FLAGS7_2 1011
#define NETFLOW_FLAGS7_2_SIZE 2

#define NETFLOW_ROUTER_SC 1012
#define NETFLOW_ROUTER_SC_SIZE 4


#define NETFLOW_PAD8 9001
#define NETFLOW_PAD8_SIZE 1

#define NETFLOW_PAD16 9002
#define NETFLOW_PAD16_SIZE 2

#define NETFLOW_PAD32 9003
#define NETFLOW_PAD32_SIZE 4

#define NETFLOW_PAD64 9004
#define NETFLOW_PAD64_SIZE 8


#define NETFLOW_MAX_PACKET 1500

#define NETFLOW1_VERSION 1
#define NETFLOW1_HEADER_SIZE 16
#define NETFLOW1_MAX_FLOWS 24
#define NETFLOW1_FLOW_SIZE 48
#define NETFLOW1_SEQ_OFFSET 0

#define NETFLOW5_VERSION 5
#define NETFLOW5_HEADER_SIZE 24
#define NETFLOW5_MAX_FLOWS 30
#define NETFLOW5_FLOW_SIZE 48
#define NETFLOW5_SEQ_OFFSET 16

#define NETFLOW7_VERSION 7
#define NETFLOW7_HEADER_SIZE 24
#define NETFLOW7_MAX_FLOWS 27
#define NETFLOW7_FLOW_SIZE 52
#define NETFLOW7_SEQ_OFFSET 16

#define NETFLOW8_VERSION 8
#define NETFLOW8_MAX_FLOWS 51

struct NetFlow {
	unsigned Version;
	unsigned HeaderSize;
	unsigned MaxFlows;
	unsigned FlowSize;
	unsigned SeqOffset;
	unsigned HeaderFields;
	uint16_t *HeaderFormat;
	unsigned FlowFields;
	uint16_t *FlowFormat;
};

#endif
