/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Vector;

public class ArgParserTest {
    ArgParser parser = new ArgParser("fubar");
    static final boolean CLOSED = true;
    static final boolean OPEN = false;
    static final boolean ONE_WORD = true;
    static final boolean MULTI_WORD = false;

    private static void verify(boolean ok, String msg) {
        if (!ok) {
            Throwable e = new Throwable();
            System.out.println("Verification failed:" + msg);
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String[] argsFromString(String s) {
        Vector vec = new Vector(100);
        try {
            ArgParser.stringToArgs(vec, s, false);
        }
        catch (StringScanException e) {
            e.printStackTrace();
            System.exit(1);
        }
        String[] result = new String[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            result[i] = (String)vec.get(i);
        }
        return result;
    }

    ArgParserTest() {
    }

    static void checkException(Exception e, String errmsg) {
        if (errmsg != null) {
            if (!e.getMessage().equals(errmsg)) {
                System.out.println("Expecting exception '" + errmsg + "' but got '" + e.getMessage() + "'");
                e.printStackTrace();
                new Throwable().printStackTrace();
                System.exit(1);
            }
        } else {
            System.out.println("Unexpected exception '" + e.getMessage() + "'");
            e.printStackTrace();
            new Throwable().printStackTrace();
            System.exit(1);
        }
    }

    void checkPrintHelp(String msg) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(65536);
        PrintStream ps = new PrintStream(buf);
        ps.println(this.parser.getHelpMessage());
        System.out.print(buf.toString());
    }

    void checkAdd(String s, Object resHolder, String errmsg) {
        this.checkAdd(s, resHolder, 0, 0, null, null, null, errmsg);
    }

    void add(String s, Object resHolder) {
        try {
            this.parser.addOption(s, resHolder);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    void checkStringArray(String msg, String[] strs, String[] check) {
        int i;
        boolean dontMatch = false;
        if (strs.length != check.length) {
            dontMatch = true;
        } else {
            for (i = 0; i < strs.length; ++i) {
                if (strs[i].equals(check[i])) continue;
                dontMatch = true;
                break;
            }
        }
        if (dontMatch) {
            System.out.println(msg);
            System.out.print("Expected: ");
            for (i = 0; i < check.length; ++i) {
                System.out.print("'" + check[i] + "'");
                if (i >= check.length - 1) continue;
                System.out.print(" ");
            }
            System.out.println("");
            System.out.print("Got: ");
            for (i = 0; i < strs.length; ++i) {
                System.out.print("'" + strs[i] + "'");
                if (i >= strs.length - 1) continue;
                System.out.print(" ");
            }
            System.out.println("");
            System.exit(1);
        }
    }

    void checkAdd(String s, Object resHolder, int code, int numValues, Object names, RngCheck[] rngCheck, String helpMsg, String errmsg) {
        boolean exceptionThrown = false;
        String[] namelist = null;
        try {
            this.parser.addOption(s, resHolder);
        }
        catch (Exception e) {
            exceptionThrown = true;
            ArgParserTest.checkException(e, errmsg);
        }
        namelist = names instanceof String ? new String[]{(String)names} : (String[])names;
        if (!exceptionThrown) {
            ArgParserTest.verify(errmsg == null, "Expecting exception " + errmsg);
            ArgParser.Record rec = this.parser.lastMatchRecord();
            ArgParserTest.verify(rec.convertCode == code, "code=" + rec.convertCode + ", expecting " + code);
            int i = 0;
            ArgParser.NameDesc nd = rec.firstNameDesc();
            while (nd != null) {
                ++i;
                nd = nd.next;
            }
            ArgParserTest.verify(i == namelist.length, "numNames=" + i + ", expecting " + namelist.length);
            i = 0;
            nd = rec.firstNameDesc();
            while (nd != null) {
                String ss = !nd.oneWord ? new String(nd.name) + ' ' : nd.name;
                ArgParserTest.verify(ss.equals(namelist[i]), "have name '" + ss + "', expecting '" + namelist[i] + "'");
                ++i;
                nd = nd.next;
            }
            i = 0;
            ArgParser.RangeAtom ra = rec.firstRangeAtom();
            while (ra != null) {
                ++i;
                ra = ra.next;
            }
            int expectedRangeNum = 0;
            if (rngCheck != null) {
                expectedRangeNum = rngCheck.length;
            }
            ArgParserTest.verify(i == expectedRangeNum, "numRangeAtoms=" + i + ", expecting " + expectedRangeNum);
            i = 0;
            ra = rec.firstRangeAtom();
            while (ra != null) {
                rngCheck[i++].check(ra);
                ra = ra.next;
            }
            ArgParserTest.verify(rec.helpMsg.equals(helpMsg), "helpMsg=" + rec.helpMsg + ", expecting " + helpMsg);
            ArgParserTest.verify(rec.numValues == numValues, "numValues=" + rec.numValues + ", expecting " + numValues);
        }
    }

    double getDoubleValue(Object obj, int k) {
        if (obj instanceof DoubleHolder) {
            return ((DoubleHolder)obj).value;
        }
        if (obj instanceof FloatHolder) {
            return ((FloatHolder)obj).value;
        }
        if (obj instanceof double[]) {
            return ((double[])obj)[k];
        }
        if (obj instanceof float[]) {
            return ((float[])obj)[k];
        }
        ArgParserTest.verify(false, "object doesn't contain double values");
        return 0.0;
    }

    long getLongValue(Object obj, int k) {
        if (obj instanceof LongHolder) {
            return ((LongHolder)obj).value;
        }
        if (obj instanceof IntHolder) {
            return ((IntHolder)obj).value;
        }
        if (obj instanceof long[]) {
            return ((long[])obj)[k];
        }
        if (obj instanceof int[]) {
            return ((int[])obj)[k];
        }
        ArgParserTest.verify(false, "object doesn't contain long values");
        return 0L;
    }

    String getStringValue(Object obj, int k) {
        if (obj instanceof StringHolder) {
            return ((StringHolder)obj).value;
        }
        if (obj instanceof String[]) {
            return ((String[])obj)[k];
        }
        ArgParserTest.verify(false, "object doesn't contain String values");
        return null;
    }

    boolean getBooleanValue(Object obj, int k) {
        if (obj instanceof BooleanHolder) {
            return ((BooleanHolder)obj).value;
        }
        if (obj instanceof boolean[]) {
            return ((boolean[])obj)[k];
        }
        ArgParserTest.verify(false, "object doesn't contain boolean values");
        return false;
    }

    char getCharValue(Object obj, int k) {
        if (obj instanceof CharHolder) {
            return ((CharHolder)obj).value;
        }
        if (obj instanceof char[]) {
            return ((char[])obj)[k];
        }
        ArgParserTest.verify(false, "object doesn't contain char values");
        return '\u0000';
    }

    void checkMatch(String[] args, int idx, String errMsg) {
        this.getMatchResult(args, idx, -1, errMsg, -1);
    }

    void checkMatch(String[] args, int idx, int cnt, long check, int resultIdx) {
        Object rholder = this.getMatchResult(args, idx, cnt, null, resultIdx);
        long result = this.getLongValue(rholder, 0);
        ArgParserTest.verify(result == check, "result " + result + " vs. " + check);
    }

    void checkMatch(String[] args, int idx, int cnt, double check, int resultIdx) {
        Object rholder = this.getMatchResult(args, idx, cnt, null, resultIdx);
        double result = this.getDoubleValue(rholder, 0);
        ArgParserTest.verify(result == check, "result " + result + " vs. " + check);
    }

    void checkMatch(String[] args, int idx, int cnt, String check, int resultIdx) {
        Object rholder = this.getMatchResult(args, idx, cnt, null, resultIdx);
        String result = this.getStringValue(rholder, 0);
        ArgParserTest.verify(result.equals(check), "result " + result + " vs. " + check);
    }

    void checkMatch(String[] args, int idx, int cnt, boolean check, int resultIdx) {
        Object rholder = this.getMatchResult(args, idx, cnt, null, resultIdx);
        boolean result = this.getBooleanValue(rholder, 0);
        ArgParserTest.verify(result == check, "result " + result + " vs. " + check);
    }

    void checkMatch(String[] args, int idx, int cnt, char check, int resultIdx) {
        Object rholder = this.getMatchResult(args, idx, cnt, null, resultIdx);
        char result = this.getCharValue(rholder, 0);
        ArgParserTest.verify(result == check, "result " + result + " vs. " + check);
    }

    void checkMatch(String[] args, int idx, int cnt, Object checkArray, int resultIdx) {
        Object rholder = this.getMatchResult(args, idx, cnt, null, resultIdx);
        if (!checkArray.getClass().isArray()) {
            ArgParserTest.verify(false, "check is not an array");
        }
        for (int i = 0; i < Array.getLength(checkArray); ++i) {
            if (checkArray instanceof long[]) {
                long check;
                long result = this.getLongValue(rholder, i);
                ArgParserTest.verify(result == (check = ((long[])checkArray)[i]), "result [" + i + "] " + result + " vs. " + check);
                continue;
            }
            if (checkArray instanceof double[]) {
                double check;
                double result = this.getDoubleValue(rholder, i);
                ArgParserTest.verify(result == (check = ((double[])checkArray)[i]), "result [" + i + "] " + result + " vs. " + check);
                continue;
            }
            if (checkArray instanceof String[]) {
                String result = this.getStringValue(rholder, i);
                String check = ((String[])checkArray)[i];
                ArgParserTest.verify(result.equals(check), "result [" + i + "] " + result + " vs. " + check);
                continue;
            }
            if (checkArray instanceof boolean[]) {
                boolean check;
                boolean result = this.getBooleanValue(rholder, i);
                ArgParserTest.verify(result == (check = ((boolean[])checkArray)[i]), "result [" + i + "] " + result + " vs. " + check);
                continue;
            }
            if (checkArray instanceof char[]) {
                char check;
                char result = this.getCharValue(rholder, i);
                ArgParserTest.verify(result == (check = ((char[])checkArray)[i]), "result [" + i + "] " + result + " vs. " + check);
                continue;
            }
            ArgParserTest.verify(false, "unknown type for checkArray");
        }
    }

    void checkMatch(MTest test, boolean oneWord) {
        String[] argv = oneWord ? new String[]{test.args} : ArgParserTest.argsFromString(test.args);
        if (test.result instanceof Long) {
            this.checkMatch(argv, 0, argv.length, (Long)test.result, test.resultIdx);
        } else if (test.result instanceof Double) {
            this.checkMatch(argv, 0, argv.length, (Double)test.result, test.resultIdx);
        } else if (test.result instanceof String) {
            this.checkMatch(argv, 0, argv.length, (String)test.result, test.resultIdx);
        } else if (test.result instanceof Boolean) {
            this.checkMatch(argv, 0, argv.length, (Boolean)test.result, test.resultIdx);
        } else if (test.result instanceof Character) {
            this.checkMatch(argv, 0, argv.length, ((Character)test.result).charValue(), test.resultIdx);
        } else if (test.result.getClass().isArray()) {
            this.checkMatch(argv, 0, argv.length, test.result, test.resultIdx);
        } else if (test.result instanceof MErr) {
            MErr err = (MErr)test.result;
            String argname = this.parser.getOptionName(argv[0]);
            String msg = "";
            switch (err.code) {
                case 99: {
                    msg = "requires a contiguous value";
                    break;
                }
                case 109: {
                    msg = "malformed " + this.parser.getOptionTypeName(argv[0]) + " '" + err.valStr + "'";
                    break;
                }
                case 114: {
                    msg = "value '" + err.valStr + "' not in range " + this.parser.getOptionRangeDesc(argv[0]);
                    break;
                }
                case 118: {
                    msg = "requires " + err.valStr + " values";
                }
            }
            this.checkMatch(argv, 0, argname + ": " + msg);
        } else {
            ArgParserTest.verify(false, "Unknown result type");
        }
    }

    void checkMatches(MTest[] tests, boolean oneWord) {
        for (int i = 0; i < tests.length; ++i) {
            this.checkMatch(tests[i], oneWord);
        }
    }

    Object getMatchResult(String[] args, int idx, int cnt, String errMsg, int resultIdx) {
        boolean exceptionThrown = false;
        int k = 0;
        try {
            k = this.parser.matchArg(args, idx);
        }
        catch (Exception e) {
            exceptionThrown = true;
            ArgParserTest.checkException(e, errMsg);
        }
        if (!exceptionThrown) {
            ArgParserTest.verify(k == idx + cnt, "Expecting result index " + (idx + cnt) + ", got " + k);
            Object result = this.parser.getResultHolder(args[0]);
            if (resultIdx >= 0) {
                ArgParserTest.verify(result instanceof Vector, "Expecting result to be stored in a vector");
                Vector vec = (Vector)result;
                ArgParserTest.verify(vec.size() == resultIdx + 1, "Expecting result vector size " + (resultIdx + 1));
                return vec.get(resultIdx);
            }
            return result;
        }
        return null;
    }

    public static void main(String[] args) {
        ArgParserTest test = new ArgParserTest();
        BooleanHolder bh = new BooleanHolder();
        boolean[] b3 = new boolean[3];
        CharHolder ch = new CharHolder();
        char[] c3 = new char[3];
        IntHolder ih = new IntHolder();
        int[] i3 = new int[3];
        LongHolder lh = new LongHolder();
        long[] l3 = new long[3];
        FloatHolder fh = new FloatHolder();
        float[] f3 = new float[3];
        DoubleHolder dh = new DoubleHolder();
        double[] d3 = new double[3];
        StringHolder sh = new StringHolder();
        String[] s3 = new String[3];
        test.checkAdd("-foo %i{[0,10)}X3 #sets the value of foo", i3, 105, 3, new String[]{"-foo "}, new RngCheck[]{new RngCheck(0L, true, 10L, false)}, "sets the value of foo", null);
        test.checkAdd("-arg1,,", null, "Null option name given");
        test.checkAdd("-arg1,,goo %f ", null, "Null option name given");
        test.checkAdd("  ", null, "Null option name given");
        test.checkAdd("", null, "Null option name given");
        test.checkAdd("  %v", null, "Null option name given");
        test.checkAdd("-foo  ", null, "No conversion character given");
        test.checkAdd("-foo %", null, "No conversion character given");
        test.checkAdd("foo, aaa   bbb ", null, "Names not separated by ','");
        test.checkAdd(" foo aaa %d", null, "Names not separated by ','");
        test.checkAdd("-arg1,-b,", null, "Null option name given");
        test.checkAdd("-arg1,-b", null, "No conversion character given");
        test.checkAdd("-arg1 ", null, "No conversion character given");
        test.checkAdd("-arg1, %v", null, "Null option name given");
        test.checkAdd("-arg1,%v", null, "Null option name given");
        test.checkAdd("-foo %V", null, "Conversion code 'V' not one of 'iodxcbfsvh'");
        test.checkAdd("-h %hX5", null, "Multipliers not supported for %h");
        test.checkAdd("-h %h{}", null, "Ranges not supported for %h");
        test.checkAdd("-help, -h %h #here is how we help you", null, 104, 1, new String[]{"-help ", "-h "}, null, "here is how we help you", null);
        test.checkAdd("-arg1 ,-arg2=%d{0,3,(7,16]}X1 #x3 test", l3, 100, 1, new String[]{"-arg1 ", "-arg2="}, new RngCheck[]{new RngCheck(0L), new RngCheck(3L), new RngCheck(7L, false, 16L, true)}, "x3 test", null);
        test.checkAdd("bbb,ccc%x{[1,2]} #X3 x3 test", l3, 120, 1, new String[]{"bbb", "ccc"}, new RngCheck[]{new RngCheck(1L, true, 2L, true)}, "X3 x3 test", null);
        test.checkAdd(" bbb ,ccc,  ddd  ,e   , f=%bX1 #x3 test", b3, 98, 1, new String[]{"bbb ", "ccc", "ddd ", "e ", "f="}, null, "x3 test", null);
        test.checkAdd(" bbb ,ccc,  ddd  ,e   , f= %bX3 #x3 test", b3, 98, 3, new String[]{"bbb ", "ccc ", "ddd ", "e ", "f= "}, null, "x3 test", null);
        test.checkAdd("-b,--bar %s{[\"john\",\"jerry\"),fred,\"harry\"} #sets bar", sh, 115, 1, new String[]{"-b ", "--bar "}, new RngCheck[]{new RngCheck("jerry", false, "john", true), new RngCheck("fred"), new RngCheck("harry")}, "sets bar", null);
        test.checkAdd("-c ,coven%f{0.0,9.0,(6,5],[-9.1,10.2]}  ", dh, 102, 1, new String[]{"-c ", "coven"}, new RngCheck[]{new RngCheck(0.0), new RngCheck(9.0), new RngCheck(5.0, true, 6.0, false), new RngCheck(-9.1, true, 10.2, true)}, "", null);
        test.checkAdd("-b %b #a boolean value  ", bh, 98, 1, new String[]{"-b "}, new RngCheck[0], "a boolean value  ", null);
        test.checkAdd("-a %i", ih, 105, 1, "-a ", null, "", null);
        test.checkAdd("-a %o", lh, 111, 1, "-a ", null, "", null);
        test.checkAdd("-a %d", i3, 100, 1, "-a ", null, "", null);
        test.checkAdd("-a %x", l3, 120, 1, "-a ", null, "", null);
        test.checkAdd("-a %c", ch, 99, 1, "-a ", null, "", null);
        test.checkAdd("-a %c", c3, 99, 1, "-a ", null, "", null);
        test.checkAdd("-a %v", bh, 118, 1, "-a ", null, "", null);
        test.checkAdd("-a %b", b3, 98, 1, "-a ", null, "", null);
        test.checkAdd("-a %f", fh, 102, 1, "-a ", null, "", null);
        test.checkAdd("-a %f", f3, 102, 1, "-a ", null, "", null);
        test.checkAdd("-a %f", dh, 102, 1, "-a ", null, "", null);
        test.checkAdd("-a %f", d3, 102, 1, "-a ", null, "", null);
        test.checkAdd("-a %i", fh, 105, 1, "-a ", null, "", "Invalid result holder for %i");
        test.checkAdd("-a %c", i3, 99, 1, "-a ", null, "", "Invalid result holder for %c");
        test.checkAdd("-a %v", d3, 118, 1, "-a ", null, "", "Invalid result holder for %v");
        test.checkAdd("-a %f", sh, 102, 1, "-a ", null, "", "Invalid result holder for %f");
        test.checkAdd("-a %s", l3, 115, 1, "-a ", null, "", "Invalid result holder for %s");
        test.checkAdd("-foo %i{} ", ih, 105, 1, "-foo ", null, "", null);
        test.checkAdd("-foo%i{}", ih, 105, 1, "-foo", null, "", null);
        test.checkAdd("-foo%i{  }", ih, 105, 1, "-foo", null, "", null);
        test.checkAdd("-foo%i{ }}", ih, "Illegal character(s), expecting '#'");
        test.checkAdd("-foo%i{  ", ih, "Unterminated range specification");
        test.checkAdd("-foo%i{", ih, "Unterminated range specification");
        test.checkAdd("-foo%i{0,9", ih, "Unterminated range specification");
        test.checkAdd("-foo%i{1,2,3)", ih, "Unterminated range specification");
        test.checkAdd("-b %f{0.9}", fh, 102, 1, "-b ", new RngCheck[]{new RngCheck(0.9)}, "", null);
        test.checkAdd("-b %f{ 0.9 ,7, -0.5,-4 ,6 }", fh, 102, 1, "-b ", new RngCheck[]{new RngCheck(0.9), new RngCheck(7.0), new RngCheck(-0.5), new RngCheck(-4.0), new RngCheck(6.0)}, "", null);
        test.checkAdd("-b %f{ [0.9,7), (-0.5,-4),[9,6] , (10,13.4] }", fh, 102, 1, "-b ", new RngCheck[]{new RngCheck(0.9, true, 7.0, false), new RngCheck(-4.0, false, -0.5, false), new RngCheck(6.0, true, 9.0, true), new RngCheck(10.0, false, 13.4, true)}, "", null);
        test.checkAdd("-b %f{(8 9]}", fh, "Missing ',' in subrange specification");
        test.checkAdd("-b %f{(8,9,]}", fh, "Unterminated subrange");
        test.checkAdd("-b %f{(8,9 ,]}", fh, "Unterminated subrange");
        test.checkAdd("-b %f{(8,9  8]}", fh, "Unterminated subrange");
        test.checkAdd("-b %f{8 9}", fh, "Range spec: ',' or '}' expected");
        test.checkAdd("-b %f{8 *}", fh, "Range spec: ',' or '}' expected");
        test.checkAdd("-b %f{8y}", fh, "Range spec: ',' or '}' expected");
        test.checkAdd("-b %f{.}", fh, "Malformed float '.}' in range spec");
        test.checkAdd("-b %f{1.0e}", fh, "Malformed float '1.0e}' in range spec");
        test.checkAdd("-b %f{[*]}", fh, "Malformed float '*' in range spec");
        test.checkAdd("-b %f{1.2e5t}", fh, "Range spec: ',' or '}' expected");
        test.checkAdd("-b %i{8}", ih, 105, 1, "-b ", new RngCheck[]{new RngCheck(8L)}, "", null);
        test.checkAdd("-b %i{8, 9,10 }", ih, 105, 1, "-b ", new RngCheck[]{new RngCheck(8L), new RngCheck(9L), new RngCheck(10L)}, "", null);
        test.checkAdd("-b %i{8, [-9,10),[-17,15],(2,-33),(8,9] }", ih, 105, 1, "-b ", new RngCheck[]{new RngCheck(8L), new RngCheck(-9L, true, 10L, false), new RngCheck(-17L, true, 15L, true), new RngCheck(-33L, false, 2L, false), new RngCheck(8L, false, 9L, true)}, "", null);
        test.checkAdd("-b %i{8.7}", ih, "Range spec: ',' or '}' expected");
        test.checkAdd("-b %i{6,[*]}", ih, "Malformed integer '*' in range spec");
        test.checkAdd("-b %i{g76}", ih, "Malformed integer 'g' in range spec");
        test.checkAdd("-b %s{foobar}", sh, 115, 1, "-b ", new RngCheck[]{new RngCheck("foobar")}, "", null);
        test.checkAdd("-b %s{foobar, 0x233,\"  \"}", sh, 115, 1, "-b ", new RngCheck[]{new RngCheck("foobar"), new RngCheck("0x233"), new RngCheck("  ")}, "", null);
        test.checkAdd("-b %s{foobar,(bb,aa], [\"01\",02]}", sh, 115, 1, "-b ", new RngCheck[]{new RngCheck("foobar"), new RngCheck("aa", true, "bb", false), new RngCheck("01", true, "02", true)}, "", null);
        test.checkAdd("-b %c{'a'}", ch, 99, 1, "-b ", new RngCheck[]{new RngCheck(97L)}, "", null);
        test.checkAdd("-b %c{'\\n', '\\002', 'B'}", ch, 99, 1, "-b ", new RngCheck[]{new RngCheck(10L), new RngCheck(2L), new RngCheck(66L)}, "", null);
        test.checkAdd("-b %c{'q',('g','a'], ['\t','\\003']}", ch, 99, 1, "-b ", new RngCheck[]{new RngCheck(113L), new RngCheck(97L, true, 103L, false), new RngCheck(3L, true, 9L, true)}, "", null);
        test.checkAdd("-b %b{true}X2", b3, 98, 2, "-b ", new RngCheck[]{new RngCheck(true)}, "", null);
        test.checkAdd("-b %b{ true , false, true }", bh, 98, 1, "-b ", new RngCheck[]{new RngCheck(true), new RngCheck(false), new RngCheck(true)}, "", null);
        test.checkAdd("-b %v{true,[true,false)}", bh, "Sub ranges not supported for %b or %v");
        test.checkAdd("-b %v{true,[]}", bh, "Sub ranges not supported for %b or %v");
        test.checkAdd("-b %b{tru}", bh, "Malformed boolean 'tru}' in range spec");
        test.checkAdd("-b %iX2", i3, 105, 2, "-b ", null, "", null);
        test.checkAdd("-b %vX3", b3, 118, 3, "-b ", null, "", null);
        test.checkAdd("-b %v{ }X3", b3, 118, 3, "-b ", null, "", null);
        test.checkAdd("-b=%iX2", i3, 105, 2, "-b", null, "", "Multiplier value incompatible with one word option -b=");
        test.checkAdd("-b %iX0", i3, 105, 0, "-b ", null, "", "Value multiplier number must be > 0");
        test.checkAdd("-b %iX-6", i3, 105, 0, "-b ", null, "", "Value multiplier number must be > 0");
        test.checkAdd("-b %iXy", i3, 105, 0, "-b ", null, "", "Malformed value multiplier");
        test.checkAdd("-b %iX4", i3, 105, 4, "-b ", null, "", "Result holder array must have a length >= 4");
        test.checkAdd("-b %iX4", ih, 105, 4, "-b ", null, "", "Multiplier requires result holder to be an array of length >= 4");
        test.checkAdd("-b %i #X4", ih, 105, 1, "-b ", null, "X4", null);
        test.checkAdd("-b %i #[}X4", ih, 105, 1, "-b ", null, "[}X4", null);
        test = new ArgParserTest();
        test.checkAdd("-intarg %i{1,2,(9,18],[22,27],[33,38),(45,48)} #test int arg", ih, 105, 1, "-intarg ", new RngCheck[]{new RngCheck(1L), new RngCheck(2L), new RngCheck(9L, false, 18L, true), new RngCheck(22L, true, 27L, true), new RngCheck(33L, true, 38L, false), new RngCheck(45L, false, 48L, false)}, "test int arg", null);
        MTest[] tests = new MTest[]{new MTest("-intarg 1", new Long(1L)), new MTest("-intarg 3", new MErr(114, "3")), new MTest("-intarg 9", new MErr(114, "9")), new MTest("-intarg 11", new Long(11L)), new MTest("-intarg 18", new Long(18L)), new MTest("-intarg 22", new Long(22L)), new MTest("-intarg 25", new Long(25L)), new MTest("-intarg 27", new Long(27L)), new MTest("-intarg 33", new Long(33L)), new MTest("-intarg 35", new Long(35L)), new MTest("-intarg 38", new MErr(114, "38")), new MTest("-intarg 45", new MErr(114, "45")), new MTest("-intarg 46", new Long(46L)), new MTest("-intarg 48", new MErr(114, "48")), new MTest("-intarg 100", new MErr(114, "100")), new MTest("-intarg 0xbeef", new MErr(114, "0xbeef")), new MTest("-intarg 0x2f", new Long(47L)), new MTest("-intarg 041", new Long(33L))};
        test.checkMatches(tests, false);
        test.checkAdd("-farg %f{1,2,(9,18],[22,27],[33,38),(45,48)} #test float arg", dh, 102, 1, "-farg ", new RngCheck[]{new RngCheck(1.0), new RngCheck(2.0), new RngCheck(9.0, false, 18.0, true), new RngCheck(22.0, true, 27.0, true), new RngCheck(33.0, true, 38.0, false), new RngCheck(45.0, false, 48.0, false)}, "test float arg", null);
        tests = new MTest[]{new MTest("-farg 1", new Double(1.0)), new MTest("-farg 3", new MErr(114, "3")), new MTest("-farg 9", new MErr(114, "9")), new MTest("-farg 9.0001", new Double(9.0001)), new MTest("-farg 11", new Double(11.0)), new MTest("-farg 18", new Double(18.0)), new MTest("-farg 22", new Double(22.0)), new MTest("-farg 25", new Double(25.0)), new MTest("-farg 27", new Double(27.0)), new MTest("-farg 33", new Double(33.0)), new MTest("-farg 35", new Double(35.0)), new MTest("-farg 37.9999", new Double(37.9999)), new MTest("-farg 38", new MErr(114, "38")), new MTest("-farg 45", new MErr(114, "45")), new MTest("-farg 45.0001", new Double(45.0001)), new MTest("-farg 46", new Double(46.0)), new MTest("-farg 47.9999", new Double(47.9999)), new MTest("-farg 48", new MErr(114, "48")), new MTest("-farg 100", new MErr(114, "100")), new MTest("-farg 0", new MErr(114, "0"))};
        test.checkMatches(tests, false);
        test.checkAdd("-sarg %s{1,2,(AA,AZ],[BB,BX],[C3,C8),(d5,d8)} #test string arg", s3, 115, 1, "-sarg ", new RngCheck[]{new RngCheck("1"), new RngCheck("2"), new RngCheck("AA", false, "AZ", true), new RngCheck("BB", true, "BX", true), new RngCheck("C3", true, "C8", false), new RngCheck("d5", false, "d8", false)}, "test string arg", null);
        tests = new MTest[]{new MTest("-sarg 1", "1"), new MTest("-sarg 3", new MErr(114, "3")), new MTest("-sarg AA", new MErr(114, "AA")), new MTest("-sarg AM", "AM"), new MTest("-sarg AZ", "AZ"), new MTest("-sarg BB", "BB"), new MTest("-sarg BL", "BL"), new MTest("-sarg BX", "BX"), new MTest("-sarg C3", "C3"), new MTest("-sarg C6", "C6"), new MTest("-sarg C8", new MErr(114, "C8")), new MTest("-sarg d5", new MErr(114, "d5")), new MTest("-sarg d6", "d6"), new MTest("-sarg d8", new MErr(114, "d8")), new MTest("-sarg zzz", new MErr(114, "zzz")), new MTest("-sarg 0", new MErr(114, "0"))};
        test.checkMatches(tests, false);
        test = new ArgParserTest();
        test.checkAdd("-carg %c{1,2,(a,z],['A','Z'],['\\001',\\007),(4,8)}", c3, 99, 1, "-carg ", new RngCheck[]{new RngCheck(49L), new RngCheck(50L), new RngCheck(97L, false, 122L, true), new RngCheck(65L, true, 90L, true), new RngCheck(1L, true, 7L, false), new RngCheck(52L, false, 56L, false)}, "", null);
        tests = new MTest[]{new MTest("-carg 1", new Character('1')), new MTest("-carg 3", new MErr(114, "3")), new MTest("-carg a", new MErr(114, "a")), new MTest("-carg m", new Character('m')), new MTest("-carg z", new Character('z')), new MTest("-carg A", new Character('A')), new MTest("-carg 'L'", new Character('L')), new MTest("-carg 'Z'", new Character('Z')), new MTest("-carg \\001", new Character('\u0001')), new MTest("-carg \\005", new Character('\u0005')), new MTest("-carg '\\007'", new MErr(114, "'\\007'")), new MTest("-carg '4'", new MErr(114, "'4'")), new MTest("-carg 6", new Character('6')), new MTest("-carg 8", new MErr(114, "8")), new MTest("-carg '\\012'", new MErr(114, "'\\012'")), new MTest("-carg 0", new MErr(114, "0"))};
        test.checkMatches(tests, false);
        test.checkAdd("-foo=%i{[-50,100]}", ih, 105, 1, "-foo=", new RngCheck[]{new RngCheck(-50L, true, 100L, true)}, "", null);
        tests = new MTest[]{new MTest("-foo=-51", new MErr(114, "-51")), new MTest("-foo=-0x32", new Long(-50L)), new MTest("-foo=-0x33", new MErr(114, "-0x33")), new MTest("-foo=-0777", new MErr(114, "-0777")), new MTest("-foo=-07", new Long(-7L)), new MTest("-foo=0", new Long(0L)), new MTest("-foo=100", new Long(100L)), new MTest("-foo=0x5e", new Long(94L)), new MTest("-foo=066", new Long(54L)), new MTest("-foo=06677", new MErr(114, "06677")), new MTest("-foo=0xbeef", new MErr(114, "0xbeef")), new MTest("-foo=foo", new MErr(109, "foo")), new MTest("-foo=-51d", new MErr(109, "-51d"))};
        test.checkMatches(tests, true);
        test.checkAdd("-foo2=%i", ih, 105, 1, "-foo2=", null, "", null);
        tests = new MTest[]{new MTest("-foo2=-51", new Long(-51L)), new MTest("-foo2=-0x33", new Long(-51L)), new MTest("-foo2=-0777", new Long(-511L)), new MTest("-foo2=06677", new Long(3519L)), new MTest("-foo2=0xbeef", new Long(48879L)), new MTest("-foo2=foo", new MErr(109, "foo")), new MTest("-foo2=-51d", new MErr(109, "-51d")), new MTest("-foo2=-51", new Long(-51L))};
        test.checkMatches(tests, true);
        test.checkAdd("-foo3 %iX3", i3, 105, 3, "-foo3 ", null, "", null);
        tests = new MTest[]{new MTest("-foo3 -51 678 0x45", new long[]{-51L, 678L, 69L}), new MTest("-foo3 55 16f 55", new MErr(109, "16f")), new MTest("-foo3 55 16", new MErr(118, "3"))};
        test.checkMatches(tests, false);
        Vector<String> vec = new Vector<String>(100);
        test.checkAdd("-foov3 %iX3", vec, 105, 3, "-foov3 ", null, "", null);
        tests = new MTest[]{new MTest("-foov3 -1 2 4", new long[]{-1L, 2L, 4L}, 0), new MTest("-foov3 10 3 9", new long[]{10L, 3L, 9L}, 1), new MTest("-foov3 123 1 0", new long[]{123L, 1L, 0L}, 2)};
        vec.clear();
        test.checkMatches(tests, false);
        test.checkAdd("-foov %i", vec, 105, 1, "-foov ", null, "", null);
        tests = new MTest[]{new MTest("-foov 11", new Long(11L), 0), new MTest("-foov 12", new Long(12L), 1), new MTest("-foov 13", new Long(13L), 2)};
        vec.clear();
        test.checkMatches(tests, false);
        test.checkAdd("-foo4 %i{[-50,100]}X2", i3, 105, 2, "-foo4 ", new RngCheck[]{new RngCheck(-50L, true, 100L, true)}, "", null);
        tests = new MTest[]{new MTest("-foo4 -49 78", new long[]{-49L, 78L}), new MTest("-foo4 -48 102", new MErr(114, "102"))};
        test.checkMatches(tests, false);
        test.checkAdd("-oct=%o{[-062,0144]}", ih, 111, 1, "-oct=", new RngCheck[]{new RngCheck(-50L, true, 100L, true)}, "", null);
        tests = new MTest[]{new MTest("-oct=-063", new MErr(114, "-063")), new MTest("-oct=-0x32", new MErr(109, "-0x32")), new MTest("-oct=-0777", new MErr(114, "-0777")), new MTest("-oct=-07", new Long(-7L)), new MTest("-oct=0", new Long(0L)), new MTest("-oct=100", new Long(64L)), new MTest("-oct=0xae", new MErr(109, "0xae")), new MTest("-oct=66", new Long(54L)), new MTest("-oct=06677", new MErr(114, "06677")), new MTest("-oct=0xbeef", new MErr(109, "0xbeef")), new MTest("-oct=foo", new MErr(109, "foo")), new MTest("-oct=-51d", new MErr(109, "-51d")), new MTest("-oct=78", new MErr(109, "78"))};
        test.checkMatches(tests, true);
        test.checkAdd("-oct2=%o", ih, 111, 1, "-oct2=", null, "", null);
        tests = new MTest[]{new MTest("-oct2=-063", new Long(-51L)), new MTest("-oct2=-0777", new Long(-511L)), new MTest("-oct2=06677", new Long(3519L))};
        test.checkMatches(tests, true);
        test.checkAdd("-dec=%d{[-0x32,0x64]}", ih, 100, 1, "-dec=", new RngCheck[]{new RngCheck(-50L, true, 100L, true)}, "", null);
        tests = new MTest[]{new MTest("-dec=-063", new MErr(114, "-063")), new MTest("-dec=-0x32", new MErr(109, "-0x32")), new MTest("-dec=-0777", new MErr(114, "-0777")), new MTest("-dec=-07", new Long(-7L)), new MTest("-dec=0", new Long(0L)), new MTest("-dec=100", new Long(100L)), new MTest("-dec=0xae", new MErr(109, "0xae")), new MTest("-dec=66", new Long(66L)), new MTest("-dec=06677", new MErr(114, "06677")), new MTest("-dec=0xbeef", new MErr(109, "0xbeef")), new MTest("-dec=foo", new MErr(109, "foo")), new MTest("-dec=-51d", new MErr(109, "-51d"))};
        test.checkMatches(tests, true);
        test.checkAdd("-dec2=%d", ih, 100, 1, "-dec2=", null, "", null);
        tests = new MTest[]{new MTest("-dec2=-063", new Long(-63L)), new MTest("-dec2=-0777", new Long(-777L)), new MTest("-dec2=06677", new Long(6677L))};
        test.checkMatches(tests, true);
        test.checkAdd("-hex=%x{[-0x32,0x64]}", ih, 120, 1, "-hex=", new RngCheck[]{new RngCheck(-50L, true, 100L, true)}, "", null);
        tests = new MTest[]{new MTest("-hex=-06", new Long(-6L)), new MTest("-hex=-0x3g2", new MErr(109, "-0x3g2")), new MTest("-hex=-0777", new MErr(114, "-0777")), new MTest("-hex=-017", new Long(-23L)), new MTest("-hex=0", new Long(0L)), new MTest("-hex=64", new Long(100L)), new MTest("-hex=5e", new Long(94L)), new MTest("-hex=66", new MErr(114, "66")), new MTest("-hex=06677", new MErr(114, "06677")), new MTest("-hex=0xbeef", new MErr(109, "0xbeef")), new MTest("-hex=foo", new MErr(109, "foo")), new MTest("-hex=-51d", new MErr(114, "-51d")), new MTest("-hex=-51g", new MErr(109, "-51g")), new MTest("-hex=", new MErr(99, ""))};
        test.checkMatches(tests, true);
        test.checkAdd("-hex2=%x", ih, 120, 1, "-hex2=", null, "", null);
        tests = new MTest[]{new MTest("-hex2=-0777", new Long(-1911L)), new MTest("-hex2=66", new Long(102L)), new MTest("-hex2=06677", new Long(26231L)), new MTest("-hex2=-51d", new Long(-1309L))};
        test.checkMatches(tests, true);
        test.checkAdd("-char=%c{['b','m']}", ch, 99, 1, "-char=", new RngCheck[]{new RngCheck(98L, true, 109L, true)}, "", null);
        tests = new MTest[]{new MTest("-char=a", new MErr(114, "a")), new MTest("-char=b", new Character('b')), new MTest("-char='b'", new Character('b')), new MTest("-char='b'", new Character('b')), new MTest("-char='a'", new MErr(114, "'a'")), new MTest("-char=b", new Character('b')), new MTest("-char=a", new MErr(114, "a")), new MTest("-char=m", new Character('m')), new MTest("-char=z", new MErr(114, "z")), new MTest("-char=bb", new MErr(109, "bb")), new MTest("-char='b", new MErr(109, "'b")), new MTest("-char='", new MErr(109, "'")), new MTest("-char=a'", new MErr(109, "a'"))};
        test.checkMatches(tests, true);
        test.checkAdd("-char2=%c", ch, 99, 1, "-char2=", null, "", null);
        tests = new MTest[]{new MTest("-char2=a", new Character('a')), new MTest("-char2='a'", new Character('a')), new MTest("-char2=a", new Character('a')), new MTest("-char2=z", new Character('z'))};
        test.checkMatches(tests, true);
        test.checkAdd("-charv3 %cX3", vec, 99, 3, "-charv3 ", null, "", null);
        tests = new MTest[]{new MTest("-charv3 a b c", new char[]{'a', 'b', 'c'}, 0), new MTest("-charv3 'g' f '\\n'", new char[]{'g', 'f', '\n'}, 1), new MTest("-charv3 1 \u0001 3", new char[]{'1', '\u0001', '3'}, 2)};
        vec.clear();
        test.checkMatches(tests, false);
        test.checkAdd("-charv=%c", vec, 99, 1, "-charv=", null, "", null);
        tests = new MTest[]{new MTest("-charv=d", new Character('d'), 0), new MTest("-charv='g'", new Character('g'), 1), new MTest("-charv=I", new Character('I'), 2)};
        vec.clear();
        test.checkMatches(tests, true);
        test.checkAdd("-bool=%b{true}", bh, 98, 1, "-bool=", new RngCheck[]{new RngCheck(true)}, "", null);
        tests = new MTest[]{new MTest("-bool=true", new Boolean(true)), new MTest("-bool=false", new MErr(114, "false")), new MTest("-bool=fals", new MErr(109, "fals")), new MTest("-bool=falsem", new MErr(109, "falsem")), new MTest("-bool=truex", new MErr(109, "truex")), new MTest("-bool=foo", new MErr(109, "foo")), new MTest("-bool=1", new MErr(109, "1"))};
        test.checkMatches(tests, true);
        test.checkAdd("-boo2=%b{true,false}", bh, 98, 1, "-boo2=", new RngCheck[]{new RngCheck(true), new RngCheck(false)}, "", null);
        tests = new MTest[]{new MTest("-boo2=true", new Boolean(true)), new MTest("-boo2=false", new Boolean(false))};
        test.checkMatches(tests, true);
        test.checkAdd("-boo3=%b", bh, 98, 1, "-boo3=", null, "", null);
        tests = new MTest[]{new MTest("-boo3=true", new Boolean(true)), new MTest("-boo3=false", new Boolean(false))};
        test.checkMatches(tests, true);
        test.checkAdd("-boo3 %bX3", b3, 98, 3, "-boo3 ", null, "", null);
        tests = new MTest[]{new MTest("-boo3 true false true", new boolean[]{true, false, true}), new MTest("-boo3 true fals true", new MErr(109, "fals"))};
        test.checkMatches(tests, false);
        test.checkAdd("-boov3 %bX3", vec, 98, 3, "-boov3 ", null, "", null);
        tests = new MTest[]{new MTest("-boov3 true true false", new boolean[]{true, true, false}, 0), new MTest("-boov3 false false true", new boolean[]{false, false, true}, 1)};
        vec.clear();
        test.checkMatches(tests, false);
        test.checkAdd("-boov %b", vec, 98, 1, "-boov ", null, "", null);
        tests = new MTest[]{new MTest("-boov true", new Boolean(true), 0), new MTest("-boov false", new Boolean(false), 1), new MTest("-boov true", new Boolean(true), 2)};
        vec.clear();
        test.checkMatches(tests, false);
        test.checkAdd("-v3 %vX2", b3, 118, 2, "-v3 ", null, "", null);
        tests = new MTest[]{new MTest("-v3", new boolean[]{true, true})};
        test.checkMatches(tests, false);
        test.checkAdd("-vf %v{false,true}X2", b3, 118, 2, "-vf ", new RngCheck[]{new RngCheck(false), new RngCheck(true)}, "", null);
        tests = new MTest[]{new MTest("-vf", new boolean[]{false, false})};
        test.checkMatches(tests, false);
        test.checkAdd("-str=%s{(john,zzzz]}", sh, 115, 1, "-str=", new RngCheck[]{new RngCheck("john", false, "zzzz", true)}, "", null);
        tests = new MTest[]{new MTest("-str=john", new MErr(114, "john")), new MTest("-str=joho ", "joho "), new MTest("-str=joho ", "joho "), new MTest("-str=zzzz", "zzzz"), new MTest("-str= joho", new MErr(114, " joho")), new MTest("-str=jnhn ", new MErr(114, "jnhn ")), new MTest("-str=zzzzz", new MErr(114, "zzzzz")), new MTest("-str=\"joho\"", new MErr(114, "\"joho\"")), new MTest("-str=\"joho", new MErr(114, "\"joho")), new MTest("-str=joho j", "joho j")};
        test.checkMatches(tests, true);
        test.checkAdd("-str2=%s", sh, 115, 1, "-str2=", null, "", null);
        tests = new MTest[]{new MTest("-str2= jnhn", " jnhn"), new MTest("-str2=zzzzz", "zzzzz")};
        test.checkMatches(tests, true);
        test.checkAdd("-str3 %sX3", s3, 115, 3, "-str3 ", null, "", null);
        tests = new MTest[]{new MTest("-str3 foo bar johnny", new String[]{"foo", "bar", "johnny"}), new MTest("-str3 zzzzz \"bad foo", new String[]{"zzzzz", "\"bad", "foo"})};
        test.checkMatches(tests, false);
        test.checkAdd("-strv3 %sX3", vec, 115, 3, "-strv3 ", null, "", null);
        tests = new MTest[]{new MTest("-strv3 foo bar \"hihi\"", new String[]{"foo", "bar", "\"hihi\""}, 0), new MTest("-strv3 a 123 gg", new String[]{"a", "123", "gg"}, 1)};
        vec.clear();
        test.checkMatches(tests, false);
        test.checkAdd("-strv=%s", vec, 115, 1, "-strv=", null, "", null);
        tests = new MTest[]{new MTest("-strv=d", "d", 0), new MTest("-strv='g'", "'g'", 1), new MTest("-strv=\\111", "\\111", 2)};
        vec.clear();
        test.checkMatches(tests, true);
        test.checkAdd("-float=%f{(-0.001,1000.0]}", dh, 102, 1, "-float=", new RngCheck[]{new RngCheck(-0.001, false, 1000.0, true)}, "", null);
        tests = new MTest[]{new MTest("-float=-0.000999", new Double(-9.99E-4)), new MTest("-float=1e-3", new Double(0.001)), new MTest("-float=12.33e1", new Double(123.3)), new MTest("-float=1e3", new Double(1000.0)), new MTest("-float=1000.000", new Double(1000.0)), new MTest("-float=-0.001", new MErr(114, "-0.001")), new MTest("-float=-1e-3", new MErr(114, "-1e-3")), new MTest("-float=1000.001", new MErr(114, "1000.001")), new MTest("-float=.", new MErr(109, ".")), new MTest("-float=  124.5 ", new Double(124.5)), new MTest("-float=124.5x", new MErr(109, "124.5x")), new MTest("-float= foo ", new MErr(109, " foo ")), new MTest("-float=1e1", new Double(10.0)), new MTest("-float=1e ", new MErr(109, "1e "))};
        test.checkMatches(tests, true);
        test.checkAdd("-float2=%f", dh, 102, 1, "-float2=", null, "", null);
        tests = new MTest[]{new MTest("-float2=-0.001", new Double(-0.001)), new MTest("-float2=-1e-3", new Double(-0.001)), new MTest("-float2=1000.001", new Double(1000.001))};
        test.checkMatches(tests, true);
        test.checkAdd("-f3 %fX3", d3, 102, 3, "-f3 ", null, "", null);
        tests = new MTest[]{new MTest("-f3 -0.001 1.23e5 -9.88e-4", new double[]{-0.001, 123000.0, -9.88E-4}), new MTest("-f3 7.88 foo 9.0", new MErr(109, "foo")), new MTest("-f3 7.88 . 9.0", new MErr(109, ".")), new MTest("-f3 7.88 3.0 9.0x", new MErr(109, "9.0x"))};
        test.checkMatches(tests, false);
        test.checkAdd("-fv3 %fX3", vec, 102, 3, "-fv3 ", null, "", null);
        tests = new MTest[]{new MTest("-fv3 1.0 3.444 6.7", new double[]{1.0, 3.444, 6.7}, 0), new MTest("-fv3 13e-5 145.678 0.0001e45", new double[]{1.3E-4, 145.678, 1.0E41}, 1), new MTest("-fv3 11.11 3.1245 -1e-4", new double[]{11.11, 3.1245, -1.0E-4}, 2), new MTest("-fv3 1.0 2 3", new double[]{1.0, 2.0, 3.0}, 3)};
        vec.clear();
        test.checkMatches(tests, false);
        test.checkAdd("-fv %f", vec, 102, 1, "-fv ", null, "", null);
        tests = new MTest[]{new MTest("-fv -15.1234", new Double(-15.1234), 0), new MTest("-fv -1.234e-7", new Double(-1.234E-7), 1), new MTest("-fv 0.001111", new Double(0.001111), 2)};
        vec.clear();
        test.checkMatches(tests, false);
        IntHolder intHolder = new IntHolder();
        StringHolder strHolder = new StringHolder();
        ArgParser parser = new ArgParser("test");
        parser.addOption("-foo %d #an int", intHolder);
        parser.addOption("-bar %s #a string", strHolder);
        args = new String[]{"zzz", "-cat", "-foo", "123", "yyy", "-bar", "xxxx", "xxx"};
        String[] unmatchedCheck = new String[]{"zzz", "-cat", "yyy", "xxx"};
        String[] unmatched = parser.matchAllArgs(args, 0, 0);
        test.checkStringArray("Unmatched args:", unmatched, unmatchedCheck);
        vec.clear();
        int i = 0;
        while (i < args.length) {
            try {
                i = parser.matchArg(args, i);
                if (parser.getUnmatchedArgument() == null) continue;
                vec.add(parser.getUnmatchedArgument());
            }
            catch (Exception e) {}
        }
        unmatched = vec.toArray(new String[0]);
        test.checkStringArray("My unmatched args:", unmatched, unmatchedCheck);
        System.out.println("\nPassed\n");
    }

    static class MTest {
        String args;
        Object result;
        int resultIdx;

        MTest(String args, Object result) {
            this(args, result, -1);
        }

        MTest(String args, Object result, int resultIdx) {
            this.args = args;
            this.result = result;
            this.resultIdx = resultIdx;
        }
    }

    static class MErr {
        int code;
        String valStr;

        MErr(int code, String valStr) {
            this.code = code;
            this.valStr = valStr;
        }
    }

    static class RngCheck {
        ArgParser.RangePnt low = null;
        ArgParser.RangePnt high = null;
        int type;

        RngCheck(String s) {
            this.low = new ArgParser.RangePnt(s, true);
            this.type = 115;
        }

        RngCheck(double d) {
            this.low = new ArgParser.RangePnt(d, true);
            this.type = 100;
        }

        RngCheck(long l) {
            this.low = new ArgParser.RangePnt(l, true);
            this.type = 108;
        }

        RngCheck(boolean b) {
            this.low = new ArgParser.RangePnt(b, true);
            this.type = 98;
        }

        RngCheck(String s1, boolean c1, String s2, boolean c2) {
            this.low = new ArgParser.RangePnt(s1, c1);
            this.high = new ArgParser.RangePnt(s2, c2);
            this.type = 115;
        }

        RngCheck(double d1, boolean c1, double d2, boolean c2) {
            this.low = new ArgParser.RangePnt(d1, c1);
            this.high = new ArgParser.RangePnt(d2, c2);
            this.type = 100;
        }

        RngCheck(long l1, boolean c1, long l2, boolean c2) {
            this.low = new ArgParser.RangePnt(l1, c1);
            this.high = new ArgParser.RangePnt(l2, c2);
            this.type = 108;
        }

        void check(ArgParser.RangeAtom ra) {
            ArgParserTest.verify(ra.low == null == (this.low == null), "(ra.low==null)=" + (ra.low == null) + "(low==null)=" + (this.low == null));
            ArgParserTest.verify(ra.high == null == (this.high == null), "(ra.high==null)=" + (ra.high == null) + "(high==null)=" + (this.high == null));
            if (ra.low != null) {
                switch (this.type) {
                    case 108: {
                        ArgParserTest.verify(ra.low.lval == this.low.lval, "ra.low=" + ra.low + " low=" + this.low);
                        break;
                    }
                    case 100: {
                        ArgParserTest.verify(ra.low.dval == this.low.dval, "ra.low=" + ra.low + " low=" + this.low);
                        break;
                    }
                    case 115: {
                        ArgParserTest.verify(ra.low.sval.equals(this.low.sval), "ra.low=" + ra.low + " low=" + this.low);
                        break;
                    }
                    case 98: {
                        ArgParserTest.verify(ra.low.bval == this.low.bval, "ra.low=" + ra.low + " low=" + this.low);
                    }
                }
                ArgParserTest.verify(ra.low.closed == this.low.closed, "ra.low=" + ra.low + " low=" + this.low);
            }
            if (ra.high != null) {
                switch (this.type) {
                    case 108: {
                        ArgParserTest.verify(ra.high.lval == this.high.lval, "ra.high=" + ra.high + " high=" + this.high);
                        break;
                    }
                    case 100: {
                        ArgParserTest.verify(ra.high.dval == this.high.dval, "ra.high=" + ra.high + " high=" + this.high);
                        break;
                    }
                    case 115: {
                        ArgParserTest.verify(ra.high.sval.equals(this.high.sval), "ra.high=" + ra.high + " high=" + this.high);
                        break;
                    }
                    case 98: {
                        ArgParserTest.verify(ra.high.bval == this.high.bval, "ra.high=" + ra.high + " high=" + this.high);
                    }
                }
                ArgParserTest.verify(ra.high.closed == this.high.closed, "ra.high=" + ra.high + " high=" + this.high);
            }
        }
    }
}

