cookieMonsterBys1tony.utils =
{
    _bundle: null,

    init: function()
    {
        this._bundle = document.getElementById("cookiemonster-s1tony-preferences");
	},
	
	getBrowserFromChannel: function (aChannel)
	{
  		try
		{
		    var notificationCallbacks = 
		      aChannel.notificationCallbacks ? aChannel.notificationCallbacks : aChannel.loadGroup.notificationCallbacks;
		
		    if (!notificationCallbacks)
		      return null;

		    var domWin = notificationCallbacks.getInterface(Components.interfaces.nsIDOMWindow);
		    return gBrowser.getBrowserForDocument(domWin.top.document);
	  	}
	  	catch (e)
	  	{
		    dump(e + "\n");
		    return null;
	  	}
	},
	
	isUrlMultipleTabs: function(aHost /*, checkDomain*/)
	{
		var numberTabs = 0;
		var checkDomain = arguments[1] ? Boolean(arguments[1]) : false;
		var num = gBrowser.browsers.length;

		if (!checkDomain)
		{
			for (var i = 0; i < num; i++)
			{
			 	var b = gBrowser.getBrowserAtIndex(i);
			 	
			 	//alert("browser host " + i + " " + b.currentURI.asciiHost + "  host: " + aHost);
			 		
				if (b.currentURI.asciiHost === aHost)
				{
					if (++numberTabs >= 2)
					{
						break;
					}
				}
			}
		}
		else
		{
			var secondLevelHost = cookieMonsterBys1tony.cookieInfo.getSecondLevelHost(aHost);
			
			for (var i = 0; i < num; i++)
			{
			 	var b = gBrowser.getBrowserAtIndex(i);
			 	var secondLevelBrowserHost = cookieMonsterBys1tony.cookieInfo.getSecondLevelHost(b.currentURI.asciiHost);		 	
			 		
				if (secondLevelBrowserHost === secondLevelHost)
				{
					if (++numberTabs >= 2)
					{
						break;
					}
				}
			}			
		}
		
		return (numberTabs >= 2);
	},
	
	createURIFromHostName: function (aHostName /*, isPrePath*/)
	{
		var newHost = null;
		var isPrePath = arguments[1] ? Boolean(arguments[1]) : false;

		try
        {
			var ioService = Components.classes["@mozilla.org/network/io-service;1"]
	            .getService(Components.interfaces.nsIIOService);
            
			var hostName = isPrePath ? aHostName : "http://" + aHostName;
			newHost = ioService.newURI(hostName, null, null);
        }
        catch(ex)
        {
            var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                .getService(Components.interfaces.nsIPromptService);
            var message = this._bundle.getString("invalidURI");
            var title = this._bundle.getString("invalidURITitle");
            promptService.alert(window, title, message);
        }
        
        return newHost;
	}
}
