## Example
```
pq('a')->attr('href', 'newVal')->removeClass('className')->html('newHtml')->...
```
# Table of Contents
  * [Attr](#Attr.md)
  * [Class](#Class.md)
  * [HTML](#HTML.md)
  * [Text](#Text.md)
  * [Value](#Value.md)
## Attr
  * **[attr](http://docs.jquery.com/Attributes/attr)**[($name)](http://docs.jquery.com/Attributes/attr) Access a property on the first matched element. This method makes it easy to retrieve a property value from the first matched element. If the element does not have an attribute with such a name, undefined is returned.
  * **[attr](http://docs.jquery.com/Attributes/attr)**[($properties)](http://docs.jquery.com/Attributes/attr) Set a key/value object as properties to all matched elements.
  * **[attr](http://docs.jquery.com/Attributes/attr)**[($key, $value)](http://docs.jquery.com/Attributes/attr) Set a single property to a value, on all matched elements.
  * **[attr](http://docs.jquery.com/Attributes/attr)**[($key, $fn)](http://docs.jquery.com/Attributes/attr) Set a single property to a computed value, on all matched elements.
  * **[removeAttr](http://docs.jquery.com/Attributes/removeAttr)**[($name)](http://docs.jquery.com/Attributes/removeAttr) Remove an attribute from each of the matched elements.
## Class
  * **[addClass](http://docs.jquery.com/Attributes/addClass)**[($class)](http://docs.jquery.com/Attributes/addClass) Adds the specified class(es) to each of the set of matched elements.
  * **[hasClass](http://docs.jquery.com/Attributes/hasClass)**[($class)](http://docs.jquery.com/Attributes/hasClass) Returns true if the specified class is present on at least one of the set of matched elements.
  * **[removeClass](http://docs.jquery.com/Attributes/removeClass)**[($class)](http://docs.jquery.com/Attributes/removeClass) Removes all or the specified class(es) from the set of matched elements.
  * **[toggleClass](http://docs.jquery.com/Attributes/toggleClass)**[($class)](http://docs.jquery.com/Attributes/toggleClass) Adds the specified class if it is not present, removes the specified class if it is present.
## HTML
  * **[html](http://docs.jquery.com/Attributes/html)**[()](http://docs.jquery.com/Attributes/html) Get the html contents (innerHTML) of the first matched element. This property is not available on XML documents (although it will work for XHTML documents).
  * **[html](http://docs.jquery.com/Attributes/html)**[($val)](http://docs.jquery.com/Attributes/html) Set the html contents of every matched element. This property is not available on XML documents (although it will work for XHTML documents).
## Text
  * **[text](http://docs.jquery.com/Attributes/text)**[()](http://docs.jquery.com/Attributes/text) Get the combined text contents of all matched elements.
  * **[text](http://docs.jquery.com/Attributes/text)**[($val)](http://docs.jquery.com/Attributes/text) Set the text contents of all matched elements.
## Value
  * **[val](http://docs.jquery.com/Attributes/val)**[()](http://docs.jquery.com/Attributes/val) Get the content of the value attribute of the first matched element.
  * **[val](http://docs.jquery.com/Attributes/val)**[($val)](http://docs.jquery.com/Attributes/val) Set the value attribute of every matched element.
  * **[val](http://docs.jquery.com/Attributes/val)**[($val)](http://docs.jquery.com/Attributes/val) Checks, or selects, all the radio buttons, checkboxes, and select options that match the set of values.

Read more at [Attributes](http://docs.jquery.com/Attributes) section on [jQuery Documentation Site](http://docs.jquery.com/).