# CiviCRM 5.10.0

Released February 6, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Support custom-data sub-type on entity-form (for activity/relationship types)
  ([13311](https://github.com/civicrm/civicrm-core/pull/13311))**

  This change makes it so that users can see and edit custom data for entity
  sub-types (like activity types and relationship types).

- **[dev/translation#13](https://lab.civicrm.org/dev/translation/issues/13)
  Language switcher for all
  ([13240](https://github.com/civicrm/civicrm-core/pull/13240))**

  This change introduces a new setting to the settings page for Localization "UI
  Languages" for users in monolingual mode (not using multilingual). Configuring
  this setting results in the Language Switcher block being shown (same as in
  multilingual mode).

- **[dev/core#561](https://lab.civicrm.org/dev/core/issues/561) Replace
  jcalendar instances with datepicker
  ([13241](https://github.com/civicrm/civicrm-core/pull/13241) and
  [13299](https://github.com/civicrm/civicrm-core/pull/13299)) -- CONTINUED
  WORK**

  These changes update the Scheduled Reminders Form and the Activity date and
  case start date fields to use the new datepicker widget.

- **Improved support for case variability in UF API calls.
  ([13343](https://github.com/civicrm/civicrm-core/pull/13343))**

  This change makes it so that the API will accept "UFgroup" and "ufgroup" as
  the entity.

- **Optimize CRM_Utils_String::ellipsify() method
  ([13347](https://github.com/civicrm/civicrm-core/pull/13347))**

  This change improves performance for the function that truncates a string and
  adds an ellipsis on the end.

### CiviCase

- **[dev/core#564](https://lab.civicrm.org/dev/core/issues/564) Differentiate
  case relationships in Contact Summary page
  ([13189](https://github.com/civicrm/civicrm-core/pull/13189))**

  On the Relationship tab of a contact, this change adds a case icon for each
  case relationship to denote that the relationship is related to a case. This
  icon is linked to the case so one can easily access the case from the
  relationship.

- **Cache case count when getting list of cases so query is executed once
  instead of three times
  ([13368](https://github.com/civicrm/civicrm-core/pull/13368))**

  This change improves performance on the Case Dashboard when listing cases.

### CiviContribute

- **Add default of TRUE for is_active on PaymentProcessor.create api.
  ([13291](https://github.com/civicrm/civicrm-core/pull/13291))**

  This change makes it so that when using the API with the entity Payment
  Processor and the action create, the parameter "is_active" defaults to TRUE
  like the UFGroup, CustomGroup, ComtributionPage entities do.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[dev/core#695](https://lab.civicrm.org/dev/core/issues/695) Custom Search
  results selection failure and
  [dev/core#679](https://lab.civicrm.org/dev/core/issues/679) Groups and Tags
  affect search results when using Search Builder
  ([13533](https://github.com/civicrm/civicrm-core/pull/13533))**

  This resolves some search regressions introduced in 5.9.0 relating to caching
  and custom searches.

- **[dev/core#192](https://lab.civicrm.org/dev/core/issues/192) - Search builder
  fails for != smart group filter
  ([12344](https://github.com/civicrm/civicrm-core/pull/12344))**

  This change makes it so that when using the Search Builder with a filter
  "Contacts -> Group -> !- -> Smart group" the != operator is respected.

- **[dev/core#485](https://lab.civicrm.org/dev/core/issues/485) New
  Organization's profile: From time to time data in the field "Website" is
  deleted if nothing choose in the drop-down "Website Type"
  ([13170](https://github.com/civicrm/civicrm-core/pull/13170))**

  This change fixes a bug when editing a contact where if a user enters a
  Website but no Website Type, the Website was not saved, so that the website is
  saved.

- **[dev/core#491](https://lab.civicrm.org/dev/core/issues/491) Report results
  don't show inactive campaigns
  ([13380](https://github.com/civicrm/civicrm-core/pull/13380),
  [13321](https://github.com/civicrm/civicrm-core/pull/13321),
  [13341](https://github.com/civicrm/civicrm-core/pull/13341),
  [13281](https://github.com/civicrm/civicrm-core/pull/13281),
  [13231](https://github.com/civicrm/civicrm-core/pull/13231),
  [13243](https://github.com/civicrm/civicrm-core/pull/13243),
  [13358](https://github.com/civicrm/civicrm-core/pull/13358),
  [13379](https://github.com/civicrm/civicrm-core/pull/13379),
  [13376](https://github.com/civicrm/civicrm-core/pull/13376),
  [13356](https://github.com/civicrm/civicrm-core/pull/13356),
  [13348](https://github.com/civicrm/civicrm-core/pull/13348) and
  [13351](https://github.com/civicrm/civicrm-core/pull/13351))**

  This change updates the following reports: Member Summary, Pledged but not
  Paid, SYBUNT, Member Detail, Participant Listing, Pledge Detail, Contribution
  (org), Household Summary, and Soft Credit to include a filter for active vs
  disabled campaigns and generally simplifies the campaign related code on these
  reports.

- **[dev/core#592](https://lab.civicrm.org/dev/core/issues/592)
  ArgumentCountError: Too few arguments to function CiviCRM_API3_Exception...
  ([13263](https://github.com/civicrm/civicrm-core/pull/13263))**

  This change fixes a bug where an "ArgumntCountError" was being thrown whenever
  an error was thrown so that only the error is thrown.

- **[dev/core#610](https://lab.civicrm.org/dev/core/issues/610) Page title
  displays twice if the activity type is set in Activity form
  ([13339](https://github.com/civicrm/civicrm-core/pull/13339))**

  This change ensures that on the new or edit activity form the title is only
  shown once. Before this change if the Activity Type was set the title would
  show up twice.

- **[dev/core#622](https://lab.civicrm.org/dev/core/issues/622) User Dashboard
  doesn't show Edit Contact Information link
  ([13375](https://github.com/civicrm/civicrm-core/pull/13375))**

  This change makes it so that the Edit Contact information link displays on the
  User Dashboard.

- **[dev/core#660](https://lab.civicrm.org/dev/core/issues/660) Fatal DB Error:
  already exists on event registration/contribution pages when profile has user
  creation ([13451](https://github.com/civicrm/civicrm-core/pull/13451))**

  This change fixes a bug where if Anonymous users have ACLs to see a contact
  they cannot register for an event so that Anonymous users with ACLs to se a
  contact can register for events.

- **Fix PHP 7.2 countable warning
  ([13414](https://github.com/civicrm/civicrm-core/pull/13414))**

- **Bump Minimum Required PHP to be 5.6
  ([13309](https://github.com/civicrm/civicrm-core/pull/13309))**

- **Fix PHP 7 strict warnings CRM_Core_DAO::getContactIDsFromComponent passed by
  reference ([13295](https://github.com/civicrm/civicrm-core/pull/13295))**

- **Generalise the UsersTableName Setting name to support Backdrop
  ([13292](https://github.com/civicrm/civicrm-core/pull/13292))**

- **Fix duplicate merge to not disregard zero values.
  ([12669](https://github.com/civicrm/civicrm-core/pull/12669))**

- **Search Builder fails with an error when searching for State if the location
  type differs from the display name.
  ([13313](https://github.com/civicrm/civicrm-core/pull/13313))**

- **Installer: PHP 7.2 compatibility fixes
  ([13326](https://github.com/civicrm/civicrm-core/pull/13326))**

  This change fixes some php countable warnings thrown for users installing
  using PHP 7.2.

- **Export merge to household - fix DB error relating to fields too long for
  table. ([13338](https://github.com/civicrm/civicrm-core/pull/13338))**

  This change fixes a fatal error when trying to combine/merge households and
  'primary fields' on some mysql configs

- **Fix notice on first loading activity search form
  ([13378](https://github.com/civicrm/civicrm-core/pull/13378))**

- **Fix verbiage for Edit Contact Information title
  ([13352](https://github.com/civicrm/civicrm-core/pull/13352))**

  On the User Dashboard this changes updates the link to edit a users contact
  from "Edit Relationship" to "Edit Contact Information".

- **Fix verbiage for Dashboard title
  ([13349](https://github.com/civicrm/civicrm-core/pull/13349))**

  This change updates the "User Dashboard" "Relationships" section Dashboard
  links to use the title "Dashboard" instead of "Edit Relationship".

### CiviCase

- **[dev/core#454](https://lab.civicrm.org/dev/core/issues/454) CiviCase access
  to activities permission discrepancy
  ([12995](https://github.com/civicrm/civicrm-core/pull/12995))**

  This change standardizes the permissioning of CiviCase so that users with the
  permission "access my cases and activities" or "access all cases and
  activities" can view appropriate case activities. Before this change the
  permissions needed to view case activities were inconsistent.

- **[dev/core#603](https://lab.civicrm.org/dev/core/issues/603) DB error on Case
  Summary report ([13296](https://github.com/civicrm/civicrm-core/pull/13296))**

  This fixes a bug where running the Case Summary Report with no changes to the
  default settigns would result in a warning message so that the default
  settings for the Case Summary Report result in the report running as expected.

- **[dev/core#625](https://lab.civicrm.org/dev/core/issues/625) DB error on Case
  Summary report ([13359](https://github.com/civicrm/civicrm-core/pull/13359))**

  This change fixes a bug in the Case Summary Report where running the report
  without the Columns "Staff Member" and "Relationship" but with a filter on
  "Active Relationships?" resulted in a DB Error so that one can run this report
  with this configuration.

- **Fix broken case activity date filter
  ([13449](https://github.com/civicrm/civicrm-core/pull/13449))**

  This change fixes a bug on the Case Summary Screen where searching activities
  using the Activity Date filters (From or To) would result in a database error.

- **Standardize letter case
  ([13245](https://github.com/civicrm/civicrm-core/pull/13245))**

  This change updates the text for the Case Task "Print/merge Document" to
  "Print/merge document".

- **Revert to showing overdue activities on a case first
  ([13360](https://github.com/civicrm/civicrm-core/pull/13360))**

- **Don't crash with missing class if action is not defined when opening new
  case ([13336](https://github.com/civicrm/civicrm-core/pull/13336))**

### CiviContribute

- **[dev/core#680](https://lab.civicrm.org/dev/core/issues/680) "Date Received"
  for contributions no longer mandatory, also breaks financial transactions
  ([13537](https://github.com/civicrm/civicrm-core/pull/13537))**

- **[dev/core#651](https://lab.civicrm.org/dev/core/issues/651) Error exporting
  contributions with soft credits
  ([13536](https://github.com/civicrm/civicrm-core/pull/13536))**

- **[dev/core#620](https://lab.civicrm.org/dev/core/issues/620) Unable to show
  custom fields on Repeat Contributions Report
  ([13350](https://github.com/civicrm/civicrm-core/pull/13350))**

  This change fixes a bug where selecting a custom field column on a Repeat
  Contributions report would result in an error so that one can use a custom
  field as a column in a Repeat Contributions report.

- **[dev/core#621](https://lab.civicrm.org/dev/core/issues/621) Price field
  option 9 Decimal Places in GUI
  ([13355](https://github.com/civicrm/civicrm-core/pull/13355))**

  This change makes it so that the "Option Amount" field on the "Edit Price
  Option" form shows only two decimal places, before this change it showed 9
  decimal places.

- **Unable to mark price set field as inactive
  ([13257](https://github.com/civicrm/civicrm-core/pull/13257))**

  This change ensures that when on the "Edit Price Field" form one can save
  changes to the "Active?" field.

- **Display self-service links in email receipts based on payment processor
  capabilities ([13215](https://github.com/civicrm/civicrm-core/pull/13215))**

- **On the Contribution Detail Report link the Amount field to the contribution
  ([13316](https://github.com/civicrm/civicrm-core/pull/13316))**

- **Declare 'amount' as required on ContributionRecur api
  ([13290](https://github.com/civicrm/civicrm-core/pull/13290))**

### CiviEvent

- **[dev/core#653](https://lab.civicrm.org/dev/core/issues/653) New Events
  defaulting to event template after first page
  ([13478](https://github.com/civicrm/civicrm-core/pull/13478))**

  This resolves a regression introduced in 5.9.0 where creating a new event would
  instead create a new event template.

### CiviMail

- **[dev/report#5](CANNOT FIND THIS GITLAB ISSUE) - Fix mailing report unique
  count issue ([13322](https://github.com/civicrm/civicrm-core/pull/13322))**

  This fixes the count when viewing the report of Unique Opens for a Mailing.

- **[dev/mail#35](https://lab.civicrm.org/dev/mail/issues/35) Public View link
  does not show from Scheduled and Sent screen
  ([13354](https://github.com/civicrm/civicrm-core/pull/13354))**

  This change makes it so that one can click the Public View url on the
  Scheduled and Sent mailing screen.

- **[dev/core#623](https://lab.civicrm.org/dev/core/issues/623)
  civicrm_mailing_bounce_type.threshold = 30 for 'Away' is that correct?
  ([13366](https://github.com/civicrm/civicrm-core/pull/13366) and
  [13362](https://github.com/civicrm/civicrm-core/pull/13362))**

  This change ensures that the CiviMail mailing bounce threshold for bounces of
  the type "Away" is set to be 30, prior to this change some instances had the
  threshold set to 3.

### Joomla Integration

- **[dev/joomla#3](https://lab.civicrm.org/dev/joomla/issues/3) Recipients are
  not shown when creating / editing mailings
  ([13294](https://github.com/civicrm/civicrm-core/pull/13294))**

### Wordpress Integration

- **[dev/wordpress#16](https://lab.civicrm.org/dev/wordpress/issues/16) Fatal
  error with some versions of PHP
  ([143](https://github.com/civicrm/civicrm-wordpress/pull/143))**

  This fixes a bug where installing the CiviCRM plugin on a Wordpress
  site using PHP 7.2.12 would result in a fatal error.

## <a name="misc"></a>Miscellany

- **(NFC) Fix PHP7.2 Count error on test testImportParserWtihEmployeeOfRelation…
  ([13247](https://github.com/civicrm/civicrm-core/pull/13247))**

- **(NFC) Update Copyright in FiveTen upgrade file to be 2019
  ([13268](https://github.com/civicrm/civicrm-core/pull/13268))**

- **(NFC) Just some additional package metadata
  ([13293](https://github.com/civicrm/civicrm-core/pull/13293))**

- **(NFC) Improved documentation of crmPageTitle directive.
  ([13337](https://github.com/civicrm/civicrm-core/pull/13337))**

- **(NFC) Minor tweaks to docblocks on opencase form
  ([13335](https://github.com/civicrm/civicrm-core/pull/13335))**

- **Unit test for PR#12699
  ([13323](https://github.com/civicrm/civicrm-core/pull/13323))**

- **Add in unit test to support changes in UF API in PR 13343
  ([13344](https://github.com/civicrm/civicrm-core/pull/13344))**

- **(NFC) Tidy up comments, remove unused variables in customfield classes
  ([13367](https://github.com/civicrm/civicrm-core/pull/13367))**

- **Simplify handling for case checking.
  ([13372](https://github.com/civicrm/civicrm-core/pull/13372))**

- **[REF] Extract internals of Payment.create into function on BAO class.
  ([13370](https://github.com/civicrm/civicrm-core/pull/13370))**

- **[REF] Simplify CRM_Activity_BAO_Activity function by using early returns
  ([13371](https://github.com/civicrm/civicrm-core/pull/13371))**

- **[REF] Genericise function to add pseudoconstant data to fields to process
  ([13328](https://github.com/civicrm/civicrm-core/pull/13328))**

- **[REF] Add caching to function to determine if activity type is permitted.
  ([13329](https://github.com/civicrm/civicrm-core/pull/13329))**

- **[REF] Export add test for phone details, fix phone_type_id
  ([13275](https://github.com/civicrm/civicrm-core/pull/13275))**

- **[REF] Minor test clean up
  ([13269](https://github.com/civicrm/civicrm-core/pull/13269))**

- **[REF] Export cleanup - filter at point of query on postal exports
  ([13216](https://github.com/civicrm/civicrm-core/pull/13216))**

- **[REF] Build single array of information about output specifications when
  exporting ([13213](https://github.com/civicrm/civicrm-core/pull/13213))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt, Eli Lisseck; Andrew Thompson;
Australian Greens - Seamus Lee; Christian Wach; CiviCoop - Klaas Eikelboom;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Sunil Pawar, Yashodha Chaku;
CompuCorp - Davi Alexandre, Vinu Varshith Sekar; Coop SymbioTIC - Mathieu Lutfy;
Electronic Frontier Foundation - Mark Burdett; Francesc Bassas i Bullich; Fuzion -
Jitendra Purohit; Ginkgo Street Labs - Frank Gómez; iXiam - Luciano Spiegel;
JMA Consulting - Monish Deb; MillerTech - Chamil Wijesooriya; MJW Consulting -
Matthew Wire; Ray Wright; Squiffle Consulting - Aidan Saunders; Tadpole
Collective - Kevin Cristiano; Veda Consulting - Mathavan Veeramuthu; Wikimedia
Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Blackfly Solutions - Alan Dixon; Circle Interactive - Dave Jenkins; Fuzion -
Peter Davis; JMA Consulting - Joe Murray; John Kingsnorth; Joinery - Allen Shaw;
Lighthouse Design and Consulting - Brian Shaughnessy; Megaphone Technology
Consulting - Jon Goldberg; Nicol Wistreich; Richard van Oosterhout; Skvare -
Mark Hanna; Systopia - Björn Endres

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
