<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Campaign/Campaign.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:dbeaf967ec7d7d3532d4cacb2a0e36b4)
 */

/**
 * Database access object for the Campaign entity.
 */
class CRM_Campaign_DAO_Campaign extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '3.3';
  const COMPONENT = 'CiviCampaign';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_campaign';

  /**
   * Icon associated with this entity.
   *
   * @var string
   */
  public static $_icon = 'fa-bullhorn';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'title';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'add' => 'civicrm/campaign/add?reset=1',
    'update' => 'civicrm/campaign/add?reset=1&action=update&id=[id]',
    'delete' => 'civicrm/campaign/add?reset=1&action=delete&id=[id]',
  ];

  /**
   * Unique Campaign ID.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Name of the Campaign.
   *
   * @var string
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $name;

  /**
   * Title of the Campaign.
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $title;

  /**
   * Full description of Campaign.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $description;

  /**
   * Date and time that Campaign starts.
   *
   * @var string|null
   *   (SQL type: datetime)
   *   Note that values will be retrieved from the database as a string.
   */
  public $start_date;

  /**
   * Date and time that Campaign ends.
   *
   * @var string|null
   *   (SQL type: datetime)
   *   Note that values will be retrieved from the database as a string.
   */
  public $end_date;

  /**
   * Campaign Type ID.Implicit FK to civicrm_option_value where option_group = campaign_type
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $campaign_type_id;

  /**
   * Campaign status ID.Implicit FK to civicrm_option_value where option_group = campaign_status
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $status_id;

  /**
   * Unique trusted external ID (generally from a legacy app/datasource). Particularly useful for deduping operations.
   *
   * @var string|null
   *   (SQL type: varchar(32))
   *   Note that values will be retrieved from the database as a string.
   */
  public $external_identifier;

  /**
   * Optional parent id for this Campaign.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $parent_id;

  /**
   * Is this Campaign enabled or disabled/cancelled?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * FK to civicrm_contact, who created this Campaign.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_id;

  /**
   * Date and time that Campaign was created.
   *
   * @var string|null
   *   (SQL type: datetime)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_date;

  /**
   * FK to civicrm_contact, who recently edited this Campaign.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $last_modified_id;

  /**
   * Date and time that Campaign was edited last time.
   *
   * @var string|null
   *   (SQL type: datetime)
   *   Note that values will be retrieved from the database as a string.
   */
  public $last_modified_date;

  /**
   * General goals for Campaign.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $goal_general;

  /**
   * The target revenue for this campaign.
   *
   * @var float|string|null
   *   (SQL type: decimal(20,2))
   *   Note that values will be retrieved from the database as a string.
   */
  public $goal_revenue;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_campaign';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Campaigns') : ts('Campaign');
  }

  /**
   * Returns user-friendly description of this entity.
   *
   * @return string
   */
  public static function getEntityDescription() {
    return ts('Campaigns link activities, contributions, mailings, etc. that share a programmatic goal.');
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'parent_id', 'civicrm_campaign', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'created_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'last_modified_id', 'civicrm_contact', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Campaign ID'),
          'description' => ts('Unique Campaign ID.'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_campaign.id',
          'export' => TRUE,
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
            'label' => ts("ID"),
          ],
          'readonly' => TRUE,
          'add' => '3.3',
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Campaign Name'),
          'description' => ts('Name of the Campaign.'),
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_campaign.name',
          'export' => TRUE,
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Name"),
          ],
          'add' => '3.3',
        ],
        'title' => [
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Campaign Title'),
          'description' => ts('Title of the Campaign.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_campaign.title',
          'export' => TRUE,
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Title"),
          ],
          'add' => '3.3',
        ],
        'description' => [
          'name' => 'description',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Campaign Description'),
          'description' => ts('Full description of Campaign.'),
          'rows' => 8,
          'cols' => 60,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_campaign.description',
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'TextArea',
            'label' => ts("Description"),
          ],
          'add' => '3.3',
        ],
        'start_date' => [
          'name' => 'start_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Campaign Start Date'),
          'description' => ts('Date and time that Campaign starts.'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_campaign.start_date',
          'headerPattern' => '/^start|(s(tart\s)?date)$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
            'label' => ts("Start Date"),
          ],
          'add' => '3.3',
        ],
        'end_date' => [
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Campaign End Date'),
          'description' => ts('Date and time that Campaign ends.'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_campaign.end_date',
          'headerPattern' => '/^end|(e(nd\s)?date)$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
            'label' => ts("End Date"),
          ],
          'add' => '3.3',
        ],
        'campaign_type_id' => [
          'name' => 'campaign_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Campaign Type'),
          'description' => ts('Campaign Type ID.Implicit FK to civicrm_option_value where option_group = campaign_type'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_campaign.campaign_type_id',
          'export' => TRUE,
          'default' => NULL,
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Type"),
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'campaign_type',
            'optionEditPath' => 'civicrm/admin/options/campaign_type',
          ],
          'add' => '3.3',
        ],
        'status_id' => [
          'name' => 'status_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Campaign Status'),
          'description' => ts('Campaign status ID.Implicit FK to civicrm_option_value where option_group = campaign_status'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_campaign.status_id',
          'export' => TRUE,
          'default' => NULL,
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Status"),
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'campaign_status',
            'optionEditPath' => 'civicrm/admin/options/campaign_status',
          ],
          'add' => '3.3',
        ],
        'external_identifier' => [
          'name' => 'external_identifier',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Campaign External ID'),
          'description' => ts('Unique trusted external ID (generally from a legacy app/datasource). Particularly useful for deduping operations.'),
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_campaign.external_identifier',
          'headerPattern' => '/external\s?id/i',
          'dataPattern' => '/^\d{11,}$/',
          'export' => TRUE,
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("External ID"),
          ],
          'add' => '3.3',
        ],
        'parent_id' => [
          'name' => 'parent_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Parent Campaign ID'),
          'description' => ts('Optional parent id for this Campaign.'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_campaign.parent_id',
          'export' => TRUE,
          'default' => NULL,
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'FKClassName' => 'CRM_Campaign_DAO_Campaign',
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Parent Campaign"),
          ],
          'add' => '3.3',
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Campaign Active?'),
          'description' => ts('Is this Campaign enabled or disabled/cancelled?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_campaign.is_active',
          'default' => '1',
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Enabled"),
          ],
          'add' => '3.3',
        ],
        'created_id' => [
          'name' => 'created_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Created By Contact ID'),
          'description' => ts('FK to civicrm_contact, who created this Campaign.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_campaign.created_id',
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => [
            'label' => ts("Created By"),
          ],
          'add' => '3.3',
        ],
        'created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Campaign Created Date'),
          'description' => ts('Date and time that Campaign was created.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_campaign.created_date',
          'default' => 'CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
            'label' => ts("Created Date"),
          ],
          'readonly' => TRUE,
          'add' => '3.3',
        ],
        'last_modified_id' => [
          'name' => 'last_modified_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Modified By Contact ID'),
          'description' => ts('FK to civicrm_contact, who recently edited this Campaign.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_campaign.last_modified_id',
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => [
            'label' => ts("Modified By"),
          ],
          'add' => '3.3',
        ],
        'last_modified_date' => [
          'name' => 'last_modified_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Campaign Modified Date'),
          'description' => ts('Date and time that Campaign was edited last time.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_campaign.last_modified_date',
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'add' => '3.3',
        ],
        'goal_general' => [
          'name' => 'goal_general',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Campaign Goals'),
          'description' => ts('General goals for Campaign.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_campaign.goal_general',
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'RichTextEditor',
          ],
          'add' => '3.4',
        ],
        'goal_revenue' => [
          'name' => 'goal_revenue',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Goal Revenue'),
          'description' => ts('The target revenue for this campaign.'),
          'precision' => [
            20,
            2,
          ],
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_campaign.goal_revenue',
          'table_name' => 'civicrm_campaign',
          'entity' => 'Campaign',
          'bao' => 'CRM_Campaign_BAO_Campaign',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Goal Revenue"),
          ],
          'add' => '3.4',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'campaign', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'campaign', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_name' => [
        'name' => 'UI_name',
        'field' => [
          0 => 'name',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_campaign::1::name',
      ],
      'index_campaign_type_id' => [
        'name' => 'index_campaign_type_id',
        'field' => [
          0 => 'campaign_type_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_campaign::0::campaign_type_id',
      ],
      'index_status_id' => [
        'name' => 'index_status_id',
        'field' => [
          0 => 'status_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_campaign::0::status_id',
      ],
      'UI_external_identifier' => [
        'name' => 'UI_external_identifier',
        'field' => [
          0 => 'external_identifier',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_campaign::1::external_identifier',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
