# - Find sqlite3
# Find the native SQLite3 includes and library
#
#  SQLITE3_INCLUDE_DIR - where to find sqlite3.h
#  SQLITE3_LIBRARIES   - List of libraries when using SQLite3.
#  SQLITE3_FOUND       - True if SQLite3 found.

IF (SQLITE3_INCLUDE_DIR)
  # Already in cache, be silent
  SET(SQLite3_FIND_QUIETLY TRUE)
ENDIF (SQLITE3_INCLUDE_DIR)

FIND_PATH(SQLITE3_INCLUDE_DIR sqlite3.h
  /usr/local/include/sqlite3
  /usr/local/include
  /usr/include/sqlite3
  /usr/include
  ${CMAKE_SOURCE_DIR}/sqlite3
)

SET(SQLITE3_NAMES sqlite3)
FIND_LIBRARY(SQLITE3_LIBRARY
  NAMES ${SQLITE3_NAMES}
  PATHS /usr/local/lib /usr/lib 
  ${CMAKE_SOURCE_DIR}/sqlite3
)

IF (SQLITE3_INCLUDE_DIR AND SQLITE3_LIBRARY)
  SET(SQLITE3_FOUND TRUE)
  SET( SQLITE3_LIBRARIES ${SQLITE3_LIBRARY} )
ELSE (SQLITE3_INCLUDE_DIR AND SQLITE3_LIBRARY)
  SET(SQLITE3_FOUND FALSE)
  SET( SQLITE3_LIBRARIES )
ENDIF (SQLITE3_INCLUDE_DIR AND SQLITE3_LIBRARY)

IF (SQLITE3_FOUND)
  IF (NOT SQLite3_FIND_QUIETLY)
    MESSAGE(STATUS "Found SQLite3: ${SQLITE3_LIBRARY}")
  ENDIF (NOT SQLite3_FIND_QUIETLY)
ELSE (SQLITE3_FOUND)
  IF (SQLite3_FIND_REQUIRED)
    MESSAGE(STATUS "Looked for SQLite3 libraries named ${SQLITE3_NAMES}.")
    MESSAGE(FATAL_ERROR "Could NOT find SQLite3 library")
  ENDIF (SQLite3_FIND_REQUIRED)
ENDIF (SQLITE3_FOUND)

MARK_AS_ADVANCED(
  SQLITE3_LIBRARY
  SQLITE3_INCLUDE_DIR
)
